/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.datamanagement;

import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.model.common.UserAttributeContainer;
import de.aristaflow.adept2.model.datamanagement.InputDataContainer;
import de.aristaflow.adept2.model.datamanagement.InvalidDataTypeException;
import de.aristaflow.adept2.model.datamanagement.NoSuchParameterException;
import de.aristaflow.adept2.model.datamanagement.UDTValue;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import java.io.Serializable;
import java.net.URI;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public interface DataContainer
extends InputDataContainer,
UserAttributeContainer {
    public boolean isReadOnly();

    public void ignoreValue(SessionToken var1, String var2) throws NoSuchParameterException;

    public boolean ignoredValue(String var1) throws NoSuchParameterException;

    public void storeInteger(SessionToken var1, String var2, long var3) throws InvalidDataTypeException, NoSuchParameterException;

    public long storedInteger(String var1) throws InvalidDataTypeException, NoSuchParameterException;

    public void storeFloat(SessionToken var1, String var2, double var3) throws InvalidDataTypeException, NoSuchParameterException;

    public double storedFloat(String var1) throws InvalidDataTypeException, NoSuchParameterException;

    public void storeBoolean(SessionToken var1, String var2, boolean var3) throws InvalidDataTypeException, NoSuchParameterException;

    public boolean storedBoolean(String var1) throws InvalidDataTypeException, NoSuchParameterException;

    public void storeString(SessionToken var1, String var2, String var3) throws InvalidDataTypeException, NoSuchParameterException;

    public String storedString(String var1) throws InvalidDataTypeException, NoSuchParameterException;

    public void storeDate(SessionToken var1, String var2, Date var3) throws InvalidDataTypeException, NoSuchParameterException;

    public Date storedDate(String var1) throws InvalidDataTypeException, NoSuchParameterException;

    public void storeURI(SessionToken var1, String var2, URI var3) throws InvalidDataTypeException, NoSuchParameterException;

    public URI storedURI(String var1) throws InvalidDataTypeException, NoSuchParameterException;

    public void storeUDT(SessionToken var1, String var2, UDTValue var3) throws InvalidDataTypeException, NoSuchParameterException;

    public UDTValue storedUDT(String var1) throws InvalidDataTypeException, NoSuchParameterException;

    public void storeSessionState(SessionToken var1, int var2, byte[] var3);

    public byte[] restoreSessionState(SessionToken var1, int var2);

    public List<Integer> getStoredSavepoints(SessionToken var1);

    public int getLastSavepointID(SessionToken var1);

    public UUID getInstanceID();

    public int getNodeID();

    public int getNodeIteration();

    public Collection<String> getUnsavedParameterNames();

    public List<Savepoint> getUnsavedSessions();

    public Map<String, ProcessConstants.AdeptDataType> getUnsavedTypes();

    public Collection<String> getUnsavedIgnoredParameters();

    public Map<String, Serializable> getUnsavedValues();

    public static class Savepoint
    implements Serializable {
        private static final long serialVersionUID = 8014077497835906441L;
        private final int id;
        private final byte[] sessionState;

        public Savepoint(int id, byte[] sessionState) {
            this.id = id;
            this.sessionState = (byte[])(sessionState != null ? (byte[])sessionState.clone() : null);
        }

        public int getSavepointID() {
            return this.id;
        }

        public byte[] getSessionState() {
            return this.sessionState;
        }
    }
}

