/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.datamanagement;

import de.aristaflow.adept2.model.datamanagement.ADEPT2UDTValue;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.nio.charset.Charset;

public class FileUDTValue
extends ADEPT2UDTValue {
    private static final long serialVersionUID = -3230636509930820213L;
    protected final String fileName;

    protected static byte[] getContent(FileDescriptor fileDescriptor) throws IOException {
        byte[] ret;
        FileInputStream file;
        if (!fileDescriptor.fileValid()) {
            String msg = String.format("'%1$s' does not represent a valid file!", fileDescriptor.getFileName());
            throw new IllegalArgumentException(msg);
        }
        try {
            file = new FileInputStream(fileDescriptor.getFileName());
        }
        catch (FileNotFoundException fileNotFoundException) {
            String msg = String.format("File '%1$s' not found!", fileDescriptor.getFileName());
            throw new IllegalArgumentException(msg);
        }
        if (fileDescriptor.getCharset() != null) {
            StringBuilder content = new StringBuilder(file.available());
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)file, fileDescriptor.getCharset()));
            try {
                String line = reader.readLine();
                while (line != null) {
                    content.append(line);
                    content.append('\n');
                    line = reader.readLine();
                }
                content.deleteCharAt(content.length() - 1);
                ret = content.toString().getBytes("UTF-8");
            }
            finally {
                reader.close();
            }
        }
        ret = new byte[file.available()];
        BufferedInputStream reader = new BufferedInputStream(file);
        try {
            reader.read(ret);
        }
        finally {
            reader.close();
        }
        return ret;
    }

    public FileUDTValue(String userDefinedType, FileDescriptor fileDescriptor) throws IOException {
        super(userDefinedType, FileUDTValue.getContent(fileDescriptor));
        this.fileName = fileDescriptor.getFileName();
    }

    @Override
    public String toString() {
        return this.fileName;
    }

    @Override
    public boolean equals(Object obj) {
        boolean ret = false;
        if (obj instanceof FileUDTValue) {
            FileUDTValue udt = (FileUDTValue)obj;
            ret = this.fileName.equals(udt.fileName);
        }
        return ret && super.equals(obj);
    }

    @Override
    public int hashCode() {
        return this.fileName.hashCode() ^ super.hashCode();
    }

    public static class FileDescriptor
    implements Serializable {
        private static final long serialVersionUID = 8836339177543198512L;
        protected String fileName;
        protected String charset;

        public FileDescriptor(String fileName, boolean charContent) {
            this.fileName = fileName;
            this.charset = charContent ? "UTF-8" : null;
        }

        public FileDescriptor(String fileName, Charset charset) {
            this.fileName = fileName;
            this.charset = charset.name();
        }

        public String getFileName() {
            return this.fileName;
        }

        public Charset getCharset() {
            return this.charset != null ? Charset.forName(this.charset) : null;
        }

        public boolean fileValid() {
            boolean ret = this.fileName != null;
            try {
                ret = ret && new File(this.fileName).exists();
            }
            catch (SecurityException securityException) {
                ret = false;
            }
            return ret;
        }

        public String toString() {
            return this.fileName;
        }
    }
}

