/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.datamanagement;

import de.aristaflow.adept2.model.datamanagement.DataContainer;
import de.aristaflow.adept2.model.datamanagement.InputDataContainer;
import java.util.UUID;

public class InvalidDataContainerException
extends Exception {
    private static final long serialVersionUID = -1458224991755631807L;
    protected final InputDataContainer invalidDataContainer;
    protected final String invalidParameterName;
    protected final UUID instanceID;
    protected final int nodeID;
    protected final int nodeIteration;

    public InvalidDataContainerException(DataContainer invalidDataContainer, Throwable cause) {
        this(invalidDataContainer, null, cause);
    }

    public InvalidDataContainerException(DataContainer invalidDataContainer, String invalidParameterName, Throwable cause) {
        super(cause);
        this.invalidDataContainer = invalidDataContainer;
        this.invalidParameterName = invalidParameterName;
        this.instanceID = invalidDataContainer.getInstanceID();
        this.nodeID = invalidDataContainer.getNodeID();
        this.nodeIteration = invalidDataContainer.getNodeIteration();
    }

    public InvalidDataContainerException(InputDataContainer invalidDataContainer, String invalidParameterName, Throwable cause) {
        super(cause);
        this.invalidDataContainer = invalidDataContainer;
        this.invalidParameterName = invalidParameterName;
        this.instanceID = null;
        this.nodeID = Integer.MIN_VALUE;
        this.nodeIteration = Integer.MIN_VALUE;
    }

    public InvalidDataContainerException(InputDataContainer invalidDataContainer, String invalidParameterName) {
        this.invalidDataContainer = invalidDataContainer;
        this.invalidParameterName = invalidParameterName;
        this.instanceID = null;
        this.nodeID = Integer.MIN_VALUE;
        this.nodeIteration = Integer.MIN_VALUE;
    }

    public InvalidDataContainerException(InputDataContainer invalidDataContainer, UUID instanceID, int nodeID, int nodeIteration) {
        this.invalidDataContainer = invalidDataContainer;
        this.invalidParameterName = null;
        this.instanceID = instanceID;
        this.nodeID = nodeID;
        this.nodeIteration = nodeIteration;
    }

    public InputDataContainer getInvalidDataContainer() {
        return this.invalidDataContainer;
    }

    public String getInvalidParameterName() {
        return this.invalidParameterName;
    }

    public UUID getInstanceID() {
        return this.instanceID;
    }

    public int getNodeID() {
        return this.nodeID;
    }

    public int getNodeIteration() {
        return this.nodeIteration;
    }
}

