/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.datamanagement;

import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.util.ArgChecks;
import java.util.UUID;

public class InvalidDataTypeException
extends Exception {
    private static final long serialVersionUID = -5943159653476929286L;
    protected final String parameterName;
    protected final UUID instanceID;
    protected final Integer dataElementID;
    protected final ProcessConstants.AdeptDataType expectedDataType;
    protected final ProcessConstants.AdeptDataType actualDataType;

    public InvalidDataTypeException(String parameterName, ProcessConstants.AdeptDataType expectedDataType, ProcessConstants.AdeptDataType actualDataType) {
        ArgChecks.checkForBlank(parameterName, "parameterName");
        ArgChecks.checkForNull((Object)actualDataType, "actualDataType");
        this.parameterName = parameterName;
        this.instanceID = null;
        this.dataElementID = null;
        this.expectedDataType = expectedDataType;
        this.actualDataType = actualDataType;
    }

    public InvalidDataTypeException(UUID instanceID, int dataElementID, ProcessConstants.AdeptDataType expectedDataType, ProcessConstants.AdeptDataType actualDataType) {
        ArgChecks.checkForNull(instanceID, "instanceID");
        ArgChecks.checkForNull((Object)actualDataType, "actualDataType");
        this.parameterName = null;
        this.instanceID = instanceID;
        this.dataElementID = dataElementID;
        this.expectedDataType = expectedDataType;
        this.actualDataType = actualDataType;
    }

    public String getParameterName() {
        return this.parameterName;
    }

    public UUID getInstanceID() {
        return this.instanceID;
    }

    public Integer getDataElementID() {
        return this.dataElementID;
    }

    public ProcessConstants.AdeptDataType getActualDataType() {
        return this.actualDataType;
    }

    public ProcessConstants.AdeptDataType getExpectedDataType() {
        return this.expectedDataType;
    }
}

