/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.datamanagement.defaultimplementation;

import de.aristaflow.adept2.model.common.defaultimplementation.SerialisableUserAttributeContainer;
import de.aristaflow.adept2.model.datamanagement.InvalidDataTypeException;
import de.aristaflow.adept2.model.datamanagement.NoSuchParameterException;
import de.aristaflow.adept2.model.datamanagement.UDTValue;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.util.ArgChecks;
import java.io.Serializable;
import java.net.URI;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public abstract class AbstractMemoryBasedDataContainer
extends SerialisableUserAttributeContainer {
    private static final long serialVersionUID = 5170510148962311720L;
    protected Map<String, ProcessConstants.AdeptDataType> inParamsTypes = new HashMap<String, ProcessConstants.AdeptDataType>();
    protected Map<String, Serializable> inParamsValues = new HashMap<String, Serializable>();
    protected Collection<String> inParamsNullValues = new HashSet<String>();
    protected Map<String, ProcessConstants.AdeptDataType> outParamsTypes = new HashMap<String, ProcessConstants.AdeptDataType>();
    protected Map<String, Serializable> outParamsValues = new HashMap<String, Serializable>();
    protected Collection<String> outParamsNullValues = new HashSet<String>();

    protected AbstractMemoryBasedDataContainer() {
    }

    protected AbstractMemoryBasedDataContainer(Map<String, Serializable> inParamsValues, Map<String, ProcessConstants.AdeptDataType> inParamsTypes, Map<String, Serializable> outParamsValues, Map<String, ProcessConstants.AdeptDataType> outParamsTypes) {
        ProcessConstants.AdeptDataType determinedDataType;
        String msg;
        ProcessConstants.AdeptDataType type;
        Serializable value;
        String paramName;
        ArgChecks.checkForNullKey(inParamsValues, "inParamsValues");
        ArgChecks.checkForNullKey(outParamsValues, "outParamsValues");
        ArgChecks.checkForNulls(inParamsTypes, "inParamsTypes");
        ArgChecks.checkForNulls(outParamsTypes, "outParamsTypes");
        for (Map.Entry<String, Serializable> valueEntry : inParamsValues.entrySet()) {
            paramName = valueEntry.getKey();
            value = valueEntry.getValue();
            type = inParamsTypes.get(valueEntry.getKey());
            if (type == null) {
                msg = "The map 'inParamsValues' does not contain a data type for the input parameter '%s'!";
                msg = String.format(msg, paramName);
                throw new IllegalArgumentException(msg);
            }
            if (value == null) continue;
            determinedDataType = this.getTypeFor(value);
            if (determinedDataType == null) {
                String msg2 = "The value '%s' (of type %s) does not match any of ADEPT2's data types!";
                msg2 = String.format(msg2, value, value.getClass().getName());
                throw new IllegalArgumentException(msg2);
            }
            if (type == determinedDataType) continue;
            String msg3 = "The value of input parameter '%s' in the map 'inParamsValues' does not match the expected data type specified in the map 'inParamsTypes'!";
            msg3 = String.format(msg3, paramName);
            throw new IllegalArgumentException(msg3);
        }
        for (Map.Entry<String, Serializable> valueEntry : outParamsValues.entrySet()) {
            paramName = valueEntry.getKey();
            value = valueEntry.getValue();
            type = outParamsTypes.get(valueEntry.getKey());
            if (type == null) {
                msg = "The map 'outParamsValues' does not contain a data type for the output parameter '%s'!";
                msg = String.format(msg, paramName);
                throw new IllegalArgumentException(msg);
            }
            if (value == null) continue;
            determinedDataType = this.getTypeFor(value);
            if (determinedDataType == null) {
                String msg4 = "The value '%s' (of type %s) does not match any of ADEPT2's data types!";
                msg4 = String.format(msg4, value, value.getClass().getName());
                throw new IllegalArgumentException(msg4);
            }
            if (type == determinedDataType) continue;
            String msg5 = "The value of output parameter '%s' in the map 'outParamsValues' does not match the expected data type specified in the map 'outParamsTypes'!";
            msg5 = String.format(msg5, paramName);
            throw new IllegalArgumentException(msg5);
        }
        this.inParamsValues.putAll(inParamsValues);
        this.inParamsTypes.putAll(inParamsTypes);
        this.outParamsValues.putAll(outParamsValues);
        this.outParamsTypes.putAll(outParamsTypes);
    }

    protected void addInParam(String paramName, ProcessConstants.AdeptDataType dataType, Serializable value) {
        ArgChecks.checkForNull(paramName, "paramName");
        ArgChecks.checkForNull((Object)dataType, "dataType");
        if (this.inParamsTypes.containsKey(paramName)) {
            String msg = "The input parameter '%s' already exists!";
            msg = String.format(msg, paramName);
            throw new IllegalArgumentException(msg);
        }
        this.inParamsTypes.put(paramName, dataType);
        try {
            if (value != null) {
                this.setInParam(paramName, value);
            } else {
                this.setInParamNull(paramName);
            }
        }
        catch (NoSuchParameterException noSuchParameterException) {
        }
        catch (InvalidDataTypeException ex) {
            String msg = "The value object had an invalid data type!";
            throw new IllegalArgumentException(msg, ex);
        }
    }

    protected void removeInParam(String paramName) {
        ArgChecks.checkForNull(paramName, "paramName");
        if (!this.inParamsTypes.containsKey(paramName)) {
            String msg = "The input parameter '%s' does not exists!";
            msg = String.format(msg, paramName);
            throw new IllegalArgumentException(msg);
        }
        this.inParamsTypes.remove(paramName);
        this.inParamsValues.remove(paramName);
        this.inParamsNullValues.remove(paramName);
    }

    protected boolean hasInParam(String paramName) {
        ArgChecks.checkForNull(paramName, "paramName");
        return this.inParamsTypes.containsKey(paramName);
    }

    protected void addOutParam(String paramName, ProcessConstants.AdeptDataType dataType, Serializable value) {
        ArgChecks.checkForNull(paramName, "paramName");
        ArgChecks.checkForNull((Object)dataType, "dataType");
        if (this.outParamsTypes.containsKey(paramName)) {
            String msg = "The output parameter '%s' already exists!";
            msg = String.format(msg, paramName);
            throw new IllegalArgumentException(msg);
        }
        this.outParamsTypes.put(paramName, dataType);
        try {
            if (value != null) {
                this.setOutParam(paramName, value);
            } else {
                this.setOutParamNull(paramName);
            }
        }
        catch (NoSuchParameterException noSuchParameterException) {
        }
        catch (InvalidDataTypeException ex) {
            String msg = "The value object had an invalid data type!";
            throw new IllegalArgumentException(msg, ex);
        }
    }

    protected void removeOutParam(String paramName) {
        ArgChecks.checkForNull(paramName, "paramName");
        if (!this.outParamsTypes.containsKey(paramName)) {
            String msg = "The output parameter '%s' does not exists!";
            msg = String.format(msg, paramName);
            throw new IllegalArgumentException(msg);
        }
        this.outParamsTypes.remove(paramName);
        this.outParamsValues.remove(paramName);
        this.outParamsNullValues.remove(paramName);
    }

    protected boolean hasOutParam(String paramName) {
        ArgChecks.checkForNull(paramName, "paramName");
        return this.inParamsTypes.containsKey(paramName);
    }

    protected Object getOutParamUnchecked(String parameterName) throws NoSuchParameterException {
        ArgChecks.checkForNull(parameterName, "parameterName");
        if (!this.outParamsTypes.containsKey(parameterName)) {
            String msg = "Output parameter '%s' not found.";
            msg = String.format(msg, parameterName);
            throw new NoSuchParameterException(msg, parameterName);
        }
        return this.outParamsValues.get(parameterName);
    }

    protected Object getOutParam(String parameterName, ProcessConstants.AdeptDataType expectedDataType) throws NoSuchParameterException, InvalidDataTypeException {
        ArgChecks.checkForNull((Object)expectedDataType, "expectedDataType");
        Object value = this.getOutParamUnchecked(parameterName);
        ProcessConstants.AdeptDataType actualDataType = this.outParamsTypes.get(parameterName);
        if (actualDataType == null) {
            this.checkType(parameterName, value, expectedDataType);
        } else if (actualDataType != expectedDataType) {
            throw new InvalidDataTypeException(parameterName, expectedDataType, actualDataType);
        }
        return value;
    }

    protected void setOutParamNull(String parameterName) throws NoSuchParameterException {
        ArgChecks.checkForNull(parameterName, "parameterName");
        if (!this.outParamsTypes.containsKey(parameterName)) {
            String msg = "output parameter '%s' not found";
            msg = String.format(msg, parameterName);
            throw new NoSuchParameterException(msg, parameterName);
        }
        this.outParamsNullValues.add(parameterName);
        this.outParamsValues.remove(parameterName);
    }

    protected boolean getOutParamNull(String parameterName) throws NoSuchParameterException {
        ArgChecks.checkForNull(parameterName, "parameterName");
        if (!this.outParamsTypes.containsKey(parameterName)) {
            String msg = "output parameter '%s' not found";
            msg = String.format(msg, parameterName);
            throw new NoSuchParameterException(msg, parameterName);
        }
        return this.outParamsNullValues.contains(parameterName);
    }

    protected void setOutParam(String parameterName, Serializable value) throws NoSuchParameterException, InvalidDataTypeException {
        ArgChecks.checkForNull(parameterName, "parameterName");
        if (!this.outParamsTypes.containsKey(parameterName)) {
            String msg = "Output parameter '%s' not found.";
            msg = String.format(msg, parameterName);
            throw new NoSuchParameterException(msg, parameterName);
        }
        this.outParamsNullValues.remove(parameterName);
        if (value == null) {
            this.outParamsValues.put(parameterName, null);
        } else {
            ProcessConstants.AdeptDataType paramDataType = this.outParamsTypes.get(parameterName);
            ProcessConstants.AdeptDataType objectDataType = this.getTypeFor(value);
            if (objectDataType == null) {
                String msg = "The value '%s' (of type %s) does not match any of ADEPT2's data types!";
                msg = String.format(msg, value, value.getClass().getName());
                throw new IllegalArgumentException(msg);
            }
            if (paramDataType == null) {
                Object prevValue = this.getOutParamUnchecked(parameterName);
                if (prevValue != null) {
                    this.checkType(parameterName, value, this.getTypeFor(prevValue));
                }
            } else if (paramDataType != objectDataType) {
                throw new InvalidDataTypeException(parameterName, objectDataType, paramDataType);
            }
            this.outParamsValues.put(parameterName, value);
        }
    }

    protected Object getInParamUnchecked(String parameterName) throws NoSuchParameterException {
        if (!this.inParamsTypes.containsKey(parameterName)) {
            String msg = "Input parameter '%s' not found.";
            msg = String.format(msg, parameterName);
            throw new NoSuchParameterException(msg, parameterName);
        }
        return this.inParamsValues.get(parameterName);
    }

    protected Object getInParam(String parameterName, ProcessConstants.AdeptDataType expectedDataType) throws NoSuchParameterException, InvalidDataTypeException {
        ArgChecks.checkForNull((Object)expectedDataType, "expectedDataType");
        Object value = this.getInParamUnchecked(parameterName);
        ProcessConstants.AdeptDataType actualDataType = this.inParamsTypes.get(parameterName);
        if (actualDataType != null) {
            if (actualDataType != expectedDataType) {
                throw new InvalidDataTypeException(parameterName, expectedDataType, actualDataType);
            }
        } else {
            this.checkType(parameterName, value, expectedDataType);
        }
        return value;
    }

    protected void setInParamNull(String parameterName) throws NoSuchParameterException {
        ArgChecks.checkForNull(parameterName, "parameterName");
        if (!this.inParamsTypes.containsKey(parameterName)) {
            String msg = "input parameter '%s' not found";
            msg = String.format(msg, parameterName);
            throw new NoSuchParameterException(msg, parameterName);
        }
        this.inParamsNullValues.add(parameterName);
        this.inParamsValues.remove(parameterName);
    }

    protected boolean getInParamNull(String parameterName) throws NoSuchParameterException {
        ArgChecks.checkForNull(parameterName, "parameterName");
        if (!this.inParamsTypes.containsKey(parameterName)) {
            String msg = "input parameter '%s' not found";
            msg = String.format(msg, parameterName);
            throw new NoSuchParameterException(msg, parameterName);
        }
        return this.inParamsNullValues.contains(parameterName);
    }

    protected void setInParam(String parameterName, Serializable value) throws NoSuchParameterException, InvalidDataTypeException {
        ArgChecks.checkForNull(parameterName, "parameterName");
        if (!this.inParamsTypes.containsKey(parameterName)) {
            String msg = "input parameter '%s' not found";
            msg = String.format(msg, parameterName);
            throw new NoSuchParameterException(msg, parameterName);
        }
        this.inParamsNullValues.remove(parameterName);
        if (value == null) {
            this.inParamsValues.put(parameterName, null);
        } else {
            ProcessConstants.AdeptDataType paramDataType = this.inParamsTypes.get(parameterName);
            ProcessConstants.AdeptDataType objectDataType = this.getTypeFor(value);
            if (objectDataType == null) {
                String msg = "The value '%s' (of type %s) does not match any of ADEPT2's data types!";
                msg = String.format(msg, value, value.getClass().getName());
                throw new IllegalArgumentException(msg);
            }
            if (paramDataType == null) {
                Object prevValue = this.getInParamUnchecked(parameterName);
                if (prevValue != null) {
                    this.checkType(parameterName, value, this.getTypeFor(prevValue));
                }
            } else if (paramDataType != objectDataType) {
                throw new InvalidDataTypeException(parameterName, objectDataType, paramDataType);
            }
            this.inParamsValues.put(parameterName, value);
        }
    }

    public Map<String, ProcessConstants.AdeptDataType> getInputParameterTypes() {
        return new HashMap<String, ProcessConstants.AdeptDataType>(this.inParamsTypes);
    }

    public Collection<String> getInputParameterNullValues() {
        return new HashSet<String>(this.inParamsNullValues);
    }

    public Map<String, Serializable> getInputParameterValues() {
        return new HashMap<String, Serializable>(this.inParamsValues);
    }

    public Map<String, ProcessConstants.AdeptDataType> getOutputParameterTypes() {
        return new HashMap<String, ProcessConstants.AdeptDataType>(this.outParamsTypes);
    }

    public Collection<String> getOutputParameterNullValues() {
        return new HashSet<String>(this.outParamsNullValues);
    }

    public Map<String, Serializable> getOutputParameterValues() {
        return new HashMap<String, Serializable>(this.outParamsValues);
    }

    private void checkType(String parameterName, Object value, ProcessConstants.AdeptDataType expected) throws InvalidDataTypeException {
        ArgChecks.checkForNull(value, "value");
        ProcessConstants.AdeptDataType found = this.getTypeFor(value);
        if (found != expected) {
            throw new InvalidDataTypeException(parameterName, expected, found);
        }
    }

    private ProcessConstants.AdeptDataType getTypeFor(Object value) {
        ArgChecks.checkForNull(value, "value");
        ProcessConstants.AdeptDataType ret = value instanceof Long ? ProcessConstants.AdeptDataType.INTEGER : (value instanceof Double ? ProcessConstants.AdeptDataType.FLOAT : (value instanceof Boolean ? ProcessConstants.AdeptDataType.BOOLEAN : (value instanceof String ? ProcessConstants.AdeptDataType.STRING : (value instanceof Date ? ProcessConstants.AdeptDataType.DATE : (value instanceof URI ? ProcessConstants.AdeptDataType.URI : (value instanceof UDTValue ? ProcessConstants.AdeptDataType.USERDEFINED : null))))));
        return ret;
    }
}

