/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.datamanagement.defaultimplementation;

import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.model.datamanagement.ADEPT2UDTValue;
import de.aristaflow.adept2.model.datamanagement.DataContainer;
import de.aristaflow.adept2.model.datamanagement.IndexedAccessDataContainer;
import de.aristaflow.adept2.model.datamanagement.InvalidDataContainerException;
import de.aristaflow.adept2.model.datamanagement.InvalidDataTypeException;
import de.aristaflow.adept2.model.datamanagement.InvalidListValuedDataContainerException;
import de.aristaflow.adept2.model.datamanagement.InvalidUDTException;
import de.aristaflow.adept2.model.datamanagement.NoSuchParameterException;
import de.aristaflow.adept2.model.datamanagement.UDTValue;
import de.aristaflow.adept2.model.datamanagement.ValidationFailedException;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.ProcessModelParameter;
import de.aristaflow.adept2.util.ArgChecks;
import de.aristaflow.adept2.util.LoggerTools;
import de.aristaflow.adept2.util.StreamTools;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class DefaultIndexedAccessDataContainer
implements IndexedAccessDataContainer {
    private static final long serialVersionUID = -8347227092477096693L;
    public static final int GLOBAL_SAVEPOINT = Math.abs(Long.valueOf(-8347227092477096693L).hashCode());
    protected final DataContainer wrappedContainer;
    protected final Set<String> mandatoryOutputParameters;
    protected final Map<String, List<? extends Serializable>> indexedInputParameters;
    protected final Set<String> optionalIndexedInput;
    protected final Map<String, ArrayList<? extends Serializable>> outputParameters;
    protected final boolean[] validated;
    protected transient Logger logger;

    public DefaultIndexedAccessDataContainer(DataContainer wrappedContainer, Map<ProcessModelParameter, List<? extends Serializable>> indexedInputParameters, Collection<ProcessModelParameter> outputParameters, int listSize) {
        ArgChecks.checkForNull(wrappedContainer, "wrappedContainer");
        ArgChecks.checkForNonpositive(listSize, "listSize");
        this.logger = LoggerTools.getLogger(this);
        this.wrappedContainer = wrappedContainer;
        this.validated = new boolean[listSize];
        this.optionalIndexedInput = new HashSet<String>();
        if (indexedInputParameters == null) {
            indexedInputParameters = new HashMap<ProcessModelParameter, List<? extends Serializable>>(0);
        }
        this.indexedInputParameters = new HashMap<String, List<? extends Serializable>>(indexedInputParameters.size());
        for (Map.Entry<ProcessModelParameter, List<? extends Serializable>> inputParameter : indexedInputParameters.entrySet()) {
            this.indexedInputParameters.put(inputParameter.getKey().getName(), inputParameter.getValue());
            if (!inputParameter.getKey().isOptional()) continue;
            this.optionalIndexedInput.add(inputParameter.getKey().getName());
        }
        this.mandatoryOutputParameters = new HashSet<String>();
        if (outputParameters == null) {
            outputParameters = new HashSet<ProcessModelParameter>(0);
        }
        this.outputParameters = new HashMap<String, ArrayList<? extends Serializable>>(outputParameters.size());
        for (ProcessModelParameter outputParameter : outputParameters) {
            String parameterName = outputParameter.getName();
            if (!outputParameter.isOptional()) {
                this.mandatoryOutputParameters.add(parameterName);
            }
            ArrayList<Object> list = new ArrayList<Object>(listSize);
            int i = 0;
            while (i < listSize) {
                list.add(null);
                ++i;
            }
            this.outputParameters.put(parameterName, list);
        }
    }

    public DefaultIndexedAccessDataContainer(SessionToken session, DataContainer wrappedContainer, Set<String> indexedInputParameter, Set<String> optionalIndexedInput, Set<String> mandatoryOutputParameter, Map<String, UDTValue> outputParameter, boolean[] validated) throws InvalidDataContainerException {
        this.logger = LoggerTools.getLogger(this);
        this.wrappedContainer = wrappedContainer;
        this.validated = (boolean[])validated.clone();
        this.indexedInputParameters = new HashMap<String, List<? extends Serializable>>(indexedInputParameter.size());
        this.optionalIndexedInput = new HashSet<String>(optionalIndexedInput);
        for (String string : indexedInputParameter) {
            try {
                List values;
                if (wrappedContainer.isNull(session, string)) {
                    values = new ArrayList(0);
                } else {
                    UDTValue listValue = wrappedContainer.retrieveUDT(session, string);
                    values = (List)((Object)StreamTools.fromByteArray(listValue.getValueAsArray()));
                }
                this.indexedInputParameters.put(string, values);
            }
            catch (NoSuchParameterException nspe) {
                throw new InvalidDataContainerException(wrappedContainer, string, (Throwable)nspe);
            }
            catch (InvalidDataTypeException idte) {
                throw new InvalidListValuedDataContainerException(wrappedContainer, string, (Throwable)idte);
            }
            catch (IOException ioe) {
                throw new InvalidListValuedDataContainerException(wrappedContainer, string, (Throwable)ioe);
            }
            catch (ClassNotFoundException cnfe) {
                throw new InvalidListValuedDataContainerException(wrappedContainer, string, (Throwable)cnfe);
            }
        }
        this.mandatoryOutputParameters = new HashSet<String>(mandatoryOutputParameter);
        this.outputParameters = new HashMap<String, ArrayList<? extends Serializable>>(outputParameter.size());
        for (Map.Entry entry : outputParameter.entrySet()) {
            try {
                ArrayList<? extends Serializable> value = this.parseUDTValue((UDTValue)entry.getValue(), validated.length);
                this.outputParameters.put((String)entry.getKey(), value);
            }
            catch (IOException ioe) {
                throw new InvalidDataContainerException(wrappedContainer, (String)entry.getKey(), (Throwable)ioe);
            }
            catch (ClassNotFoundException cnfe) {
                throw new InvalidDataContainerException(wrappedContainer, (String)entry.getKey(), (Throwable)cnfe);
            }
        }
    }

    @Override
    public boolean isNull(SessionToken session, String parameterName) throws NoSuchParameterException {
        this.checkSimpleType(parameterName);
        return this.wrappedContainer.isNull(session, parameterName);
    }

    @Override
    public long retrieveInteger(SessionToken session, String parameterName) throws InvalidDataTypeException, NoSuchParameterException {
        this.checkSimpleType(parameterName);
        return this.wrappedContainer.retrieveInteger(session, parameterName);
    }

    @Override
    public double retrieveFloat(SessionToken session, String parameterName) throws InvalidDataTypeException, NoSuchParameterException {
        this.checkSimpleType(parameterName);
        return this.wrappedContainer.retrieveFloat(session, parameterName);
    }

    @Override
    public boolean retrieveBoolean(SessionToken session, String parameterName) throws InvalidDataTypeException, NoSuchParameterException {
        this.checkSimpleType(parameterName);
        return this.wrappedContainer.retrieveBoolean(session, parameterName);
    }

    @Override
    public String retrieveString(SessionToken session, String parameterName) throws InvalidDataTypeException, NoSuchParameterException {
        this.checkSimpleType(parameterName);
        return this.wrappedContainer.retrieveString(session, parameterName);
    }

    @Override
    public Date retrieveDate(SessionToken session, String parameterName) throws InvalidDataTypeException, NoSuchParameterException {
        this.checkSimpleType(parameterName);
        return this.wrappedContainer.retrieveDate(session, parameterName);
    }

    @Override
    public URI retrieveURI(SessionToken session, String parameterName) throws InvalidDataTypeException, NoSuchParameterException {
        this.checkSimpleType(parameterName);
        return this.wrappedContainer.retrieveURI(session, parameterName);
    }

    @Override
    public UDTValue retrieveUDT(SessionToken session, String parameterName) throws InvalidDataTypeException, NoSuchParameterException {
        this.checkSimpleType(parameterName);
        return this.wrappedContainer.retrieveUDT(session, parameterName);
    }

    protected void checkSimpleType(String parameterName) throws NoSuchParameterException {
        if (this.indexedInputParameters.containsKey(parameterName)) {
            String msg = String.format("Parameter '%s' is of type list and needs to be accessed with an index!", parameterName);
            throw new NoSuchParameterException(msg, parameterName);
        }
    }

    @Override
    public DataContainer getWrappedDataContainer() {
        return this.wrappedContainer;
    }

    @Override
    public boolean isNull(SessionToken session, String parameterName, int index) throws NoSuchParameterException {
        boolean ret;
        boolean bl = ret = !this.indexValid(parameterName, index);
        if (!ret) {
            List<? extends Serializable> values = this.getInputParameterValues(parameterName);
            ret = values.get(index) == null;
        }
        return ret;
    }

    @Override
    public long retrieveInteger(SessionToken session, String parameterName, int index) throws InvalidDataTypeException, NoSuchParameterException {
        long ret = -1L;
        if (!this.isNull(session, parameterName, index)) {
            try {
                List<? extends Serializable> values = this.getInputParameterValues(parameterName);
                ret = (Long)values.get(index);
            }
            catch (ClassCastException classCastException) {
                throw new InvalidDataTypeException(parameterName, ProcessConstants.AdeptDataType.INTEGER, ProcessConstants.AdeptDataType.USERDEFINED);
            }
        }
        return ret;
    }

    @Override
    public double retrieveFloat(SessionToken session, String parameterName, int index) throws InvalidDataTypeException, NoSuchParameterException {
        double ret = -1.0;
        if (!this.isNull(session, parameterName, index)) {
            try {
                List<? extends Serializable> values = this.getInputParameterValues(parameterName);
                ret = (Double)values.get(index);
            }
            catch (ClassCastException classCastException) {
                throw new InvalidDataTypeException(parameterName, ProcessConstants.AdeptDataType.FLOAT, ProcessConstants.AdeptDataType.USERDEFINED);
            }
        }
        return ret;
    }

    @Override
    public boolean retrieveBoolean(SessionToken session, String parameterName, int index) throws InvalidDataTypeException, NoSuchParameterException {
        boolean ret = false;
        if (!this.isNull(session, parameterName, index)) {
            try {
                List<? extends Serializable> values = this.getInputParameterValues(parameterName);
                ret = (Boolean)values.get(index);
            }
            catch (ClassCastException classCastException) {
                throw new InvalidDataTypeException(parameterName, ProcessConstants.AdeptDataType.BOOLEAN, ProcessConstants.AdeptDataType.USERDEFINED);
            }
        }
        return ret;
    }

    @Override
    public String retrieveString(SessionToken session, String parameterName, int index) throws InvalidDataTypeException, NoSuchParameterException {
        String ret = null;
        if (!this.isNull(session, parameterName, index)) {
            try {
                List<? extends Serializable> values = this.getInputParameterValues(parameterName);
                ret = (String)((Object)values.get(index));
            }
            catch (ClassCastException classCastException) {
                throw new InvalidDataTypeException(parameterName, ProcessConstants.AdeptDataType.STRING, ProcessConstants.AdeptDataType.USERDEFINED);
            }
        }
        return ret;
    }

    @Override
    public Date retrieveDate(SessionToken session, String parameterName, int index) throws InvalidDataTypeException, NoSuchParameterException {
        Date ret = null;
        if (!this.isNull(session, parameterName, index)) {
            try {
                List<? extends Serializable> values = this.getInputParameterValues(parameterName);
                ret = (Date)values.get(index);
            }
            catch (ClassCastException classCastException) {
                throw new InvalidDataTypeException(parameterName, ProcessConstants.AdeptDataType.DATE, ProcessConstants.AdeptDataType.USERDEFINED);
            }
        }
        return ret;
    }

    @Override
    public URI retrieveURI(SessionToken session, String parameterName, int index) throws InvalidDataTypeException, NoSuchParameterException {
        URI ret = null;
        if (!this.isNull(session, parameterName, index)) {
            try {
                List<? extends Serializable> values = this.getInputParameterValues(parameterName);
                ret = (URI)values.get(index);
            }
            catch (ClassCastException classCastException) {
                throw new InvalidDataTypeException(parameterName, ProcessConstants.AdeptDataType.URI, ProcessConstants.AdeptDataType.USERDEFINED);
            }
        }
        return ret;
    }

    @Override
    public UDTValue retrieveUDT(SessionToken session, String parameterName, int index) throws InvalidDataTypeException, NoSuchParameterException {
        UDTValue ret = null;
        if (!this.isNull(session, parameterName, index)) {
            try {
                List<? extends Serializable> values = this.getInputParameterValues(parameterName);
                ret = (UDTValue)values.get(index);
            }
            catch (ClassCastException classCastException) {
                String expctUDT = String.format("java.util.List<%s>", ProcessConstants.AdeptDataType.USERDEFINED.name());
                throw new InvalidUDTException(parameterName, expctUDT, "");
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void ignoreValue(SessionToken session, String parameterName, int index) throws NoSuchParameterException {
        this.indexValid(parameterName, index);
        Map<String, ArrayList<? extends Serializable>> map = this.outputParameters;
        synchronized (map) {
            List<? extends Serializable> values = this.getOutputParameterValues(parameterName);
            values.set(index, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean ignoredValue(String parameterName, int index) throws NoSuchParameterException {
        boolean ret;
        this.indexValid(parameterName, index);
        Map<String, ArrayList<? extends Serializable>> map = this.outputParameters;
        synchronized (map) {
            List<? extends Serializable> values = this.getOutputParameterValues(parameterName);
            ret = values.get(index) == null;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeInteger(SessionToken session, String parameterName, int index, long value) throws InvalidDataTypeException, NoSuchParameterException {
        Map<String, ArrayList<? extends Serializable>> map = this.outputParameters;
        synchronized (map) {
            this.indexValid(parameterName, index);
            try {
                List<? extends Serializable> values = this.getOutputParameterValues(parameterName);
                values.set(index, (Serializable)value);
            }
            catch (ClassCastException classCastException) {
                throw new InvalidDataTypeException(parameterName, ProcessConstants.AdeptDataType.INTEGER, ProcessConstants.AdeptDataType.USERDEFINED);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long storedInteger(String parameterName, int index) throws InvalidDataTypeException, NoSuchParameterException {
        long ret = -1L;
        Map<String, ArrayList<? extends Serializable>> map = this.outputParameters;
        synchronized (map) {
            if (!this.ignoredValue(parameterName, index)) {
                try {
                    List<? extends Serializable> values = this.getOutputParameterValues(parameterName);
                    ret = (Long)values.get(index);
                }
                catch (ClassCastException classCastException) {
                    throw new InvalidDataTypeException(parameterName, ProcessConstants.AdeptDataType.INTEGER, ProcessConstants.AdeptDataType.USERDEFINED);
                }
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeFloat(SessionToken session, String parameterName, int index, double value) throws InvalidDataTypeException, NoSuchParameterException {
        Map<String, ArrayList<? extends Serializable>> map = this.outputParameters;
        synchronized (map) {
            this.indexValid(parameterName, index);
            try {
                List<? extends Serializable> values = this.getOutputParameterValues(parameterName);
                values.set(index, (Serializable)value);
            }
            catch (ClassCastException classCastException) {
                throw new InvalidDataTypeException(parameterName, ProcessConstants.AdeptDataType.FLOAT, ProcessConstants.AdeptDataType.USERDEFINED);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double storedFloat(String parameterName, int index) throws InvalidDataTypeException, NoSuchParameterException {
        double ret = -1.0;
        Map<String, ArrayList<? extends Serializable>> map = this.outputParameters;
        synchronized (map) {
            if (!this.ignoredValue(parameterName, index)) {
                try {
                    List<? extends Serializable> values = this.getOutputParameterValues(parameterName);
                    ret = (Double)values.get(index);
                }
                catch (ClassCastException classCastException) {
                    throw new InvalidDataTypeException(parameterName, ProcessConstants.AdeptDataType.FLOAT, ProcessConstants.AdeptDataType.USERDEFINED);
                }
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeBoolean(SessionToken session, String parameterName, int index, boolean value) throws InvalidDataTypeException, NoSuchParameterException {
        Map<String, ArrayList<? extends Serializable>> map = this.outputParameters;
        synchronized (map) {
            this.indexValid(parameterName, index);
            try {
                List<? extends Serializable> values = this.getOutputParameterValues(parameterName);
                values.set(index, (Serializable)value);
            }
            catch (ClassCastException classCastException) {
                throw new InvalidDataTypeException(parameterName, ProcessConstants.AdeptDataType.BOOLEAN, ProcessConstants.AdeptDataType.USERDEFINED);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean storedBoolean(String parameterName, int index) throws InvalidDataTypeException, NoSuchParameterException {
        boolean ret = false;
        Map<String, ArrayList<? extends Serializable>> map = this.outputParameters;
        synchronized (map) {
            if (!this.ignoredValue(parameterName, index)) {
                try {
                    List<? extends Serializable> values = this.getOutputParameterValues(parameterName);
                    ret = (Boolean)values.get(index);
                }
                catch (ClassCastException classCastException) {
                    throw new InvalidDataTypeException(parameterName, ProcessConstants.AdeptDataType.BOOLEAN, ProcessConstants.AdeptDataType.USERDEFINED);
                }
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeString(SessionToken session, String parameterName, int index, String value) throws InvalidDataTypeException, NoSuchParameterException {
        Map<String, ArrayList<? extends Serializable>> map = this.outputParameters;
        synchronized (map) {
            this.indexValid(parameterName, index);
            try {
                List<? extends Serializable> values = this.getOutputParameterValues(parameterName);
                values.set(index, (Serializable)((Object)value));
            }
            catch (ClassCastException classCastException) {
                throw new InvalidDataTypeException(parameterName, ProcessConstants.AdeptDataType.STRING, ProcessConstants.AdeptDataType.USERDEFINED);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String storedString(String parameterName, int index) throws InvalidDataTypeException, NoSuchParameterException {
        String ret = null;
        Map<String, ArrayList<? extends Serializable>> map = this.outputParameters;
        synchronized (map) {
            if (!this.ignoredValue(parameterName, index)) {
                try {
                    List<? extends Serializable> values = this.getOutputParameterValues(parameterName);
                    ret = (String)((Object)values.get(index));
                }
                catch (ClassCastException classCastException) {
                    throw new InvalidDataTypeException(parameterName, ProcessConstants.AdeptDataType.STRING, ProcessConstants.AdeptDataType.USERDEFINED);
                }
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeDate(SessionToken session, String parameterName, int index, Date value) throws InvalidDataTypeException, NoSuchParameterException {
        Map<String, ArrayList<? extends Serializable>> map = this.outputParameters;
        synchronized (map) {
            this.indexValid(parameterName, index);
            try {
                List<? extends Serializable> values = this.getOutputParameterValues(parameterName);
                values.set(index, value);
            }
            catch (ClassCastException classCastException) {
                throw new InvalidDataTypeException(parameterName, ProcessConstants.AdeptDataType.DATE, ProcessConstants.AdeptDataType.USERDEFINED);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Date storedDate(String parameterName, int index) throws InvalidDataTypeException, NoSuchParameterException {
        Date ret = null;
        Map<String, ArrayList<? extends Serializable>> map = this.outputParameters;
        synchronized (map) {
            if (!this.ignoredValue(parameterName, index)) {
                try {
                    List<? extends Serializable> values = this.getOutputParameterValues(parameterName);
                    ret = (Date)values.get(index);
                }
                catch (ClassCastException classCastException) {
                    throw new InvalidDataTypeException(parameterName, ProcessConstants.AdeptDataType.DATE, ProcessConstants.AdeptDataType.USERDEFINED);
                }
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeURI(SessionToken session, String parameterName, int index, URI value) throws InvalidDataTypeException, NoSuchParameterException {
        Map<String, ArrayList<? extends Serializable>> map = this.outputParameters;
        synchronized (map) {
            this.indexValid(parameterName, index);
            try {
                List<? extends Serializable> values = this.getOutputParameterValues(parameterName);
                values.set(index, value);
            }
            catch (ClassCastException classCastException) {
                throw new InvalidDataTypeException(parameterName, ProcessConstants.AdeptDataType.URI, ProcessConstants.AdeptDataType.USERDEFINED);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public URI storedURI(String parameterName, int index) throws InvalidDataTypeException, NoSuchParameterException {
        URI ret = null;
        Map<String, ArrayList<? extends Serializable>> map = this.outputParameters;
        synchronized (map) {
            if (!this.ignoredValue(parameterName, index)) {
                try {
                    List<? extends Serializable> values = this.getOutputParameterValues(parameterName);
                    ret = (URI)values.get(index);
                }
                catch (ClassCastException classCastException) {
                    throw new InvalidDataTypeException(parameterName, ProcessConstants.AdeptDataType.URI, ProcessConstants.AdeptDataType.USERDEFINED);
                }
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeUDT(SessionToken session, String parameterName, int index, UDTValue value) throws InvalidDataTypeException, NoSuchParameterException {
        Map<String, ArrayList<? extends Serializable>> map = this.outputParameters;
        synchronized (map) {
            this.indexValid(parameterName, index);
            try {
                List<? extends Serializable> values = this.getOutputParameterValues(parameterName);
                values.set(index, value);
            }
            catch (ClassCastException classCastException) {
                String expctUDT = String.format("java.util.List<%s>", ProcessConstants.AdeptDataType.USERDEFINED.name());
                throw new InvalidUDTException(parameterName, expctUDT, "");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UDTValue storedUDT(String parameterName, int index) throws InvalidDataTypeException, NoSuchParameterException {
        UDTValue ret = null;
        Map<String, ArrayList<? extends Serializable>> map = this.outputParameters;
        synchronized (map) {
            if (!this.ignoredValue(parameterName, index)) {
                try {
                    List<? extends Serializable> values = this.getOutputParameterValues(parameterName);
                    ret = (UDTValue)values.get(index);
                }
                catch (ClassCastException classCastException) {
                    String expctUDT = String.format("java.util.List<%s>", ProcessConstants.AdeptDataType.USERDEFINED.name());
                    throw new InvalidUDTException(parameterName, expctUDT, "");
                }
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void validateWrittenValues(SessionToken session, int index) throws ValidationFailedException {
        if (index < 0 || index >= this.validated.length) {
            String msg = String.format("Index %d does not conform to 0 <= i < %d!", index, this.validated.length);
            throw new IndexOutOfBoundsException(msg);
        }
        Object object = this.validated;
        synchronized (this.validated) {
            this.validated[index] = true;
            // ** MonitorExit[var3_4 /* !! */ ] (shouldn't be in output)
            Map<String, ArrayList<? extends Serializable>> map = this.outputParameters;
            object = map;
            synchronized (map) {
                for (String mandOutput : this.mandatoryOutputParameters) {
                    if (this.outputParameters.get(mandOutput) != null && this.outputParameters.get(mandOutput).get(index) != null) continue;
                    String msg = String.format("The subprocess at %d does not write the mandatory output parameter %s", index, mandOutput);
                    throw new ValidationFailedException(msg);
                }
                // ** MonitorExit[var3_4 /* !! */ ] (shouldn't be in output)
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean validatedAll() {
        boolean[] blArray = this.validated;
        synchronized (this.validated) {
            boolean ret = true;
            int i = 0;
            while (i < this.validated.length) {
                boolean bl = ret = ret && this.validated[i];
                if (!ret) break;
                ++i;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush(SessionToken session) throws InvalidDataContainerException {
        Map<String, ArrayList<? extends Serializable>> map = this.outputParameters;
        synchronized (map) {
            for (Map.Entry<String, ArrayList<? extends Serializable>> outputParameter : this.outputParameters.entrySet()) {
                try {
                    boolean isNull = true;
                    for (Serializable serializable : outputParameter.getValue()) {
                        if (serializable == null) continue;
                        isNull = false;
                        break;
                    }
                    if (isNull) {
                        this.wrappedContainer.ignoredValue(outputParameter.getKey());
                        continue;
                    }
                    UDTValue uDTValue = this.createAndMergeOutputValue(outputParameter.getKey());
                    this.wrappedContainer.storeUDT(session, outputParameter.getKey(), uDTValue);
                }
                catch (NoSuchParameterException nspe) {
                    throw new InvalidDataContainerException(this.wrappedContainer, outputParameter.getKey(), (Throwable)nspe);
                }
                catch (InvalidDataTypeException idte) {
                    throw new InvalidListValuedDataContainerException(this.wrappedContainer, outputParameter.getKey(), (Throwable)idte);
                }
                catch (IOException ioe) {
                    throw new InvalidListValuedDataContainerException(this.wrappedContainer, outputParameter.getKey(), (Throwable)ioe);
                }
            }
        }
    }

    protected boolean indexValid(String parameter, int index) throws NoSuchParameterException {
        boolean ret;
        if (this.optionalIndexedInput.contains(parameter)) {
            List<? extends Serializable> values = this.getInputParameterValues(parameter);
            ret = index >= 0 && index < values.size();
        } else {
            if (index < 0 || index >= this.validated.length) {
                String msg = String.format("Index %d does not conform to 0 <= i < %d!", index, this.validated.length);
                throw new NoSuchParameterException(msg, parameter);
            }
            ret = true;
        }
        return ret;
    }

    protected List<? extends Serializable> getInputParameterValues(String parameterName) throws NoSuchParameterException {
        if (!this.indexedInputParameters.containsKey(parameterName)) {
            String msg = String.format("Input parameter '%s' is not of type list and needs to be accessed directly!", parameterName);
            throw new NoSuchParameterException(msg, parameterName);
        }
        return this.indexedInputParameters.get(parameterName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<? extends Serializable> getOutputParameterValues(String parameterName) throws NoSuchParameterException {
        Map<String, ArrayList<? extends Serializable>> map = this.outputParameters;
        synchronized (map) {
            if (!this.outputParameters.containsKey(parameterName)) {
                String msg = String.format("Output parameter '%s' is not of type list and needs to be accessed directly!", parameterName);
                throw new NoSuchParameterException(msg, parameterName);
            }
            return this.outputParameters.get(parameterName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UDTValue createAndMergeOutputValue(String parameterName) throws IOException {
        UDTValue ret;
        ArrayList<Serializable> values = new ArrayList<Serializable>(this.validated.length);
        List<? extends Serializable> inputValues = this.indexedInputParameters.get(parameterName);
        Map<String, ArrayList<? extends Serializable>> map = this.outputParameters;
        synchronized (map) {
            List outputValues = this.outputParameters.get(parameterName);
            if (inputValues != null) {
                int i = 0;
                while (i < Math.max(inputValues.size(), outputValues.size())) {
                    Serializable inputValue = null;
                    Serializable outputValue = null;
                    if (i < outputValues.size()) {
                        outputValue = (Serializable)outputValues.get(i);
                    }
                    if (i < inputValues.size()) {
                        inputValue = inputValues.get(i);
                    }
                    values.add(outputValue != null ? outputValue : inputValue);
                    ++i;
                }
                byte[] bytes = StreamTools.toByteArray(values);
                ret = new ADEPT2UDTValue("java.util.List", bytes);
            } else {
                ret = this.createUDTValue(parameterName);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UDTValue createUDTValue(String parameterName) throws IOException {
        ArrayList<? extends Serializable> values;
        Map<String, ArrayList<? extends Serializable>> map = this.outputParameters;
        synchronized (map) {
            values = this.outputParameters.get(parameterName);
        }
        return new ADEPT2UDTValue("java.util.List", StreamTools.toByteArray(values));
    }

    private ArrayList<? extends Serializable> parseUDTValue(UDTValue value, int listSize) throws IOException, ClassNotFoundException {
        ArrayList ret;
        if (value != null) {
            byte[] bytes = value.getValueAsArray();
            ret = (ArrayList)StreamTools.fromByteArray(bytes);
        } else {
            ret = new ArrayList(listSize);
        }
        return ret;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.logger = LoggerTools.getLogger(this);
    }

    public Set<String> getIndexedInputParameter() {
        return Collections.unmodifiableSet(new HashSet<String>(this.indexedInputParameters.keySet()));
    }

    public Set<String> getOptionalIndexedInputParameter() {
        return Collections.unmodifiableSet(new HashSet<String>(this.optionalIndexedInput));
    }

    public Set<String> getMandatoryOutputParameter() {
        return Collections.unmodifiableSet(new HashSet<String>(this.mandatoryOutputParameters));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, UDTValue> getOutputParameterValues() {
        HashMap<String, UDTValue> ret;
        Map<String, ArrayList<? extends Serializable>> map = this.outputParameters;
        synchronized (map) {
            ret = new HashMap<String, UDTValue>(this.outputParameters.size());
            for (Map.Entry<String, ArrayList<? extends Serializable>> param : this.outputParameters.entrySet()) {
                String paramName = param.getKey();
                try {
                    ret.put(paramName, this.createUDTValue(paramName));
                }
                catch (IOException ioe) {
                    String msg = "Could not create the UDTValue (list) for the indexed output parameter '%s'. This is a serious problem, the creation should be no problem at all.";
                    throw new RuntimeException(String.format(msg, paramName), ioe);
                }
            }
        }
        return Collections.unmodifiableMap(ret);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean[] getValidated() {
        boolean[] blArray = this.validated;
        synchronized (this.validated) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return (boolean[])this.validated.clone();
        }
    }

    @Override
    public void storeSessionState(SessionToken session, int savepointID, int index, InputStream sessionState) {
        throw new UnsupportedOperationException();
    }

    @Override
    public InputStream restoreSessionState(SessionToken session, int savepointID, int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int[] getStoredSavepoints(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getLastSavepointID(int index) {
        throw new UnsupportedOperationException();
    }
}

