/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.datamanagement.defaultimplementation;

import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.model.datamanagement.DataContainer;
import de.aristaflow.adept2.model.datamanagement.InvalidDataTypeException;
import de.aristaflow.adept2.model.datamanagement.NoSuchParameterException;
import de.aristaflow.adept2.model.datamanagement.UDTValue;
import de.aristaflow.adept2.model.datamanagement.defaultimplementation.AbstractMemoryBasedDataContainer;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.util.NullArgumentException;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class DefaultReadableDataContainer
extends AbstractMemoryBasedDataContainer
implements DataContainer {
    private static final long serialVersionUID = -26609075255779669L;
    private final UUID instanceID;
    private final int nodeID;
    private final int nodeIteration;
    private final int lastSavepointID;
    private final byte[] sessionState;

    public DefaultReadableDataContainer(Map<String, Serializable> inParamValues, Map<String, ProcessConstants.AdeptDataType> inParamTypes, Map<String, Serializable> outParamValues, Map<String, ProcessConstants.AdeptDataType> outParamTypes, UUID instanceID, int nodeID, int nodeIteration) {
        this(inParamValues, inParamTypes, outParamValues, outParamTypes, instanceID, nodeID, nodeIteration, -1, null);
    }

    public DefaultReadableDataContainer(Map<String, Serializable> inParamValues, Map<String, ProcessConstants.AdeptDataType> inParamTypes, Map<String, Serializable> outParamValues, Map<String, ProcessConstants.AdeptDataType> outParamTypes, UUID instanceID, int nodeID, int nodeIteration, int lastSavepointID, byte[] sessionState) {
        super(inParamValues, inParamTypes, outParamValues, outParamTypes);
        this.instanceID = instanceID;
        this.nodeID = nodeID;
        this.nodeIteration = nodeIteration;
        this.lastSavepointID = lastSavepointID;
        this.sessionState = (byte[])(sessionState != null ? (byte[])sessionState.clone() : null);
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public boolean ignoredValue(String parameterName) throws NoSuchParameterException {
        if (parameterName == null) {
            throw new NullArgumentException("The parameter 'parameterName' must not be null!");
        }
        return this.getOutParamUnchecked(parameterName) == null;
    }

    @Override
    public long storedInteger(String parameterName) throws InvalidDataTypeException, NoSuchParameterException {
        if (parameterName == null) {
            throw new NullArgumentException("The parameter 'parameterName' must not be null!");
        }
        if (this.ignoredValue(parameterName)) {
            return 0L;
        }
        return (Long)this.getOutParam(parameterName, ProcessConstants.AdeptDataType.INTEGER);
    }

    @Override
    public double storedFloat(String parameterName) throws InvalidDataTypeException, NoSuchParameterException {
        if (parameterName == null) {
            throw new NullArgumentException("The parameter 'parameterName' must not be null!");
        }
        if (this.ignoredValue(parameterName)) {
            return 0.0;
        }
        return (Double)this.getOutParam(parameterName, ProcessConstants.AdeptDataType.FLOAT);
    }

    @Override
    public boolean storedBoolean(String parameterName) throws InvalidDataTypeException, NoSuchParameterException {
        if (parameterName == null) {
            throw new NullArgumentException("The parameter 'parameterName' must not be null!");
        }
        if (this.ignoredValue(parameterName)) {
            return false;
        }
        return (Boolean)this.getOutParam(parameterName, ProcessConstants.AdeptDataType.BOOLEAN);
    }

    @Override
    public String storedString(String parameterName) throws InvalidDataTypeException, NoSuchParameterException {
        if (parameterName == null) {
            throw new NullArgumentException("The parameter 'parameterName' must not be null!");
        }
        if (this.ignoredValue(parameterName)) {
            return null;
        }
        return (String)this.getOutParam(parameterName, ProcessConstants.AdeptDataType.STRING);
    }

    @Override
    public Date storedDate(String parameterName) throws InvalidDataTypeException, NoSuchParameterException {
        if (parameterName == null) {
            throw new NullArgumentException("The parameter 'parameterName' must not be null!");
        }
        if (this.ignoredValue(parameterName)) {
            return null;
        }
        return (Date)this.getOutParam(parameterName, ProcessConstants.AdeptDataType.DATE);
    }

    @Override
    public URI storedURI(String parameterName) throws InvalidDataTypeException, NoSuchParameterException {
        if (parameterName == null) {
            throw new NullArgumentException("The parameter 'parameterName' must not be null!");
        }
        if (this.ignoredValue(parameterName)) {
            return null;
        }
        return (URI)this.getOutParam(parameterName, ProcessConstants.AdeptDataType.URI);
    }

    @Override
    public UDTValue storedUDT(String parameterName) throws InvalidDataTypeException, NoSuchParameterException {
        if (parameterName == null) {
            throw new NullArgumentException("The parameter 'parameterName' must not be null!");
        }
        if (this.ignoredValue(parameterName)) {
            return null;
        }
        return (UDTValue)this.getOutParam(parameterName, ProcessConstants.AdeptDataType.USERDEFINED);
    }

    @Override
    public boolean isNull(SessionToken session, String parameterName) throws NoSuchParameterException {
        if (parameterName == null) {
            throw new NullArgumentException("The parameter 'parameterName' must not be null!");
        }
        return this.getInParamUnchecked(parameterName) == null;
    }

    @Override
    public long retrieveInteger(SessionToken session, String parameterName) throws InvalidDataTypeException, NoSuchParameterException {
        if (parameterName == null) {
            throw new NullArgumentException("The parameter 'parameterName' must not be null!");
        }
        if (this.isNull(session, parameterName)) {
            return 0L;
        }
        return (Long)this.getInParam(parameterName, ProcessConstants.AdeptDataType.INTEGER);
    }

    @Override
    public double retrieveFloat(SessionToken session, String parameterName) throws InvalidDataTypeException, NoSuchParameterException {
        if (parameterName == null) {
            throw new NullArgumentException("The parameter 'parameterName' must not be null!");
        }
        if (this.isNull(session, parameterName)) {
            return 0.0;
        }
        return (Double)this.getInParam(parameterName, ProcessConstants.AdeptDataType.FLOAT);
    }

    @Override
    public boolean retrieveBoolean(SessionToken session, String parameterName) throws InvalidDataTypeException, NoSuchParameterException {
        if (parameterName == null) {
            throw new NullArgumentException("The parameter 'parameterName' must not be null!");
        }
        if (this.isNull(session, parameterName)) {
            return false;
        }
        return (Boolean)this.getInParam(parameterName, ProcessConstants.AdeptDataType.BOOLEAN);
    }

    @Override
    public String retrieveString(SessionToken session, String parameterName) throws InvalidDataTypeException, NoSuchParameterException {
        if (parameterName == null) {
            throw new NullArgumentException("The parameter 'parameterName' must not be null!");
        }
        if (this.isNull(session, parameterName)) {
            return null;
        }
        return (String)this.getInParam(parameterName, ProcessConstants.AdeptDataType.STRING);
    }

    @Override
    public Date retrieveDate(SessionToken session, String parameterName) throws InvalidDataTypeException, NoSuchParameterException {
        if (parameterName == null) {
            throw new NullArgumentException("The parameter 'parameterName' must not be null!");
        }
        if (this.isNull(session, parameterName)) {
            return null;
        }
        return (Date)this.getInParam(parameterName, ProcessConstants.AdeptDataType.DATE);
    }

    @Override
    public URI retrieveURI(SessionToken session, String parameterName) throws InvalidDataTypeException, NoSuchParameterException {
        if (parameterName == null) {
            throw new NullArgumentException("The parameter 'parameterName' must not be null!");
        }
        if (this.isNull(session, parameterName)) {
            return null;
        }
        return (URI)this.getInParam(parameterName, ProcessConstants.AdeptDataType.URI);
    }

    @Override
    public UDTValue retrieveUDT(SessionToken session, String parameterName) throws InvalidDataTypeException, NoSuchParameterException {
        if (parameterName == null) {
            throw new NullArgumentException("The parameter 'parameterName' must not be null!");
        }
        if (this.isNull(session, parameterName)) {
            return null;
        }
        return (UDTValue)this.getInParam(parameterName, ProcessConstants.AdeptDataType.USERDEFINED);
    }

    @Override
    public void ignoreValue(SessionToken session, String parameterName) throws NoSuchParameterException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void storeInteger(SessionToken session, String parameterName, long value) throws InvalidDataTypeException, NoSuchParameterException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void storeFloat(SessionToken session, String parameterName, double value) throws InvalidDataTypeException, NoSuchParameterException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void storeBoolean(SessionToken session, String parameterName, boolean value) throws InvalidDataTypeException, NoSuchParameterException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void storeString(SessionToken session, String parameterName, String value) throws InvalidDataTypeException, NoSuchParameterException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void storeDate(SessionToken session, String parameterName, Date value) throws InvalidDataTypeException, NoSuchParameterException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void storeURI(SessionToken session, String parameterName, URI value) throws InvalidDataTypeException, NoSuchParameterException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void storeUDT(SessionToken session, String parameterName, UDTValue value) throws InvalidDataTypeException, NoSuchParameterException {
        throw new UnsupportedOperationException();
    }

    @Override
    public UUID getInstanceID() {
        return this.instanceID;
    }

    @Override
    public int getNodeID() {
        return this.nodeID;
    }

    @Override
    public int getNodeIteration() {
        return this.nodeIteration;
    }

    @Override
    public Collection<String> getUnsavedParameterNames() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<DataContainer.Savepoint> getUnsavedSessions() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<String, ProcessConstants.AdeptDataType> getUnsavedTypes() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<String> getUnsavedIgnoredParameters() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<String, Serializable> getUnsavedValues() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getLastSavepointID(SessionToken session) {
        return this.lastSavepointID;
    }

    @Override
    public List<Integer> getStoredSavepoints(SessionToken session) {
        ArrayList<Integer> ret = new ArrayList<Integer>(1);
        ret.add(this.lastSavepointID);
        return Collections.unmodifiableList(ret);
    }

    @Override
    public byte[] restoreSessionState(SessionToken session, int savepointID) {
        byte[] ret = null;
        if (savepointID == this.lastSavepointID && this.sessionState != null) {
            ret = (byte[])this.sessionState.clone();
        }
        return ret;
    }

    @Override
    public void storeSessionState(SessionToken session, int savepointID, byte[] sessionState) {
        throw new UnsupportedOperationException();
    }
}

