/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.datamanagement.defaultimplementation;

import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.model.datamanagement.DataContainer;
import de.aristaflow.adept2.model.datamanagement.InvalidDataTypeException;
import de.aristaflow.adept2.model.datamanagement.NoSuchParameterException;
import de.aristaflow.adept2.model.datamanagement.UDTValue;
import de.aristaflow.adept2.model.datamanagement.defaultimplementation.AbstractMemoryBasedDataContainer;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import java.io.Serializable;
import java.net.URI;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class ExtendableDataContainer
extends AbstractMemoryBasedDataContainer
implements DataContainer {
    private static final long serialVersionUID = -1727301794103893704L;
    private final DataContainer delegate;

    public ExtendableDataContainer(DataContainer parentDataContainer) {
        this.delegate = parentDataContainer;
    }

    public void injectVirtualParameter(String parameterName, ProcessConstants.AdeptDataType parameterType, ActivityConstants.AccessType accessType, Serializable value) {
        if (parameterType == null && value != null) {
            String errorMessage = String.format("You must specify the ADEPTType for the given parameter '%s', that corresponds to the passed value, or you must pass 'null' as the value in order to set the given parameter to Null!", parameterName);
            throw new IllegalArgumentException(errorMessage);
        }
        switch (accessType) {
            case READ: 
            case SYSTEM_READ: {
                this.inParamsTypes.put(parameterName, parameterType);
                this.inParamsValues.put(parameterName, value);
                break;
            }
            case WRITE: 
            case SYSTEM_WRITE: {
                this.outParamsTypes.put(parameterName, parameterType);
                this.outParamsValues.put(parameterName, value);
                break;
            }
            default: {
                throw new AssertionError((Object)"An unknown access type was found!");
            }
        }
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public UUID getInstanceID() {
        return this.delegate.getInstanceID();
    }

    @Override
    public int getNodeID() {
        return this.delegate.getNodeID();
    }

    @Override
    public int getNodeIteration() {
        return this.delegate.getNodeIteration();
    }

    @Override
    public Collection<String> getUnsavedParameterNames() {
        return this.delegate.getUnsavedParameterNames();
    }

    @Override
    public List<DataContainer.Savepoint> getUnsavedSessions() {
        return this.delegate.getUnsavedSessions();
    }

    @Override
    public Map<String, ProcessConstants.AdeptDataType> getUnsavedTypes() {
        return this.delegate.getUnsavedTypes();
    }

    @Override
    public Collection<String> getUnsavedIgnoredParameters() {
        return this.delegate.getUnsavedIgnoredParameters();
    }

    @Override
    public Map<String, Serializable> getUnsavedValues() {
        return this.delegate.getUnsavedValues();
    }

    @Override
    public int getLastSavepointID(SessionToken session) {
        return this.delegate.getLastSavepointID(session);
    }

    @Override
    public List<Integer> getStoredSavepoints(SessionToken session) {
        return this.delegate.getStoredSavepoints(session);
    }

    @Override
    public boolean isNull(SessionToken session, String parameterName) throws NoSuchParameterException {
        return this.isNull(session, parameterName, ActivityConstants.AccessType.READ);
    }

    public boolean isNull(SessionToken session, String parameterName, ActivityConstants.AccessType accessType) throws NoSuchParameterException {
        boolean isNull;
        try {
            isNull = this.delegate.isNull(session, parameterName);
        }
        catch (NoSuchParameterException noSuchParameterException) {
            Map parameterNameToValueMapping;
            Map parameterNameToTypeMapping;
            switch (accessType) {
                case READ: 
                case SYSTEM_READ: {
                    parameterNameToTypeMapping = this.inParamsTypes;
                    parameterNameToValueMapping = this.inParamsValues;
                    break;
                }
                case WRITE: 
                case SYSTEM_WRITE: {
                    parameterNameToTypeMapping = this.outParamsTypes;
                    parameterNameToValueMapping = this.outParamsValues;
                    break;
                }
                default: {
                    throw new AssertionError((Object)"An unknown access type was found!");
                }
            }
            if (parameterNameToTypeMapping.containsKey(parameterName)) {
                isNull = parameterNameToTypeMapping.get(parameterName) != null ? parameterNameToValueMapping.get(parameterName) == null : false;
            }
            String msg = String.format("There is no parameter '%s'!", parameterName);
            throw new NoSuchParameterException(msg, parameterName);
        }
        return isNull;
    }

    @Override
    public byte[] restoreSessionState(SessionToken session, int savepointID) {
        return this.delegate.restoreSessionState(session, savepointID);
    }

    @Override
    public boolean retrieveBoolean(SessionToken session, String parameterName) throws InvalidDataTypeException, NoSuchParameterException {
        return this.retrieveBoolean(session, parameterName, ActivityConstants.AccessType.READ);
    }

    public boolean retrieveBoolean(SessionToken session, String parameterName, ActivityConstants.AccessType accessType) throws InvalidDataTypeException, NoSuchParameterException {
        boolean value;
        try {
            value = this.delegate.retrieveBoolean(session, parameterName);
        }
        catch (NoSuchParameterException noSuchParameterException) {
            Map parameterNameToValueMapping;
            Map parameterNameToTypeMapping;
            switch (accessType) {
                case READ: 
                case SYSTEM_READ: {
                    parameterNameToTypeMapping = this.inParamsTypes;
                    parameterNameToValueMapping = this.inParamsValues;
                    break;
                }
                case WRITE: 
                case SYSTEM_WRITE: {
                    parameterNameToTypeMapping = this.outParamsTypes;
                    parameterNameToValueMapping = this.outParamsValues;
                    break;
                }
                default: {
                    throw new AssertionError((Object)"An unknown access type was found!");
                }
            }
            if (parameterNameToTypeMapping.containsKey(parameterName)) {
                ProcessConstants.AdeptDataType parameterType = (ProcessConstants.AdeptDataType)((Object)parameterNameToTypeMapping.get(parameterName));
                if (((ProcessConstants.AdeptDataType)((Object)parameterNameToTypeMapping.get(parameterName))).equals((Object)ProcessConstants.AdeptDataType.BOOLEAN)) {
                    Object valueObject = parameterNameToValueMapping.get(parameterName);
                    value = valueObject == null ? false : (Boolean)valueObject;
                }
                throw new InvalidDataTypeException(parameterName, ProcessConstants.AdeptDataType.BOOLEAN, parameterType);
            }
            String msg = String.format("There is no parameter '%s'!", parameterName);
            throw new NoSuchParameterException(msg, parameterName);
        }
        return value;
    }

    @Override
    public Date retrieveDate(SessionToken session, String parameterName) throws InvalidDataTypeException, NoSuchParameterException {
        return this.retrieveDate(session, parameterName, ActivityConstants.AccessType.READ);
    }

    public Date retrieveDate(SessionToken session, String parameterName, ActivityConstants.AccessType accessType) throws InvalidDataTypeException, NoSuchParameterException {
        Date value;
        try {
            value = this.delegate.retrieveDate(session, parameterName);
        }
        catch (NoSuchParameterException noSuchParameterException) {
            Map parameterNameToValueMapping;
            Map parameterNameToTypeMapping;
            switch (accessType) {
                case READ: 
                case SYSTEM_READ: {
                    parameterNameToTypeMapping = this.inParamsTypes;
                    parameterNameToValueMapping = this.inParamsValues;
                    break;
                }
                case WRITE: 
                case SYSTEM_WRITE: {
                    parameterNameToTypeMapping = this.outParamsTypes;
                    parameterNameToValueMapping = this.outParamsValues;
                    break;
                }
                default: {
                    throw new AssertionError((Object)"An unknown access type was found!");
                }
            }
            if (parameterNameToTypeMapping.containsKey(parameterName)) {
                ProcessConstants.AdeptDataType parameterType = (ProcessConstants.AdeptDataType)((Object)parameterNameToTypeMapping.get(parameterName));
                if (((ProcessConstants.AdeptDataType)((Object)parameterNameToTypeMapping.get(parameterName))).equals((Object)ProcessConstants.AdeptDataType.DATE)) {
                    value = (Date)parameterNameToValueMapping.get(parameterName);
                }
                throw new InvalidDataTypeException(parameterName, ProcessConstants.AdeptDataType.DATE, parameterType);
            }
            String msg = String.format("There is no parameter '%s'!", parameterName);
            throw new NoSuchParameterException(msg, parameterName);
        }
        return value;
    }

    @Override
    public double retrieveFloat(SessionToken session, String parameterName) throws InvalidDataTypeException, NoSuchParameterException {
        return this.retrieveFloat(session, parameterName, ActivityConstants.AccessType.READ);
    }

    public double retrieveFloat(SessionToken session, String parameterName, ActivityConstants.AccessType accessType) throws InvalidDataTypeException, NoSuchParameterException {
        double value;
        try {
            value = this.delegate.retrieveFloat(session, parameterName);
        }
        catch (NoSuchParameterException noSuchParameterException) {
            Map parameterNameToValueMapping;
            Map parameterNameToTypeMapping;
            switch (accessType) {
                case READ: 
                case SYSTEM_READ: {
                    parameterNameToTypeMapping = this.inParamsTypes;
                    parameterNameToValueMapping = this.inParamsValues;
                    break;
                }
                case WRITE: 
                case SYSTEM_WRITE: {
                    parameterNameToTypeMapping = this.outParamsTypes;
                    parameterNameToValueMapping = this.outParamsValues;
                    break;
                }
                default: {
                    throw new AssertionError((Object)"An unknown access type was found!");
                }
            }
            if (parameterNameToTypeMapping.containsKey(parameterName)) {
                ProcessConstants.AdeptDataType parameterType = (ProcessConstants.AdeptDataType)((Object)parameterNameToTypeMapping.get(parameterName));
                if (((ProcessConstants.AdeptDataType)((Object)parameterNameToTypeMapping.get(parameterName))).equals((Object)ProcessConstants.AdeptDataType.FLOAT)) {
                    Object valueObject = parameterNameToValueMapping.get(parameterName);
                    value = valueObject == null ? 0.0 : (Double)valueObject;
                }
                throw new InvalidDataTypeException(parameterName, ProcessConstants.AdeptDataType.FLOAT, parameterType);
            }
            String msg = String.format("There is no parameter '%s'!", parameterName);
            throw new NoSuchParameterException(msg, parameterName);
        }
        return value;
    }

    @Override
    public long retrieveInteger(SessionToken session, String parameterName) throws InvalidDataTypeException, NoSuchParameterException {
        return this.retrieveInteger(session, parameterName, ActivityConstants.AccessType.READ);
    }

    public long retrieveInteger(SessionToken session, String parameterName, ActivityConstants.AccessType accessType) throws InvalidDataTypeException, NoSuchParameterException {
        long value;
        try {
            value = this.delegate.retrieveInteger(session, parameterName);
        }
        catch (NoSuchParameterException noSuchParameterException) {
            Map parameterNameToValueMapping;
            Map parameterNameToTypeMapping;
            switch (accessType) {
                case READ: 
                case SYSTEM_READ: {
                    parameterNameToTypeMapping = this.inParamsTypes;
                    parameterNameToValueMapping = this.inParamsValues;
                    break;
                }
                case WRITE: 
                case SYSTEM_WRITE: {
                    parameterNameToTypeMapping = this.outParamsTypes;
                    parameterNameToValueMapping = this.outParamsValues;
                    break;
                }
                default: {
                    throw new AssertionError((Object)"An unknown access type was found!");
                }
            }
            if (parameterNameToTypeMapping.containsKey(parameterName)) {
                ProcessConstants.AdeptDataType parameterType = (ProcessConstants.AdeptDataType)((Object)parameterNameToTypeMapping.get(parameterName));
                if (((ProcessConstants.AdeptDataType)((Object)parameterNameToTypeMapping.get(parameterName))).equals((Object)ProcessConstants.AdeptDataType.INTEGER)) {
                    Object valueObject = parameterNameToValueMapping.get(parameterName);
                    value = valueObject == null ? Integer.MIN_VALUE : (Long)valueObject;
                }
                throw new InvalidDataTypeException(parameterName, ProcessConstants.AdeptDataType.INTEGER, parameterType);
            }
            String msg = String.format("There is no parameter '%s'!", parameterName);
            throw new NoSuchParameterException(msg, parameterName);
        }
        return value;
    }

    @Override
    public String retrieveString(SessionToken session, String parameterName) throws InvalidDataTypeException, NoSuchParameterException {
        return this.retrieveString(session, parameterName, ActivityConstants.AccessType.READ);
    }

    public String retrieveString(SessionToken session, String parameterName, ActivityConstants.AccessType accessType) throws InvalidDataTypeException, NoSuchParameterException {
        String value;
        try {
            value = this.delegate.retrieveString(session, parameterName);
        }
        catch (NoSuchParameterException noSuchParameterException) {
            Map parameterNameToValueMapping;
            Map parameterNameToTypeMapping;
            switch (accessType) {
                case READ: 
                case SYSTEM_READ: {
                    parameterNameToTypeMapping = this.inParamsTypes;
                    parameterNameToValueMapping = this.inParamsValues;
                    break;
                }
                case WRITE: 
                case SYSTEM_WRITE: {
                    parameterNameToTypeMapping = this.outParamsTypes;
                    parameterNameToValueMapping = this.outParamsValues;
                    break;
                }
                default: {
                    throw new AssertionError((Object)"An unknown access type was found!");
                }
            }
            if (parameterNameToTypeMapping.containsKey(parameterName)) {
                ProcessConstants.AdeptDataType parameterType = (ProcessConstants.AdeptDataType)((Object)parameterNameToTypeMapping.get(parameterName));
                if (((ProcessConstants.AdeptDataType)((Object)parameterNameToTypeMapping.get(parameterName))).equals((Object)ProcessConstants.AdeptDataType.STRING)) {
                    value = (String)parameterNameToValueMapping.get(parameterName);
                }
                throw new InvalidDataTypeException(parameterName, ProcessConstants.AdeptDataType.STRING, parameterType);
            }
            String msg = String.format("There is no parameter '%s'!", parameterName);
            throw new NoSuchParameterException(msg, parameterName);
        }
        return value;
    }

    @Override
    public UDTValue retrieveUDT(SessionToken session, String parameterName) throws InvalidDataTypeException, NoSuchParameterException {
        return this.retrieveUDT(session, parameterName, ActivityConstants.AccessType.READ);
    }

    public UDTValue retrieveUDT(SessionToken session, String parameterName, ActivityConstants.AccessType accessType) throws InvalidDataTypeException, NoSuchParameterException {
        UDTValue value;
        try {
            value = this.delegate.retrieveUDT(session, parameterName);
        }
        catch (NoSuchParameterException noSuchParameterException) {
            Map parameterNameToValueMapping;
            Map parameterNameToTypeMapping;
            switch (accessType) {
                case READ: 
                case SYSTEM_READ: {
                    parameterNameToTypeMapping = this.inParamsTypes;
                    parameterNameToValueMapping = this.inParamsValues;
                    break;
                }
                case WRITE: 
                case SYSTEM_WRITE: {
                    parameterNameToTypeMapping = this.outParamsTypes;
                    parameterNameToValueMapping = this.outParamsValues;
                    break;
                }
                default: {
                    throw new AssertionError((Object)"An unknown access type was found!");
                }
            }
            if (parameterNameToTypeMapping.containsKey(parameterName)) {
                ProcessConstants.AdeptDataType parameterType = (ProcessConstants.AdeptDataType)((Object)parameterNameToTypeMapping.get(parameterName));
                if (((ProcessConstants.AdeptDataType)((Object)parameterNameToTypeMapping.get(parameterName))).equals((Object)ProcessConstants.AdeptDataType.USERDEFINED)) {
                    value = (UDTValue)parameterNameToValueMapping.get(parameterName);
                }
                throw new InvalidDataTypeException(parameterName, ProcessConstants.AdeptDataType.USERDEFINED, parameterType);
            }
            String msg = String.format("There is no parameter '%s'!", parameterName);
            throw new NoSuchParameterException(msg, parameterName);
        }
        return value;
    }

    @Override
    public URI retrieveURI(SessionToken session, String parameterName) throws InvalidDataTypeException, NoSuchParameterException {
        return this.retrieveURI(session, parameterName, ActivityConstants.AccessType.READ);
    }

    public URI retrieveURI(SessionToken session, String parameterName, ActivityConstants.AccessType accessType) throws InvalidDataTypeException, NoSuchParameterException {
        URI value;
        try {
            value = this.delegate.retrieveURI(session, parameterName);
        }
        catch (NoSuchParameterException noSuchParameterException) {
            Map parameterNameToValueMapping;
            Map parameterNameToTypeMapping;
            switch (accessType) {
                case READ: 
                case SYSTEM_READ: {
                    parameterNameToTypeMapping = this.inParamsTypes;
                    parameterNameToValueMapping = this.inParamsValues;
                    break;
                }
                case WRITE: 
                case SYSTEM_WRITE: {
                    parameterNameToTypeMapping = this.outParamsTypes;
                    parameterNameToValueMapping = this.outParamsValues;
                    break;
                }
                default: {
                    throw new AssertionError((Object)"An unknown access type was found!");
                }
            }
            if (parameterNameToTypeMapping.containsKey(parameterName)) {
                ProcessConstants.AdeptDataType parameterType = (ProcessConstants.AdeptDataType)((Object)parameterNameToTypeMapping.get(parameterName));
                if (((ProcessConstants.AdeptDataType)((Object)parameterNameToTypeMapping.get(parameterName))).equals((Object)ProcessConstants.AdeptDataType.URI)) {
                    value = (URI)parameterNameToValueMapping.get(parameterName);
                }
                throw new InvalidDataTypeException(parameterName, ProcessConstants.AdeptDataType.URI, parameterType);
            }
            String msg = String.format("There is no parameter '%s'!", parameterName);
            throw new NoSuchParameterException(msg, parameterName);
        }
        return value;
    }

    @Override
    public void ignoreValue(SessionToken session, String parameterName) throws NoSuchParameterException {
        try {
            this.delegate.ignoreValue(session, parameterName);
        }
        catch (NoSuchParameterException noSuchParameterException) {
            if (this.outParamsTypes.containsKey(parameterName)) {
                ProcessConstants.AdeptDataType parameterType = (ProcessConstants.AdeptDataType)((Object)this.outParamsTypes.get(parameterName));
                if (parameterType != null) {
                    this.outParamsNullValues.add(parameterName);
                }
            }
            String msg = String.format("There is no parameter '%s'!", parameterName);
            throw new NoSuchParameterException(msg, parameterName);
        }
    }

    @Override
    public void storeBoolean(SessionToken session, String parameterName, boolean value) throws InvalidDataTypeException, NoSuchParameterException {
        try {
            this.delegate.storeBoolean(session, parameterName, value);
        }
        catch (NoSuchParameterException noSuchParameterException) {
            Map parameterNameToTypeMapping = this.outParamsTypes;
            Map parameterNameToValueMapping = this.outParamsValues;
            if (parameterNameToTypeMapping.containsKey(parameterName)) {
                ProcessConstants.AdeptDataType parameterType = (ProcessConstants.AdeptDataType)((Object)parameterNameToTypeMapping.get(parameterName));
                if (parameterType == ProcessConstants.AdeptDataType.BOOLEAN) {
                    parameterNameToValueMapping.put(parameterName, value);
                }
                throw new InvalidDataTypeException(parameterName, ProcessConstants.AdeptDataType.BOOLEAN, parameterType);
            }
            String msg = String.format("There is no output parameter '%s'!", parameterName);
            throw new NoSuchParameterException(msg, parameterName);
        }
    }

    @Override
    public void storeDate(SessionToken session, String parameterName, Date value) throws InvalidDataTypeException, NoSuchParameterException {
        try {
            this.delegate.storeDate(session, parameterName, value);
        }
        catch (NoSuchParameterException noSuchParameterException) {
            Map parameterNameToTypeMapping = this.outParamsTypes;
            Map parameterNameToValueMapping = this.outParamsValues;
            if (parameterNameToTypeMapping.containsKey(parameterName)) {
                ProcessConstants.AdeptDataType parameterType = (ProcessConstants.AdeptDataType)((Object)parameterNameToTypeMapping.get(parameterName));
                if (parameterType == ProcessConstants.AdeptDataType.DATE) {
                    parameterNameToValueMapping.put(parameterName, value);
                }
                throw new InvalidDataTypeException(parameterName, ProcessConstants.AdeptDataType.DATE, parameterType);
            }
            String msg = String.format("There is no output parameter '%s'!", parameterName);
            throw new NoSuchParameterException(msg, parameterName);
        }
    }

    @Override
    public void storeFloat(SessionToken session, String parameterName, double value) throws InvalidDataTypeException, NoSuchParameterException {
        try {
            this.delegate.storeFloat(session, parameterName, value);
        }
        catch (NoSuchParameterException noSuchParameterException) {
            Map parameterNameToTypeMapping = this.outParamsTypes;
            Map parameterNameToValueMapping = this.outParamsValues;
            if (parameterNameToTypeMapping.containsKey(parameterName)) {
                ProcessConstants.AdeptDataType parameterType = (ProcessConstants.AdeptDataType)((Object)parameterNameToTypeMapping.get(parameterName));
                if (parameterType == ProcessConstants.AdeptDataType.FLOAT) {
                    parameterNameToValueMapping.put(parameterName, value);
                }
                throw new InvalidDataTypeException(parameterName, ProcessConstants.AdeptDataType.FLOAT, parameterType);
            }
            String msg = String.format("There is no output parameter '%s'!", parameterName);
            throw new NoSuchParameterException(msg, parameterName);
        }
    }

    @Override
    public void storeInteger(SessionToken session, String parameterName, long value) throws InvalidDataTypeException, NoSuchParameterException {
        try {
            this.delegate.storeInteger(session, parameterName, value);
        }
        catch (NoSuchParameterException noSuchParameterException) {
            Map parameterNameToTypeMapping = this.outParamsTypes;
            Map parameterNameToValueMapping = this.outParamsValues;
            if (parameterNameToTypeMapping.containsKey(parameterName)) {
                ProcessConstants.AdeptDataType parameterType = (ProcessConstants.AdeptDataType)((Object)parameterNameToTypeMapping.get(parameterName));
                if (parameterType == ProcessConstants.AdeptDataType.INTEGER) {
                    parameterNameToValueMapping.put(parameterName, value);
                }
                throw new InvalidDataTypeException(parameterName, ProcessConstants.AdeptDataType.INTEGER, parameterType);
            }
            String msg = String.format("There is no output parameter '%s'!", parameterName);
            throw new NoSuchParameterException(msg, parameterName);
        }
    }

    @Override
    public void storeSessionState(SessionToken session, int savepointID, byte[] sessionState) {
        this.delegate.storeSessionState(session, savepointID, sessionState);
    }

    @Override
    public void storeString(SessionToken session, String parameterName, String value) throws InvalidDataTypeException, NoSuchParameterException {
        try {
            this.delegate.storeString(session, parameterName, value);
        }
        catch (NoSuchParameterException noSuchParameterException) {
            Map parameterNameToTypeMapping = this.outParamsTypes;
            Map parameterNameToValueMapping = this.outParamsValues;
            if (parameterNameToTypeMapping.containsKey(parameterName)) {
                ProcessConstants.AdeptDataType parameterType = (ProcessConstants.AdeptDataType)((Object)parameterNameToTypeMapping.get(parameterName));
                if (parameterType == ProcessConstants.AdeptDataType.STRING) {
                    parameterNameToValueMapping.put(parameterName, value);
                }
                throw new InvalidDataTypeException(parameterName, ProcessConstants.AdeptDataType.STRING, parameterType);
            }
            String msg = String.format("There is no output parameter '%s'!", parameterName);
            throw new NoSuchParameterException(msg, parameterName);
        }
    }

    @Override
    public void storeUDT(SessionToken session, String parameterName, UDTValue value) throws InvalidDataTypeException, NoSuchParameterException {
        try {
            this.delegate.storeUDT(session, parameterName, value);
        }
        catch (NoSuchParameterException noSuchParameterException) {
            Map parameterNameToTypeMapping = this.outParamsTypes;
            Map parameterNameToValueMapping = this.outParamsValues;
            if (parameterNameToTypeMapping.containsKey(parameterName)) {
                ProcessConstants.AdeptDataType parameterType = (ProcessConstants.AdeptDataType)((Object)parameterNameToTypeMapping.get(parameterName));
                if (parameterType == ProcessConstants.AdeptDataType.USERDEFINED) {
                    parameterNameToValueMapping.put(parameterName, value);
                }
                throw new InvalidDataTypeException(parameterName, ProcessConstants.AdeptDataType.USERDEFINED, parameterType);
            }
            String msg = String.format("There is no output parameter '%s'!", parameterName);
            throw new NoSuchParameterException(msg, parameterName);
        }
    }

    @Override
    public void storeURI(SessionToken session, String parameterName, URI value) throws InvalidDataTypeException, NoSuchParameterException {
        try {
            this.delegate.storeURI(session, parameterName, value);
        }
        catch (NoSuchParameterException noSuchParameterException) {
            Map parameterNameToTypeMapping = this.outParamsTypes;
            Map parameterNameToValueMapping = this.outParamsValues;
            if (parameterNameToTypeMapping.containsKey(parameterName)) {
                ProcessConstants.AdeptDataType parameterType = (ProcessConstants.AdeptDataType)((Object)parameterNameToTypeMapping.get(parameterName));
                if (parameterType == ProcessConstants.AdeptDataType.URI) {
                    parameterNameToValueMapping.put(parameterName, value);
                }
                throw new InvalidDataTypeException(parameterName, ProcessConstants.AdeptDataType.URI, parameterType);
            }
            String msg = String.format("There is no output parameter '%s'!", parameterName);
            throw new NoSuchParameterException(msg, parameterName);
        }
    }

    @Override
    public boolean ignoredValue(String parameterName) throws NoSuchParameterException {
        try {
            return this.delegate.ignoredValue(parameterName);
        }
        catch (NoSuchParameterException noSuchParameterException) {
            if (this.outParamsTypes.containsKey(parameterName)) {
                return this.outParamsNullValues.contains(parameterName);
            }
            String msg = String.format("There is no output parameter '%s'!", parameterName);
            throw new NoSuchParameterException(msg, parameterName);
        }
    }

    @Override
    public long storedInteger(String parameterName) throws InvalidDataTypeException, NoSuchParameterException {
        try {
            return this.delegate.storedInteger(parameterName);
        }
        catch (NoSuchParameterException noSuchParameterException) {
            if (this.outParamsTypes.containsKey(parameterName)) {
                ProcessConstants.AdeptDataType dataType = (ProcessConstants.AdeptDataType)((Object)this.outParamsTypes.get(parameterName));
                if (dataType == ProcessConstants.AdeptDataType.INTEGER) {
                    return (Long)this.outParamsValues.get(parameterName);
                }
                throw new InvalidDataTypeException(parameterName, ProcessConstants.AdeptDataType.INTEGER, dataType);
            }
            String msg = String.format("There is no output parameter '%s'!", parameterName);
            throw new NoSuchParameterException(msg, parameterName);
        }
    }

    @Override
    public double storedFloat(String parameterName) throws InvalidDataTypeException, NoSuchParameterException {
        try {
            return this.delegate.storedFloat(parameterName);
        }
        catch (NoSuchParameterException noSuchParameterException) {
            if (this.outParamsTypes.containsKey(parameterName)) {
                ProcessConstants.AdeptDataType dataType = (ProcessConstants.AdeptDataType)((Object)this.outParamsTypes.get(parameterName));
                if (dataType == ProcessConstants.AdeptDataType.FLOAT) {
                    return (Double)this.outParamsValues.get(parameterName);
                }
                throw new InvalidDataTypeException(parameterName, ProcessConstants.AdeptDataType.FLOAT, dataType);
            }
            String msg = String.format("There is no output parameter '%s'!", parameterName);
            throw new NoSuchParameterException(msg, parameterName);
        }
    }

    @Override
    public boolean storedBoolean(String parameterName) throws InvalidDataTypeException, NoSuchParameterException {
        try {
            return this.delegate.storedBoolean(parameterName);
        }
        catch (NoSuchParameterException noSuchParameterException) {
            if (this.outParamsTypes.containsKey(parameterName)) {
                ProcessConstants.AdeptDataType dataType = (ProcessConstants.AdeptDataType)((Object)this.outParamsTypes.get(parameterName));
                if (dataType == ProcessConstants.AdeptDataType.BOOLEAN) {
                    return (Boolean)this.outParamsValues.get(parameterName);
                }
                throw new InvalidDataTypeException(parameterName, ProcessConstants.AdeptDataType.BOOLEAN, dataType);
            }
            String msg = String.format("There is no output parameter '%s'!", parameterName);
            throw new NoSuchParameterException(msg, parameterName);
        }
    }

    @Override
    public String storedString(String parameterName) throws InvalidDataTypeException, NoSuchParameterException {
        try {
            return this.delegate.storedString(parameterName);
        }
        catch (NoSuchParameterException noSuchParameterException) {
            if (this.outParamsTypes.containsKey(parameterName)) {
                ProcessConstants.AdeptDataType dataType = (ProcessConstants.AdeptDataType)((Object)this.outParamsTypes.get(parameterName));
                if (dataType == ProcessConstants.AdeptDataType.STRING) {
                    return (String)this.outParamsValues.get(parameterName);
                }
                throw new InvalidDataTypeException(parameterName, ProcessConstants.AdeptDataType.STRING, dataType);
            }
            String msg = String.format("There is no output parameter '%s'!", parameterName);
            throw new NoSuchParameterException(msg, parameterName);
        }
    }

    @Override
    public Date storedDate(String parameterName) throws InvalidDataTypeException, NoSuchParameterException {
        try {
            return this.delegate.storedDate(parameterName);
        }
        catch (NoSuchParameterException noSuchParameterException) {
            if (this.outParamsTypes.containsKey(parameterName)) {
                ProcessConstants.AdeptDataType dataType = (ProcessConstants.AdeptDataType)((Object)this.outParamsTypes.get(parameterName));
                if (dataType == ProcessConstants.AdeptDataType.DATE) {
                    return (Date)this.outParamsValues.get(parameterName);
                }
                throw new InvalidDataTypeException(parameterName, ProcessConstants.AdeptDataType.DATE, dataType);
            }
            String msg = String.format("There is no output parameter '%s'!", parameterName);
            throw new NoSuchParameterException(msg, parameterName);
        }
    }

    @Override
    public URI storedURI(String parameterName) throws InvalidDataTypeException, NoSuchParameterException {
        try {
            return this.delegate.storedURI(parameterName);
        }
        catch (NoSuchParameterException noSuchParameterException) {
            if (this.outParamsTypes.containsKey(parameterName)) {
                ProcessConstants.AdeptDataType dataType = (ProcessConstants.AdeptDataType)((Object)this.outParamsTypes.get(parameterName));
                if (dataType == ProcessConstants.AdeptDataType.URI) {
                    return (URI)this.outParamsValues.get(parameterName);
                }
                throw new InvalidDataTypeException(parameterName, ProcessConstants.AdeptDataType.URI, dataType);
            }
            String msg = String.format("There is no output parameter '%s'!", parameterName);
            throw new NoSuchParameterException(msg, parameterName);
        }
    }

    @Override
    public UDTValue storedUDT(String parameterName) throws InvalidDataTypeException, NoSuchParameterException {
        try {
            return this.delegate.storedUDT(parameterName);
        }
        catch (NoSuchParameterException noSuchParameterException) {
            if (this.outParamsTypes.containsKey(parameterName)) {
                ProcessConstants.AdeptDataType dataType = (ProcessConstants.AdeptDataType)((Object)this.outParamsTypes.get(parameterName));
                if (dataType == ProcessConstants.AdeptDataType.USERDEFINED) {
                    return (UDTValue)this.outParamsValues.get(parameterName);
                }
                throw new InvalidDataTypeException(parameterName, ProcessConstants.AdeptDataType.USERDEFINED, dataType);
            }
            String msg = String.format("There is no output parameter '%s'!", parameterName);
            throw new NoSuchParameterException(msg, parameterName);
        }
    }
}

