/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.datamanagement.defaultimplementation;

import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.model.datamanagement.DataContainer;
import de.aristaflow.adept2.model.datamanagement.InvalidDataTypeException;
import de.aristaflow.adept2.model.datamanagement.NoSuchParameterException;
import de.aristaflow.adept2.model.datamanagement.UDTValue;
import de.aristaflow.adept2.model.datamanagement.defaultimplementation.DefaultPersistedDataContainer;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import java.io.Serializable;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class SerialisableDataContainer
extends DefaultPersistedDataContainer {
    private static final long serialVersionUID = -1770569092031592119L;
    private final boolean readOnly;

    public SerialisableDataContainer(boolean readOnly, UUID instanceID, int nodeID, int nodeIteration, Map<String, ProcessConstants.AdeptDataType> inParamTypes, Collection<String> inParamNulls, Map<String, Serializable> inParamValues, Map<String, ProcessConstants.AdeptDataType> outParamTypes, Collection<String> outParamNulls, Map<String, Serializable> outParamValues, Collection<DataContainer.Savepoint> savePoints, Map<String, String> userAttributes) {
        super(instanceID, nodeID, nodeIteration, outParamTypes, outParamNulls, outParamValues, savePoints, userAttributes);
        this.readOnly = readOnly;
        this.inParamsTypes = new HashMap<String, ProcessConstants.AdeptDataType>(inParamTypes);
        this.inParamsNullValues = new HashSet<String>(inParamNulls);
        this.inParamsValues = new HashMap<String, Serializable>(inParamValues);
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public boolean isNull(SessionToken session, String parameterName) throws NoSuchParameterException {
        return this.getInParamNull(parameterName);
    }

    @Override
    public boolean retrieveBoolean(SessionToken session, String parameterName) throws InvalidDataTypeException, NoSuchParameterException {
        return (Boolean)this.getInParam(parameterName, ProcessConstants.AdeptDataType.BOOLEAN);
    }

    @Override
    public Date retrieveDate(SessionToken session, String parameterName) throws InvalidDataTypeException, NoSuchParameterException {
        return (Date)this.getInParam(parameterName, ProcessConstants.AdeptDataType.DATE);
    }

    @Override
    public double retrieveFloat(SessionToken session, String parameterName) throws InvalidDataTypeException, NoSuchParameterException {
        return (Double)this.getInParam(parameterName, ProcessConstants.AdeptDataType.FLOAT);
    }

    @Override
    public long retrieveInteger(SessionToken session, String parameterName) throws InvalidDataTypeException, NoSuchParameterException {
        return (Long)this.getInParam(parameterName, ProcessConstants.AdeptDataType.INTEGER);
    }

    @Override
    public String retrieveString(SessionToken session, String parameterName) throws InvalidDataTypeException, NoSuchParameterException {
        return (String)this.getInParam(parameterName, ProcessConstants.AdeptDataType.STRING);
    }

    @Override
    public UDTValue retrieveUDT(SessionToken session, String parameterName) throws InvalidDataTypeException, NoSuchParameterException {
        return (UDTValue)this.getInParam(parameterName, ProcessConstants.AdeptDataType.USERDEFINED);
    }

    @Override
    public URI retrieveURI(SessionToken session, String parameterName) throws InvalidDataTypeException, NoSuchParameterException {
        return (URI)this.getInParam(parameterName, ProcessConstants.AdeptDataType.URI);
    }

    @Override
    public void ignoreValue(SessionToken session, String parameterName) throws NoSuchParameterException {
        if (this.readOnly) {
            throw new UnsupportedOperationException();
        }
        this.setOutParamNull(parameterName);
    }

    @Override
    public void storeBoolean(SessionToken session, String parameterName, boolean value) throws InvalidDataTypeException, NoSuchParameterException {
        if (this.readOnly) {
            throw new UnsupportedOperationException();
        }
        this.setOutParam(parameterName, Boolean.valueOf(value));
    }

    @Override
    public void storeDate(SessionToken session, String parameterName, Date value) throws InvalidDataTypeException, NoSuchParameterException {
        if (this.readOnly) {
            throw new UnsupportedOperationException();
        }
        this.setOutParam(parameterName, value);
    }

    @Override
    public void storeFloat(SessionToken session, String parameterName, double value) throws InvalidDataTypeException, NoSuchParameterException {
        if (this.readOnly) {
            throw new UnsupportedOperationException();
        }
        this.setOutParam(parameterName, Double.valueOf(value));
    }

    @Override
    public void storeInteger(SessionToken session, String parameterName, long value) throws InvalidDataTypeException, NoSuchParameterException {
        if (this.readOnly) {
            throw new UnsupportedOperationException();
        }
        this.setOutParam(parameterName, Long.valueOf(value));
    }

    @Override
    public void storeString(SessionToken session, String parameterName, String value) throws InvalidDataTypeException, NoSuchParameterException {
        if (this.readOnly) {
            throw new UnsupportedOperationException();
        }
        this.setOutParam(parameterName, (Serializable)((Object)value));
    }

    @Override
    public void storeUDT(SessionToken session, String parameterName, UDTValue value) throws InvalidDataTypeException, NoSuchParameterException {
        if (this.readOnly) {
            throw new UnsupportedOperationException();
        }
        this.setOutParam(parameterName, value);
    }

    @Override
    public void storeURI(SessionToken session, String parameterName, URI value) throws InvalidDataTypeException, NoSuchParameterException {
        if (this.readOnly) {
            throw new UnsupportedOperationException();
        }
        this.setOutParam(parameterName, value);
    }

    @Override
    public void storeSessionState(SessionToken session, int savepointID, byte[] sessionState) {
        if (this.readOnly) {
            throw new UnsupportedOperationException();
        }
        this.savePoints.add(new DataContainer.Savepoint(savepointID, sessionState));
    }

    @Override
    public List<DataContainer.Savepoint> getUnsavedSessions() {
        List<Object> ret = this.readOnly ? Collections.emptyList() : super.getUnsavedSessions();
        return ret;
    }

    @Override
    public Collection<String> getUnsavedParameterNames() {
        Collection<Object> ret = this.readOnly ? Collections.emptyList() : super.getUnsavedParameterNames();
        return ret;
    }

    @Override
    public Map<String, ProcessConstants.AdeptDataType> getUnsavedTypes() {
        Map<Object, Object> ret = this.readOnly ? Collections.emptyMap() : super.getUnsavedTypes();
        return ret;
    }

    @Override
    public Collection<String> getUnsavedIgnoredParameters() {
        Collection<Object> ret = this.readOnly ? Collections.emptyList() : super.getUnsavedIgnoredParameters();
        return ret;
    }

    @Override
    public Map<String, Serializable> getUnsavedValues() {
        Map<Object, Object> ret = this.readOnly ? Collections.emptyMap() : super.getUnsavedValues();
        return ret;
    }
}

