/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.datamanagement.defaultimplementation.xml;

import de.aristaflow.adept2.model.common.XMLExportTools;
import de.aristaflow.adept2.model.datamanagement.DataContainer;
import de.aristaflow.adept2.model.datamanagement.IndexedAccessDataContainer;
import de.aristaflow.adept2.model.datamanagement.UDTValue;
import de.aristaflow.adept2.model.datamanagement.defaultimplementation.DefaultIndexedAccessDataContainer;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.util.Base64;
import de.aristaflow.adept2.util.ConfigurationTools;
import de.aristaflow.adept2.util.xml.XMLFormatException;
import de.aristaflow.adept2.util.xml.XMLHelperTools;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.validation.Schema;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DataContainerXMLExport {
    private static final String NAMESPACE_PREFIX = "http://aristaflow.de/adept2/xml1/";
    private static final String NS_DTM = "http://aristaflow.de/adept2/xml1/model/datamanagement";
    private static final String PF_CMN = "cmn:";
    private static final String NS_CMN = "http://aristaflow.de/adept2/xml1/model/common";
    private static final String PF_BSC = "bsc:";
    private static final String NS_BSC = "http://aristaflow.de/adept2/xml1/basic";
    private static final String PF_XMLNS = "xmlns:";
    private static final String NS_XMLNS = "http://www.w3.org/2000/xmlns/";

    public static Document getDocumentForDataContainer(DataContainer dataContainer) {
        Document doc = XMLHelperTools.createDocument();
        Element dcElement = doc.createElementNS("http://www.aristaflow.de/adept2/datamanagement", "dataContainer");
        DataContainerXMLExport.fillDataContainerElement(doc, dcElement, dataContainer, false);
        doc.appendChild(dcElement);
        return doc;
    }

    public static void fillDataContainerElement(Document doc, Element dcElement, DataContainer dataContainer, boolean namespaceAware) {
        dcElement.setAttributeNS(null, "instanceID", dataContainer.getInstanceID().toString());
        dcElement.setAttributeNS(null, "nodeID", Integer.toString(dataContainer.getNodeID()));
        dcElement.setAttributeNS(null, "nodeIteration", Integer.toString(dataContainer.getNodeIteration()));
        dcElement.appendChild(DataContainerXMLExport.createTypesElement(doc, dataContainer.getUnsavedTypes(), namespaceAware));
        for (String name : dataContainer.getUnsavedIgnoredParameters()) {
            dcElement.appendChild(DataContainerXMLExport.createNullValueElement(doc, name, namespaceAware));
        }
        dcElement.appendChild(DataContainerXMLExport.createValuesElement(doc, dataContainer.getUnsavedValues(), namespaceAware));
        if (dataContainer.getUnsavedSessions().size() > 0) {
            dcElement.appendChild(DataContainerXMLExport.createSessionsElement(doc, dataContainer.getUnsavedSessions(), namespaceAware));
        }
        if (dataContainer.getUserAttributes().size() > 0) {
            Element uasElement = doc.createElementNS("http://www.aristaflow.de/adept2/datamanagement", "dm:".concat("userAttributes"));
            XMLExportTools.fillUserAttributesElement(doc, "http://www.aristaflow.de/adept2/datamanagement", dataContainer.getUserAttributes(), uasElement, true);
            dcElement.appendChild(uasElement);
        }
    }

    private static Node createTypesElement(Document doc, Map<String, ProcessConstants.AdeptDataType> unsavedTypes, boolean namespaceAware) {
        Element types = namespaceAware ? doc.createElementNS("http://www.aristaflow.de/adept2/datamanagement", "dm:".concat("unsavedTypes")) : doc.createElementNS("http://www.aristaflow.de/adept2/datamanagement", "unsavedTypes");
        for (Map.Entry<String, ProcessConstants.AdeptDataType> entry : unsavedTypes.entrySet()) {
            Element type = namespaceAware ? doc.createElementNS("http://www.aristaflow.de/adept2/datamanagement", "dm:".concat("type")) : doc.createElementNS("http://www.aristaflow.de/adept2/datamanagement", "type");
            type.setAttributeNS(null, "name", entry.getKey());
            ProcessConstants.AdeptDataType adt = entry.getValue();
            if (adt != null) {
                type.setTextContent(adt.name());
            }
            types.appendChild(type);
        }
        return types;
    }

    private static Node createNullValueElement(Document doc, String name, boolean namespaceAware) {
        Element nullValue = namespaceAware ? doc.createElementNS("http://www.aristaflow.de/adept2/datamanagement", "dm:".concat("unsavedNullValue")) : doc.createElementNS("http://www.aristaflow.de/adept2/datamanagement", "unsavedNullValue");
        nullValue.setAttributeNS(null, "name", name);
        return nullValue;
    }

    private static Node createValuesElement(Document doc, Map<String, Serializable> unsavedValues, boolean namespaceAware) {
        Element values = namespaceAware ? doc.createElementNS("http://www.aristaflow.de/adept2/datamanagement", "dm:".concat("unsavedValues")) : doc.createElementNS("http://www.aristaflow.de/adept2/datamanagement", "unsavedValues");
        DataContainerXMLExport.fillValuesMap(doc, values, unsavedValues, namespaceAware);
        return values;
    }

    private static void fillValuesMap(Document doc, Node valuesElement, Map<String, Serializable> unsavedValues, boolean namespaceAware) {
        for (Map.Entry<String, Serializable> entry : unsavedValues.entrySet()) {
            Element valueElement = namespaceAware ? doc.createElementNS("http://www.aristaflow.de/adept2/datamanagement", "dm:".concat("value")) : doc.createElementNS("http://www.aristaflow.de/adept2/datamanagement", "value");
            valueElement.setAttributeNS(null, "name", entry.getKey());
            Serializable value = entry.getValue();
            if (value instanceof Boolean) {
                valueElement.setTextContent(Boolean.toString((Boolean)value));
            } else if (value instanceof Date) {
                valueElement.setTextContent(Long.toString(((Date)value).getTime()));
            } else if (value instanceof Double) {
                valueElement.setTextContent(Double.toString((Double)value));
            } else if (value instanceof Long) {
                valueElement.setTextContent(Long.toString((Long)value));
            } else if (value instanceof String) {
                valueElement.setTextContent((String)((Object)value));
            } else if (value instanceof URI) {
                valueElement.setTextContent(((URI)value).toString());
            } else {
                valueElement.setTextContent(Base64.encodeObject(value));
            }
            valuesElement.appendChild(valueElement);
        }
    }

    private static Node createSessionsElement(Document doc, List<DataContainer.Savepoint> unsavedSessions, boolean namespaceAware) {
        Element sessions = namespaceAware ? doc.createElementNS("http://www.aristaflow.de/adept2/datamanagement", "dm:".concat("unsavedSessions")) : doc.createElementNS("http://www.aristaflow.de/adept2/datamanagement", "unsavedSessions");
        for (DataContainer.Savepoint sp : unsavedSessions) {
            Element savepoint = namespaceAware ? doc.createElementNS("http://www.aristaflow.de/adept2/datamanagement", "dm:".concat("savepoint")) : doc.createElementNS("http://www.aristaflow.de/adept2/datamanagement", "savepoint");
            savepoint.setAttributeNS(null, "savepointID", Integer.toString(sp.getSavepointID()));
            String sessionState = sp.getSessionState() == null ? String.valueOf('N') : String.valueOf('R') + Base64.encodeBytes(sp.getSessionState());
            savepoint.setTextContent(sessionState);
            sessions.appendChild(savepoint);
        }
        return sessions;
    }

    public static byte[] getBytesForIndexedAccessDataContainer(IndexedAccessDataContainer dataContainer, Schema schema) throws XMLFormatException, IOException {
        Document doc = XMLHelperTools.createDocument();
        Element dcElement = doc.createElementNS(NS_DTM, "indexedAccessDataContainer");
        doc.appendChild(dcElement);
        DataContainerXMLExport.marshalIndexedAccessDataContainer(dataContainer, dcElement);
        if (schema != null) {
            XMLHelperTools.validateDoc(doc, schema);
        }
        return XMLHelperTools.getByteArrayForDocument(doc);
    }

    public static void marshalIndexedAccessDataContainer(IndexedAccessDataContainer iadc, Node parent) {
        Map<String, UDTValue> outParamValues;
        Set<String> mandOutputParameter;
        Set<String> optIndexedInputParameter;
        Element child;
        if (!(iadc instanceof DefaultIndexedAccessDataContainer)) {
            throw new RuntimeException("At the moment we could only marshal indexed access data containers based on the DefaultIndexedAccessDataContainer!");
        }
        Document doc = parent.getOwnerDocument();
        DefaultIndexedAccessDataContainer diadc = (DefaultIndexedAccessDataContainer)iadc;
        Set<String> indexedInputParameter = diadc.getIndexedInputParameter();
        if (indexedInputParameter != null && indexedInputParameter.size() > 0) {
            child = doc.createElementNS(NS_DTM, "indexedInParams");
            DataContainerXMLExport.marshalStringList(indexedInputParameter, child);
            parent.appendChild(child);
        }
        if ((optIndexedInputParameter = diadc.getOptionalIndexedInputParameter()) != null && optIndexedInputParameter.size() > 0) {
            child = doc.createElementNS(NS_DTM, "optionalIndexedInParams");
            DataContainerXMLExport.marshalStringList(optIndexedInputParameter, child);
            parent.appendChild(child);
        }
        if ((mandOutputParameter = diadc.getMandatoryOutputParameter()) != null && mandOutputParameter.size() > 0) {
            child = doc.createElementNS(NS_DTM, "mandatoryOutParams");
            DataContainerXMLExport.marshalStringList(mandOutputParameter, child);
            parent.appendChild(child);
        }
        if ((outParamValues = diadc.getOutputParameterValues()) != null && outParamValues.size() > 0) {
            child = doc.createElementNS(NS_DTM, "outputParams");
            HashMap<String, ProcessConstants.AdeptDataType> paramTypes = new HashMap<String, ProcessConstants.AdeptDataType>(outParamValues.size());
            for (String paramName : outParamValues.keySet()) {
                paramTypes.put(paramName, ProcessConstants.AdeptDataType.USERDEFINED);
            }
            DataContainerXMLExport.marshalParameterValues(paramTypes, outParamValues, child);
            parent.appendChild(child);
        }
        boolean[] validated = diadc.getValidated();
        child = doc.createElementNS(NS_DTM, "validated");
        DataContainerXMLExport.marshalBooleanArray(validated, child);
        parent.appendChild(child);
    }

    private static void marshalParameterValues(Map<String, ProcessConstants.AdeptDataType> types, Map<String, ? extends Serializable> values, Node parent) {
        DataContainerXMLExport.marshalParameterValues(types, null, values, parent);
    }

    private static void marshalParameterValues(Map<String, ProcessConstants.AdeptDataType> types, Collection<String> nullValues, Map<String, ? extends Serializable> values, Node parent) {
        Document doc = parent.getOwnerDocument();
        doc.getDocumentElement().setAttributeNS(NS_XMLNS, "xmlns:cmn", NS_CMN);
        for (String name : new TreeSet<String>(types.keySet())) {
            Element child = doc.createElementNS(NS_CMN, "cmn:parameter");
            child.setAttributeNS(null, "name", name);
            ProcessConstants.AdeptDataType type = types.get(name);
            child.setAttributeNS(null, "type", type.name());
            if (nullValues != null && nullValues.contains(name) || values.get(name) == null) {
                child.setAttributeNS(null, "isNull", Boolean.toString(true));
            } else {
                switch (type) {
                    case BOOLEAN: {
                        DataContainerXMLExport.marshalBoolean((Boolean)values.get(name), child);
                        break;
                    }
                    case DATE: {
                        DataContainerXMLExport.marshalDate((Date)values.get(name), child);
                        break;
                    }
                    case FLOAT: {
                        DataContainerXMLExport.marshalDouble((Double)values.get(name), child);
                        break;
                    }
                    case INTEGER: {
                        DataContainerXMLExport.marshalLong((Long)values.get(name), child);
                        break;
                    }
                    case STRING: {
                        child.setTextContent((String)((Object)values.get(name)));
                        break;
                    }
                    case URI: {
                        DataContainerXMLExport.marshalURI((URI)values.get(name), child);
                        break;
                    }
                    case USERDEFINED: {
                        DataContainerXMLExport.marshalUDTValue((UDTValue)values.get(name), child);
                    }
                }
            }
            parent.appendChild(child);
        }
    }

    private static void marshalUDTValue(UDTValue udt, Element node) {
        node.setAttributeNS(null, "udtName", udt.getUserDefinedType());
        node.setTextContent(Base64.encodeBytes(udt.getValueAsArray()));
    }

    private static void marshalBoolean(boolean b, Node node) {
        node.setTextContent(Boolean.toString(b));
    }

    private static void marshalBooleanArray(boolean[] bArray, Node parent) {
        Document doc = parent.getOwnerDocument();
        doc.getDocumentElement().setAttributeNS(NS_XMLNS, "xmlns:bsc", NS_BSC);
        boolean[] blArray = bArray;
        int n = bArray.length;
        int n2 = 0;
        while (n2 < n) {
            boolean b = blArray[n2];
            Element child = doc.createElementNS(NS_BSC, "bsc:boolean");
            DataContainerXMLExport.marshalBoolean(b, child);
            parent.appendChild(child);
            ++n2;
        }
    }

    private static void marshalDouble(double d, Node node) {
        node.setTextContent(Double.toString(d));
    }

    private static void marshalLong(long l, Node node) {
        node.setTextContent(Long.toString(l));
    }

    private static void marshalStringList(Collection<String> strings, Node parent) {
        Document doc = parent.getOwnerDocument();
        doc.getDocumentElement().setAttributeNS(NS_XMLNS, "xmlns:bsc", NS_BSC);
        for (String string : strings) {
            Element child = doc.createElementNS(NS_BSC, "bsc:entry");
            child.setTextContent(string);
            parent.appendChild(child);
        }
    }

    private static void marshalURI(URI uri, Node node) {
        node.setTextContent(uri.toString());
    }

    private static void marshalDate(Date date, Node node) {
        node.setTextContent(ConfigurationTools.toString(date));
    }
}

