/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.datamanagement.defaultimplementation.xml;

import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.model.common.XMLImportTools;
import de.aristaflow.adept2.model.datamanagement.ADEPT2UDTValue;
import de.aristaflow.adept2.model.datamanagement.DataContainer;
import de.aristaflow.adept2.model.datamanagement.IndexedAccessDataContainer;
import de.aristaflow.adept2.model.datamanagement.InvalidDataContainerException;
import de.aristaflow.adept2.model.datamanagement.UDTValue;
import de.aristaflow.adept2.model.datamanagement.defaultimplementation.DefaultIndexedAccessDataContainer;
import de.aristaflow.adept2.model.datamanagement.defaultimplementation.DefaultPersistedDataContainer;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.util.Base64;
import de.aristaflow.adept2.util.ConfigurationTools;
import de.aristaflow.adept2.util.types.Pair;
import de.aristaflow.adept2.util.types.Triple;
import de.aristaflow.adept2.util.xml.XMLFormatException;
import de.aristaflow.adept2.util.xml.XMLHelperTools;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.xml.validation.Schema;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DataContainerXMLImport {
    public static DataContainer getDataContainerFromDocument(Document doc) {
        Element root = doc.getDocumentElement();
        return DataContainerXMLImport.getDataContainerFromElement(root);
    }

    public static DataContainer getDataContainerFromElement(Element dcElement) {
        HashSet<String> unsavedNullValues = new HashSet<String>();
        HashMap<String, Serializable> unsavedValues = new HashMap();
        LinkedList<DataContainer.Savepoint> savePoints = new LinkedList();
        HashMap<String, String> userAttributes = new HashMap();
        UUID instanceID = UUID.fromString(dcElement.getAttribute("instanceID"));
        int nodeID = Integer.parseInt(dcElement.getAttribute("nodeID"));
        int nodeIteration = Integer.parseInt(dcElement.getAttribute("nodeIteration"));
        Element child = DataContainerXMLImport.getElement(dcElement.getFirstChild());
        Map<String, ProcessConstants.AdeptDataType> unsavedTypes = DataContainerXMLImport.getTypesMap(child);
        child = DataContainerXMLImport.getElement(child.getNextSibling());
        while (child != null && DataContainerXMLImport.getTagName(child).equals("unsavedNullValue")) {
            unsavedNullValues.add(child.getAttribute("name"));
            child = DataContainerXMLImport.getElement(child.getNextSibling());
        }
        if (child != null && DataContainerXMLImport.getTagName(child).equals("unsavedValues")) {
            unsavedValues = DataContainerXMLImport.getValuesMap(child, unsavedTypes);
            child = DataContainerXMLImport.getElement(child.getNextSibling());
        }
        if (child != null && DataContainerXMLImport.getTagName(child).equals("unsavedSessions")) {
            savePoints = DataContainerXMLImport.getSavepoints(child);
            child = DataContainerXMLImport.getElement(child.getNextSibling());
        }
        if (child != null && DataContainerXMLImport.getTagName(child).equals("userAttributes")) {
            userAttributes = XMLImportTools.getUserAttributes(child);
        }
        return new DefaultPersistedDataContainer(instanceID, nodeID, nodeIteration, unsavedTypes, unsavedNullValues, unsavedValues, savePoints, userAttributes);
    }

    private static Map<String, ProcessConstants.AdeptDataType> getTypesMap(Element typesElement) {
        HashMap<String, ProcessConstants.AdeptDataType> typesMap = new HashMap<String, ProcessConstants.AdeptDataType>();
        Element child = DataContainerXMLImport.getElement(typesElement.getFirstChild());
        while (child != null) {
            String name = child.getAttribute("name");
            String adt = child.getTextContent();
            ProcessConstants.AdeptDataType type = null;
            if (adt != null && adt.length() > 0) {
                type = ProcessConstants.AdeptDataType.valueOf(adt);
            }
            typesMap.put(name, type);
            child = DataContainerXMLImport.getElement(child.getNextSibling());
        }
        return typesMap;
    }

    private static Map<String, Serializable> getValuesMap(Element valuesElement, Map<String, ProcessConstants.AdeptDataType> types) {
        HashMap<String, Serializable> valuesMap = new HashMap<String, Serializable>();
        Element child = DataContainerXMLImport.getElement(valuesElement.getFirstChild());
        while (child != null) {
            String name = child.getAttribute("name");
            valuesMap.put(name, DataContainerXMLImport.getValue(child.getTextContent(), name, types));
            child = DataContainerXMLImport.getElement(child.getNextSibling());
        }
        return valuesMap;
    }

    private static Serializable getValue(String stringValue, String name, Map<String, ProcessConstants.AdeptDataType> types) {
        Object value;
        switch (types.get(name)) {
            case BOOLEAN: {
                value = Boolean.valueOf(stringValue);
                break;
            }
            case DATE: {
                value = new Date(Long.parseLong(stringValue));
                break;
            }
            case FLOAT: {
                value = Double.valueOf(stringValue);
                break;
            }
            case INTEGER: {
                value = Long.valueOf(stringValue);
                break;
            }
            case STRING: {
                value = stringValue;
                break;
            }
            case URI: {
                value = URI.create(stringValue);
                break;
            }
            case USERDEFINED: {
                value = (UDTValue)Base64.decodeToObject(stringValue);
                break;
            }
            default: {
                throw new RuntimeException("An unexpected data type was found: " + (Object)((Object)types.get(name)));
            }
        }
        return value;
    }

    private static Collection<DataContainer.Savepoint> getSavepoints(Element spsElement) {
        LinkedList<DataContainer.Savepoint> savepoints = new LinkedList<DataContainer.Savepoint>();
        Element child = DataContainerXMLImport.getElement(spsElement.getFirstChild());
        while (child != null) {
            int savepointID = Integer.parseInt(child.getAttribute("savepointID"));
            byte[] sessionState = null;
            String encodedState = child.getTextContent();
            if (encodedState.length() % 4 == 0) {
                sessionState = Base64.decode(encodedState);
            } else if (encodedState.charAt(0) == 'R') {
                sessionState = Base64.decode(encodedState.substring(1));
            }
            savepoints.add(new DataContainer.Savepoint(savepointID, sessionState));
            child = DataContainerXMLImport.getElement(child.getNextSibling());
        }
        return savepoints;
    }

    private static String getTagName(Element child) {
        String tagname = child.getLocalName() != null ? child.getLocalName() : child.getTagName();
        return tagname;
    }

    private static Element getElement(Node node) {
        return XMLHelperTools.getElement(node);
    }

    public static IndexedAccessDataContainer getIndexedAccessDataContainerFromBytes(byte[] bytes, Schema schema, SessionToken session, DataContainer parentData) throws IOException, XMLFormatException, InvalidDataContainerException {
        ByteArrayInputStream docStream = new ByteArrayInputStream(bytes);
        Document doc = XMLHelperTools.getDocumentFromStream(docStream, schema, null, true);
        Element root = doc.getDocumentElement();
        return DataContainerXMLImport.unmarshalIndexedAccessDataContainer(session, parentData, root);
    }

    public static IndexedAccessDataContainer unmarshalIndexedAccessDataContainer(SessionToken session, DataContainer dataContainer, Node node) throws InvalidDataContainerException {
        HashSet<String> indexedInParams = new HashSet(0);
        HashSet<String> optionalIndexedInParams = new HashSet(0);
        HashSet<String> mandatoryOutParams = new HashSet(0);
        HashMap<String, UDTValue> outputParams = new HashMap<String, UDTValue>(0);
        Element child = DataContainerXMLImport.getElement(node.getFirstChild());
        if (XMLHelperTools.hasTagName(child, "indexedInParams")) {
            indexedInParams = DataContainerXMLImport.unmarshalStringSet(child);
            child = DataContainerXMLImport.getElement(child.getNextSibling());
        }
        if (XMLHelperTools.hasTagName(child, "optionalIndexedInParams")) {
            optionalIndexedInParams = DataContainerXMLImport.unmarshalStringSet(child);
            child = DataContainerXMLImport.getElement(child.getNextSibling());
        }
        if (XMLHelperTools.hasTagName(child, "mandatoryOutParams")) {
            mandatoryOutParams = DataContainerXMLImport.unmarshalStringSet(child);
            child = DataContainerXMLImport.getElement(child.getNextSibling());
        }
        if (XMLHelperTools.hasTagName(child, "outputParams")) {
            Pair<Map<String, ProcessConstants.AdeptDataType>, Map<String, Serializable>> outputParameter = DataContainerXMLImport.unmarshalParameterValues(child);
            Map<String, ProcessConstants.AdeptDataType> types = outputParameter.getFirst();
            Map<String, Serializable> values = outputParameter.getSecond();
            outputParams = new HashMap(types.size());
            for (String name : types.keySet()) {
                outputParams.put(name, (UDTValue)values.get(name));
            }
            child = DataContainerXMLImport.getElement(child.getNextSibling());
        }
        boolean[] validated = DataContainerXMLImport.unmarshalBooleanArray(child);
        return new DefaultIndexedAccessDataContainer(session, dataContainer, indexedInParams, optionalIndexedInParams, mandatoryOutParams, outputParams, validated);
    }

    private static Pair<Map<String, ProcessConstants.AdeptDataType>, Map<String, Serializable>> unmarshalParameterValues(Node node) {
        HashMap<String, ProcessConstants.AdeptDataType> types = new HashMap<String, ProcessConstants.AdeptDataType>();
        HashMap<String, Serializable> parameters = new HashMap<String, Serializable>();
        if (node != null) {
            Element child = DataContainerXMLImport.getElement(node.getFirstChild());
            while (child != null) {
                Triple<String, ProcessConstants.AdeptDataType, Serializable> triple = DataContainerXMLImport.unmarshalParameterValue(child);
                types.put(triple.getFirst(), triple.getSecond());
                if (triple.getThird() != null) {
                    parameters.put(triple.getFirst(), triple.getThird());
                }
                child = DataContainerXMLImport.getElement(child.getNextSibling());
            }
        }
        return new Pair<Map<String, ProcessConstants.AdeptDataType>, Map<String, Serializable>>(types, parameters);
    }

    private static Triple<String, ProcessConstants.AdeptDataType, Serializable> unmarshalParameterValue(Element node) {
        String name = node.getAttribute("name");
        ProcessConstants.AdeptDataType type = ProcessConstants.AdeptDataType.valueOf(node.getAttribute("type"));
        boolean isNull = Boolean.parseBoolean(node.getAttribute("isNull"));
        Object value = null;
        if (!isNull) {
            switch (type) {
                case BOOLEAN: {
                    value = DataContainerXMLImport.unmarshalBoolean(node);
                    break;
                }
                case DATE: {
                    value = DataContainerXMLImport.unmarshalDate(node);
                    break;
                }
                case FLOAT: {
                    value = DataContainerXMLImport.unmarshalDouble(node);
                    break;
                }
                case INTEGER: {
                    value = DataContainerXMLImport.unmarshalLong(node);
                    break;
                }
                case STRING: {
                    value = node.getTextContent();
                    break;
                }
                case URI: {
                    value = DataContainerXMLImport.unmarshalURI(node);
                    break;
                }
                case USERDEFINED: {
                    String udtName = node.getAttribute("udtName");
                    byte[] bytes = DataContainerXMLImport.unmarshalByteArray(node);
                    value = new ADEPT2UDTValue(udtName, bytes);
                }
            }
        }
        return new Triple<String, ProcessConstants.AdeptDataType, Object>(name, type, value);
    }

    private static boolean unmarshalBoolean(Node node) {
        return Boolean.parseBoolean(node.getTextContent());
    }

    private static boolean[] unmarshalBooleanArray(Node node) {
        ArrayList<Boolean> list = new ArrayList<Boolean>();
        Element child = DataContainerXMLImport.getElement(node.getFirstChild());
        while (child != null) {
            list.add(DataContainerXMLImport.unmarshalBoolean(child));
            child = DataContainerXMLImport.getElement(child.getNextSibling());
        }
        boolean[] ret = new boolean[list.size()];
        int i = 0;
        while (i < ret.length) {
            ret[i] = (Boolean)list.get(i);
            ++i;
        }
        return ret;
    }

    private static double unmarshalDouble(Node node) {
        return Double.parseDouble(node.getTextContent());
    }

    private static long unmarshalLong(Node node) {
        return Long.parseLong(node.getTextContent());
    }

    private static Set<String> unmarshalStringSet(Node node) {
        HashSet<String> set = new HashSet<String>();
        Element child = DataContainerXMLImport.getElement(node.getFirstChild());
        while (child != null) {
            set.add(child.getTextContent());
            child = DataContainerXMLImport.getElement(child.getNextSibling());
        }
        return set;
    }

    private static URI unmarshalURI(Node node) {
        return URI.create(node.getTextContent());
    }

    private static byte[] unmarshalByteArray(Node node) {
        return Base64.decode(node.getTextContent());
    }

    private static Date unmarshalDate(Node node) {
        return ConfigurationTools.parseDate(node.getTextContent());
    }
}

