/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.eventmodel.defaultimplementation;

import de.aristaflow.adept2.model.eventmodel.EventClass;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DefaultEventClass
implements EventClass {
    private List<String> classification;
    private String description;
    private String eventName;
    private String eventClassID;
    private Map<String, Class<?>> knownAttributes;

    public DefaultEventClass(String eventTypeID, String eventName, String description, List<String> classification, Map<String, Class<?>> knownAttributes) {
        this.eventClassID = eventTypeID;
        this.eventName = eventName;
        this.description = description;
        this.classification = new ArrayList<String>(classification);
        this.knownAttributes = new HashMap(knownAttributes);
    }

    @Override
    public List<String> getClassification() {
        return this.classification;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getEventName() {
        return this.eventName;
    }

    @Override
    public String getEventClassID() {
        return this.eventClassID;
    }

    @Override
    public Map<String, Class<?>> getAttributes() {
        return Collections.unmodifiableMap(this.knownAttributes);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof String) {
            String other = (String)obj;
            return this.eventClassID.equals(other);
        }
        if (obj instanceof EventClass) {
            EventClass other = (EventClass)obj;
            return this.eventClassID.equals(other.getEventClassID());
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return this.eventClassID.hashCode();
    }
}

