/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.eventmodel.defaultimplementation;

import de.aristaflow.adept2.model.eventmodel.EventReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class DefaultEventReference
implements EventReference {
    private final Map<String, Object> attributes;
    private final long timestamp;
    private final String eventClassID;
    private final String sourceID;
    private final String eventID;
    private final long eventNumber;

    public DefaultEventReference(String sourceID, long eventNumber, String eventTypeID, String eventID, long timestamp, Map<String, Object> attributes) {
        this.eventNumber = eventNumber;
        this.eventID = eventID;
        this.sourceID = sourceID;
        this.eventClassID = eventTypeID;
        this.timestamp = timestamp;
        this.attributes = new HashMap<String, Object>(attributes);
    }

    @Override
    public String getEventID() {
        return this.eventID;
    }

    @Override
    public String getEventClassID() {
        return this.eventClassID;
    }

    protected static Map<String, String> initializeAttributes(Map<String, String> map, String[] ... items) {
        HashMap<String, String> res = map != null ? map : new HashMap<String, String>();
        String[][] stringArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            String[] m = stringArray[n2];
            if (m.length != 2) {
                throw new IllegalArgumentException();
            }
            res.put(m[0], m[1]);
            ++n2;
        }
        return res;
    }

    protected static Set<String> initializeClassification(Set<String> set, String ... classes) {
        HashSet<String> res = set != null ? set : new HashSet<String>();
        String[] stringArray = classes;
        int n = classes.length;
        int n2 = 0;
        while (n2 < n) {
            String cls = stringArray[n2];
            res.add(cls);
            ++n2;
        }
        return res;
    }

    @Override
    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    @Override
    public Map<String, Object> getAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    @Override
    public long getTimeStamp() {
        return this.timestamp;
    }

    @Override
    public String getSourceID() {
        return this.sourceID;
    }

    public String toString() {
        return this.getEventID();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof EventReference) {
            EventReference other = (EventReference)obj;
            if (!this.getEventID().equals(other.getEventID())) {
                return false;
            }
            return this.attributes.equals(other.getAttributes());
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return this.getEventID().hashCode();
    }

    @Override
    public long getEventNumber() {
        return this.eventNumber;
    }
}

