/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.execution.defaultimplementation;

import de.aristaflow.adept2.model.common.ActivityConfiguration;
import de.aristaflow.adept2.model.common.ExecutionControlProperties;
import de.aristaflow.adept2.model.common.PluginDataContainer;
import de.aristaflow.adept2.model.execution.ActivityInstance;
import de.aristaflow.adept2.model.execution.DecisionActivityInstance;
import de.aristaflow.adept2.model.execution.ParameterDataContext;
import de.aristaflow.adept2.model.execution.defaultimplementation.DefaultActivityInstance;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.EBPType;
import de.aristaflow.adept2.model.processmodel.DecisionStatement;
import de.aristaflow.adept2.model.processmodel.ProcessModelParameter;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class DefaultDecisionActivityInstance
extends DefaultActivityInstance
implements DecisionActivityInstance {
    private static final long serialVersionUID = -7479792521754182644L;
    protected ProcessModelParameter decisionParameter;
    protected HashMap<Long, DecisionStatement> decisionStatements;

    public DefaultDecisionActivityInstance(UUID id, String processTemplateName, String processInstanceName, UUID instanceLogID, String executableComponentName, String operationName, String configurationSetName, String activityName, String name, String description, String implementationClass, Map<ActivityConstants.ActivityModelEntityType, List<String>> separatedClassPaths, boolean isSingleton, byte[] systemComponentSignature, String guiContextID, ExecutionControlProperties executionControlProperties, boolean supportsViewOnly, UUID iconID, Map<ActivityConstants.LocallyOverrideableActivityAttribute, ActivityConstants.ActivityModelEntityType> attributeOrigins, ActivityConfiguration configuration, Collection<ProcessModelParameter> inputParameters, Collection<ProcessModelParameter> outputParameters, ParameterDataContext attachedDataContext, PluginDataContainer pluginData, Map<String, String> userAttributes, ProcessModelParameter decisionParameter, List<DecisionStatement> decisionStatements) {
        super(EBPType.DECISION_ACTIVITY, id, processTemplateName, processInstanceName, instanceLogID, executableComponentName, operationName, configurationSetName, activityName, name, description, implementationClass, separatedClassPaths, isSingleton, systemComponentSignature, guiContextID, executionControlProperties, supportsViewOnly, iconID, attributeOrigins, configuration, inputParameters, outputParameters, attachedDataContext, pluginData, userAttributes);
        this.setAllDecisionStatements(decisionStatements);
        this.setDecisionParameter(decisionParameter);
    }

    public DefaultDecisionActivityInstance(ActivityInstance activity, ProcessModelParameter decisionParameter, List<DecisionStatement> decisionStatements) {
        super(EBPType.DECISION_ACTIVITY, activity.getID(), activity.getProcessTemplateName(), activity.getProcessInstanceName(), activity.getProcessInstanceLogID(), activity.getExecutableComponentName(), activity.getOperationName(), activity.getConfigurationName(), activity.getActivityName(), activity.getName(), activity.getDescription(), activity.getImplementationClass(), activity.getSeparatedClassPaths(), activity.isSingleton(), activity.getSystemComponent(), activity.getGUIContextID(), activity.getExecutionControlProperties(), activity.supportsViewOnly(), activity.getIconID(), activity.getAttributeOrigins(), activity.getConfiguration(), activity.getParameters(ActivityConstants.AccessType.READ), activity.getParameters(ActivityConstants.AccessType.WRITE), activity.getAttachedDataContext(), activity, activity.getUserAttributes());
        this.setAllDecisionStatements(decisionStatements);
        this.setDecisionParameter(decisionParameter);
    }

    @Override
    public long[] getDecisionIDs() {
        long[] result = new long[this.decisionStatements.values().size()];
        int i = 0;
        for (DecisionStatement d : this.decisionStatements.values()) {
            result[i++] = d.getDecisionID();
        }
        return result;
    }

    @Override
    public String getDecisionLabel(long decisionID) {
        return this.decisionStatements.get(decisionID).getDecisionLabel();
    }

    @Override
    public String getDecisionStatement(long decisionID) {
        return this.decisionStatements.get(decisionID).getDecisionStatement();
    }

    @Override
    public ProcessModelParameter getDecisionParameter() {
        return this.decisionParameter;
    }

    private void setDecisionParameter(ProcessModelParameter decisionParameter) {
        this.decisionParameter = decisionParameter;
    }

    @Override
    public Collection<DecisionStatement> getAllDecisionStatements() {
        return Collections.unmodifiableCollection(this.decisionStatements.values());
    }

    private void setAllDecisionStatements(List<DecisionStatement> decisionStatements) {
        this.decisionStatements = new HashMap();
        for (DecisionStatement d : decisionStatements) {
            this.decisionStatements.put(d.getDecisionID(), d);
        }
    }
}

