/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.execution.defaultimplementation;

import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.model.execution.Enquiry;
import de.aristaflow.adept2.util.ArgChecks;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class DefaultEnquiry
implements Enquiry {
    private static final long serialVersionUID = -1784624524843177414L;
    private final QualifiedAgent originator;
    private final HashSet<QualifiedAgent> recipients;
    private final String question;
    private String reply;
    private QualifiedAgent replier;

    public DefaultEnquiry(QualifiedAgent originator, Set<QualifiedAgent> recipients, String question, String reply, QualifiedAgent replier) {
        this.originator = originator;
        this.recipients = new HashSet<QualifiedAgent>(recipients);
        this.question = question;
        this.reply = reply;
        this.replier = replier;
    }

    @Override
    public QualifiedAgent getOriginator() {
        return this.originator;
    }

    @Override
    public String getQuestion() {
        String ret = this.question;
        if (ret == null) {
            ret = "";
        }
        return ret;
    }

    @Override
    public Set<QualifiedAgent> getRecipients() {
        return Collections.unmodifiableSet(this.recipients);
    }

    @Override
    public String getReply() {
        return this.reply;
    }

    @Override
    public QualifiedAgent getReplier() {
        return this.replier;
    }

    public void setReply(String reply, QualifiedAgent replier) {
        ArgChecks.checkForNull(replier, "replier");
        this.reply = reply;
        this.replier = replier;
    }
}

