/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.execution.defaultimplementation;

import de.aristaflow.adept2.model.common.Configuration;
import de.aristaflow.adept2.model.common.ExecutionControlProperties;
import de.aristaflow.adept2.model.common.PluginDataContainer;
import de.aristaflow.adept2.model.common.defaultimplementation.CommonImpl;
import de.aristaflow.adept2.model.common.defaultimplementation.SerialisablePluginDataContainer;
import de.aristaflow.adept2.model.execution.ExecutableBusinessProcessInstance;
import de.aristaflow.adept2.model.execution.ParameterDataContext;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.EBPType;
import de.aristaflow.adept2.model.processmodel.ProcessModelParameter;
import de.aristaflow.adept2.util.ArgChecks;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class DefaultExecutableBusinessProcessInstance
extends SerialisablePluginDataContainer
implements ExecutableBusinessProcessInstance {
    private static final long serialVersionUID = -5247065271547704134L;
    protected EBPType type;
    protected final String processTemplateName;
    protected final String processInstanceName;
    protected final UUID instanceLogID;
    protected String name;
    protected String description;
    protected UUID iconID;
    protected ExecutionControlProperties executionControlProperties;
    protected Configuration configuration;
    protected final HashMap<ActivityConstants.AccessType, HashMap<String, ProcessModelParameter>> parameters;
    protected final ParameterDataContext dataContext;

    public DefaultExecutableBusinessProcessInstance(EBPType type, String processTemplateName, String processInstanceName, UUID instanceLogID, String name, String description, UUID iconID, ExecutionControlProperties executionControlProperties, Configuration configuration, Set<ProcessModelParameter> inputParameters, Set<ProcessModelParameter> outputParameters, ParameterDataContext dataContext, PluginDataContainer pluginData, Map<String, String> userAttributes) {
        super(pluginData, userAttributes);
        this.type = type;
        this.processTemplateName = processTemplateName;
        this.processInstanceName = processInstanceName;
        this.instanceLogID = instanceLogID;
        this.name = name;
        this.description = description;
        this.iconID = iconID;
        this.executionControlProperties = executionControlProperties;
        this.configuration = configuration;
        this.parameters = new HashMap();
        this.setParameters(ActivityConstants.AccessType.READ, inputParameters);
        this.setParameters(ActivityConstants.AccessType.WRITE, outputParameters);
        this.dataContext = dataContext;
    }

    @Override
    public EBPType getType() {
        return this.type;
    }

    @Override
    public String getProcessTemplateName() {
        return this.processTemplateName;
    }

    @Override
    public String getProcessInstanceName() {
        return this.processInstanceName;
    }

    @Override
    public UUID getProcessInstanceLogID() {
        return this.instanceLogID;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public UUID getIconID() {
        return this.iconID;
    }

    @Override
    public ExecutionControlProperties getExecutionControlProperties() {
        return this.executionControlProperties;
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Override
    public ProcessModelParameter getParameter(String name, ActivityConstants.AccessType accessType) {
        ArgChecks.checkEnum((Object)accessType, "accessType", new Object[]{ActivityConstants.AccessType.READ, ActivityConstants.AccessType.WRITE});
        ArgChecks.checkForNull(name, "name");
        return this.parameters.get((Object)accessType).get(name);
    }

    @Override
    public Set<ProcessModelParameter> getParameters(ActivityConstants.AccessType accessType) {
        ArgChecks.checkEnum((Object)accessType, "accessType", new Object[]{ActivityConstants.AccessType.READ, ActivityConstants.AccessType.WRITE});
        return new HashSet<ProcessModelParameter>(this.parameters.get((Object)accessType).values());
    }

    protected void setParameters(ActivityConstants.AccessType accessType, Set<ProcessModelParameter> parameters) {
        ArgChecks.checkEnum((Object)accessType, "accessType", new Object[]{ActivityConstants.AccessType.READ, ActivityConstants.AccessType.WRITE});
        CommonImpl.setParameters(this.parameters, accessType, parameters);
    }

    @Override
    public ParameterDataContext getAttachedDataContext() {
        return this.dataContext;
    }
}

