/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.execution.defaultimplementation;

import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.model.common.PluginData;
import de.aristaflow.adept2.model.common.defaultimplementation.DefaultPluginData;
import de.aristaflow.adept2.model.execution.Enquiry;
import de.aristaflow.adept2.model.execution.ExecutableInstance;
import de.aristaflow.adept2.model.execution.ExecutableInstancePropertyTracker;
import de.aristaflow.adept2.model.execution.defaultimplementation.DefaultEnquiry;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.EBPInstanceReference;
import de.aristaflow.adept2.model.processmodel.Instance;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.defaultimplementation.DefaultInstance;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public class DefaultExecutableInstance
extends DefaultInstance
implements ExecutableInstance,
ExecutableInstancePropertyTracker {
    private static final long serialVersionUID = -5703844143006478578L;
    protected Map<Integer, URI[]> nodesToRuntimeManagerMapping = new ConcurrentHashMap<Integer, URI[]>();
    protected URI[] instanceTerminationCallbackURI = null;
    private HashMap<Integer, List<Enquiry>> currentEnquiries;
    private HashMap<Integer, Enquiry> repliedEnquiries;
    private final Set<ExecutableInstancePropertyTracker.ExecutableInstanceProperty> changedProperties = new HashSet<ExecutableInstancePropertyTracker.ExecutableInstanceProperty>();
    private final Map<Integer, Set<ExecutableInstancePropertyTracker.ExecutableInstanceNodeProperty>> changedNodeProperties = new HashMap<Integer, Set<ExecutableInstancePropertyTracker.ExecutableInstanceNodeProperty>>();

    public DefaultExecutableInstance(UUID instanceID, UUID logID, String instanceName, UUID baseTemplateID, Template template, QualifiedAgent supervisorAgent, QualifiedAgent initiatorAgent, EBPInstanceReference parentReference, long creationTime) {
        super(template, logID, baseTemplateID, creationTime);
        this.setID(instanceID);
        this.setName(instanceName);
        this.setSupervisorAgent(supervisorAgent);
        this.setInitiatorAgent(initiatorAgent);
        this.setParentEBPReference(parentReference);
        this.clearChangedProperties();
    }

    public DefaultExecutableInstance(Instance instance) {
        this(instance.getID(), instance.getLogID(), instance.getName(), instance.getBaseTemplateID(), instance.getTemplate(), instance.getSupervisorAgent(), instance.getInitiatorAgent(), instance.getParentEBPReference(), instance.getCreationTime());
        for (Node node : this.template.getNodes()) {
            this.setNodeState(node.getID(), instance.getNodeState(node.getID()));
        }
        this.clearChangedProperties();
    }

    public DefaultExecutableInstance(Instance instance, ExecutableInstance executableInstance) {
        this(instance.getID(), instance.getLogID(), instance.getName(), instance.getBaseTemplateID(), instance.getTemplate(), instance.getSupervisorAgent(), instance.getInitiatorAgent(), instance.getParentEBPReference(), instance.getCreationTime());
        this.setModified(instance.isModified());
        if (instance.getSupportedPlugins() != null) {
            for (Map.Entry<String, Set<String>> pdcEntry : instance.getSupportedPlugins().entrySet()) {
                for (String pluginID : pdcEntry.getValue()) {
                    if (!instance.getPluginDatas().containsKey(pluginID)) continue;
                    this.addSupportedPlugin(pdcEntry.getKey(), pluginID, instance.getPluginData(pluginID));
                }
            }
        }
        this.setUserAttributes(instance.getUserAttributes());
        this.setInstanceStateListener(executableInstance.getInstanceStateListener());
        for (Node node : this.template.getNodes()) {
            int nodeID = node.getID();
            this.setNodeState(nodeID, instance.getNodeState(nodeID));
            this.setExecutionMode(nodeID, instance.getExecutionMode(nodeID));
            this.setNodeIteration(nodeID, instance.getNodeIteration(nodeID));
            this.setNodeLWPInstanceID(nodeID, instance.getNodeLWPInstanceID(nodeID));
            this.setPerformingAgent(nodeID, instance.getPerformingAgent(nodeID));
            if (this.currentEnquiries == null) {
                this.currentEnquiries = new HashMap();
            }
            this.currentEnquiries.put(nodeID, executableInstance.getCurrentEnquiries(nodeID));
            if (this.repliedEnquiries == null) {
                this.repliedEnquiries = new HashMap();
            }
            this.repliedEnquiries.put(nodeID, executableInstance.getRepliedEnquiry(nodeID));
            this.setAssignedRuntimeManager(nodeID, executableInstance.getAssignedRuntimeManager(nodeID));
        }
        this.clearChangedProperties();
    }

    public DefaultExecutableInstance(UUID instanceID, UUID logID, String instanceName, boolean modified, UUID baseTemplateID, Template template, QualifiedAgent supervisorAgent, QualifiedAgent initiatorAgent, EBPInstanceReference parentReference, long creationTime, Map<Integer, ProcessConstants.NodeState> nodeStates, Map<Integer, ProcessConstants.ExecutionMode> executionModes, Map<Integer, Integer> nodeIterations, Map<Integer, List<UUID>> nodeLWPInstanceIDs, Map<Integer, QualifiedAgent> nodePerformingAgents, Map<Integer, List<Enquiry>> currentEnquiries, Map<Integer, Enquiry> repliedEnquiries, URI[] instanceTerminationCallbackURIs, Map<Integer, URI[]> runtimeManagerURIs, Map<String, Set<String>> supportedPlugins, Map<String, PluginData> pluginData, Map<String, String> userAttributes) {
        this(instanceID, logID, instanceName, baseTemplateID, template, supervisorAgent, initiatorAgent, parentReference, creationTime);
        this.setModified(modified);
        for (Map.Entry<Integer, ProcessConstants.NodeState> entry : nodeStates.entrySet()) {
            this.setNodeState(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<Integer, Enum> entry : executionModes.entrySet()) {
            this.setExecutionMode(entry.getKey(), (ProcessConstants.ExecutionMode)entry.getValue());
        }
        for (Map.Entry<Integer, Object> entry : nodeIterations.entrySet()) {
            this.setNodeIteration(entry.getKey(), (Integer)entry.getValue());
        }
        for (Map.Entry<Integer, Object> entry : nodeLWPInstanceIDs.entrySet()) {
            for (UUID lwpInstanceID : (List)entry.getValue()) {
                this.addNodeLWPInstanceID(entry.getKey(), lwpInstanceID);
            }
        }
        for (Map.Entry<Integer, Object> entry : nodePerformingAgents.entrySet()) {
            this.setPerformingAgent(entry.getKey(), (QualifiedAgent)entry.getValue());
        }
        this.currentEnquiries = new HashMap<Integer, List<Enquiry>>(currentEnquiries);
        this.repliedEnquiries = new HashMap<Integer, Enquiry>(repliedEnquiries);
        this.setInstanceStateListener(instanceTerminationCallbackURIs);
        for (Map.Entry<Integer, Object> entry : runtimeManagerURIs.entrySet()) {
            this.setAssignedRuntimeManager(entry.getKey(), (URI[])entry.getValue());
        }
        if (supportedPlugins != null) {
            for (Map.Entry<Object, Object> entry : supportedPlugins.entrySet()) {
                for (String pluginID : (Set)entry.getValue()) {
                    if (!pluginData.containsKey(pluginID)) continue;
                    this.addSupportedPlugin((String)entry.getKey(), pluginID, pluginData.get(pluginID));
                }
            }
        }
        this.setUserAttributes(userAttributes);
        this.clearChangedProperties();
    }

    @Override
    public int increaseNodeIteration(int nodeID) {
        int ret = super.getNodeIteration(nodeID);
        super.setNodeIteration(nodeID, ++ret);
        this.getOrCreateNodeProperties(nodeID).add(ExecutableInstancePropertyTracker.ExecutableInstanceNodeProperty.ITERATION);
        return ret;
    }

    @Override
    public void setNodeState(int nodeID, ProcessConstants.NodeState state) {
        super.setNodeState(nodeID, state);
        this.getOrCreateNodeProperties(nodeID).add(ExecutableInstancePropertyTracker.ExecutableInstanceNodeProperty.STATE);
    }

    @Override
    public void addNodeLWPInstanceID(int nodeID, UUID lwpInstanceID) {
        super.addNodeLWPInstanceID(nodeID, lwpInstanceID);
        this.getOrCreateNodeProperties(nodeID).add(ExecutableInstancePropertyTracker.ExecutableInstanceNodeProperty.LWP_INSTANCE_ID);
    }

    @Override
    public void removeNodeLWPInstanceID(int nodeID, UUID lwpInstanceID) {
        super.removeNodeLWPInstanceID(nodeID, lwpInstanceID);
        this.getOrCreateNodeProperties(nodeID).add(ExecutableInstancePropertyTracker.ExecutableInstanceNodeProperty.LWP_INSTANCE_ID);
    }

    @Override
    public void setPerformingAgent(int nodeID, QualifiedAgent performingAgent) {
        super.setPerformingAgent(nodeID, performingAgent);
        this.getOrCreateNodeProperties(nodeID).add(ExecutableInstancePropertyTracker.ExecutableInstanceNodeProperty.PERFORMING_AGENT);
    }

    @Override
    public void setInstanceName(String instanceName) {
        super.setName(instanceName);
        this.changedProperties.add(ExecutableInstancePropertyTracker.ExecutableInstanceProperty.INSTANCE_NAME);
    }

    @Override
    public void setInstanceName(String instanceName, Map<String, String> plainNames) {
        HashMap<String, String> newData;
        super.setName(instanceName);
        String KEY_PREFIX = "Name";
        int plainNamesSize = plainNames != null ? plainNames.size() : 0;
        PluginData localPlugin = this.getPluginData("ProcessLocalisation");
        if (localPlugin != null) {
            Map<String, String> oldData = localPlugin.getPluginData();
            newData = new HashMap(oldData.size() + plainNamesSize);
            for (Map.Entry<String, String> oldEntry : oldData.entrySet()) {
                if (oldEntry.getKey().startsWith(KEY_PREFIX)) continue;
                newData.put(oldEntry.getKey(), oldEntry.getValue());
            }
        } else {
            newData = new HashMap<String, String>(plainNamesSize);
        }
        if (plainNamesSize > 0) {
            for (Map.Entry<String, String> newName : plainNames.entrySet()) {
                newData.put(String.format("%s.%s", KEY_PREFIX, newName.getKey()), newName.getValue());
            }
        }
        this.addSupportedPlugin("ProcessLocalisation", "ProcessLocalisation", new DefaultPluginData("ProcessLocalisation", newData));
        this.changedProperties.add(ExecutableInstancePropertyTracker.ExecutableInstanceProperty.INSTANCE_NAME);
        this.changedProperties.add(ExecutableInstancePropertyTracker.ExecutableInstanceProperty.PLUGIN_DATA);
    }

    @Override
    public int[] getNodesInState(ProcessConstants.NodeState state) {
        if (state == null) {
            throw new IllegalArgumentException("State must not be null!");
        }
        ArrayList<Node> nodesInState = new ArrayList<Node>(this.template.getNodes().size() / 2);
        for (Node node : this.template.getNodes()) {
            if (!this.getNodeState(node.getID()).equals((Object)state)) continue;
            nodesInState.add(node);
        }
        int[] ret = new int[nodesInState.size()];
        int i = 0;
        while (i < nodesInState.size()) {
            ret[i] = ((Node)nodesInState.get(i)).getID();
            ++i;
        }
        return ret;
    }

    @Override
    public void setExecutionMode(int nodeID, ProcessConstants.ExecutionMode executionMode) {
        super.setExecutionMode(nodeID, executionMode);
        this.getOrCreateNodeProperties(nodeID).add(ExecutableInstancePropertyTracker.ExecutableInstanceNodeProperty.EXECUTION_MODE);
    }

    @Override
    public URI[] getInstanceStateListener() {
        URI[] ret = null;
        if (this.instanceTerminationCallbackURI != null) {
            ret = (URI[])this.instanceTerminationCallbackURI.clone();
        }
        return ret;
    }

    @Override
    public void setInstanceStateListener(URI[] callback) {
        this.instanceTerminationCallbackURI = callback == null ? null : (URI[])callback.clone();
        this.changedProperties.add(ExecutableInstancePropertyTracker.ExecutableInstanceProperty.INSTANCE_STATE_LISTENER);
    }

    @Override
    public URI[] getAssignedRuntimeManager(int nodeID) {
        return this.nodesToRuntimeManagerMapping.get(nodeID);
    }

    @Override
    public void setAssignedRuntimeManager(int nodeID, URI[] runtimeManagerURIs) {
        if (runtimeManagerURIs == null) {
            this.nodesToRuntimeManagerMapping.remove(nodeID);
        } else {
            this.nodesToRuntimeManagerMapping.put(nodeID, runtimeManagerURIs);
        }
        this.getOrCreateNodeProperties(nodeID).add(ExecutableInstancePropertyTracker.ExecutableInstanceNodeProperty.ASSIGNED_RUNTIME_MANAGER);
    }

    @Override
    public List<Enquiry> getCurrentEnquiries(int nodeID) {
        ArrayList enquiries = this.currentEnquiries != null && this.currentEnquiries.containsKey(nodeID) ? new ArrayList(this.currentEnquiries.get(nodeID)) : new ArrayList();
        return Collections.unmodifiableList(enquiries);
    }

    @Override
    public Enquiry getRepliedEnquiry(int nodeID) {
        Enquiry enquiry = null;
        if (this.repliedEnquiries != null) {
            enquiry = this.repliedEnquiries.get(nodeID);
        }
        return enquiry;
    }

    @Override
    public void addEnquiry(int nodeID, Enquiry enquiry) {
        if (this.currentEnquiries == null) {
            this.currentEnquiries = new HashMap();
        }
        List<Enquiry> enquiries = this.currentEnquiries.containsKey(nodeID) ? this.currentEnquiries.get(nodeID) : new ArrayList<Enquiry>();
        enquiries.add(enquiry);
        this.currentEnquiries.put(nodeID, enquiries);
        this.getOrCreateNodeProperties(nodeID).add(ExecutableInstancePropertyTracker.ExecutableInstanceNodeProperty.ENQUIRIES);
    }

    @Override
    public void replyEnquiry(int nodeID, String reply, QualifiedAgent replier) {
        List<Enquiry> enquiries = this.currentEnquiries.get(nodeID);
        if (enquiries != null && enquiries.size() > 0) {
            DefaultEnquiry enquiry = (DefaultEnquiry)enquiries.remove(enquiries.size() - 1);
            if (reply != null) {
                enquiry.setReply(reply, replier);
            }
            this.currentEnquiries.put(nodeID, enquiries);
            if (this.repliedEnquiries == null) {
                this.repliedEnquiries = new HashMap();
            }
            this.repliedEnquiries.put(nodeID, enquiry);
        }
        this.getOrCreateNodeProperties(nodeID).add(ExecutableInstancePropertyTracker.ExecutableInstanceNodeProperty.ENQUIRIES);
    }

    @Override
    public void dropEnquiries(int nodeID) {
        if (this.currentEnquiries != null) {
            this.currentEnquiries.remove(nodeID);
        }
        if (this.repliedEnquiries != null) {
            this.repliedEnquiries.remove(nodeID);
        }
        this.getOrCreateNodeProperties(nodeID).add(ExecutableInstancePropertyTracker.ExecutableInstanceNodeProperty.ENQUIRIES);
    }

    @Override
    public Set<ExecutableInstancePropertyTracker.ExecutableInstanceProperty> getChangedProperties() {
        return Collections.unmodifiableSet(this.changedProperties);
    }

    @Override
    public Set<ExecutableInstancePropertyTracker.ExecutableInstanceNodeProperty> getChangedNodeProperties(int nodeID) {
        Set<ExecutableInstancePropertyTracker.ExecutableInstanceNodeProperty> props = this.changedNodeProperties.get(nodeID);
        if (props != null) {
            props = Collections.unmodifiableSet(props);
        }
        return props;
    }

    @Override
    public Set<Integer> getChangedNodes() {
        return Collections.unmodifiableSet(this.changedNodeProperties.keySet());
    }

    private Set<ExecutableInstancePropertyTracker.ExecutableInstanceNodeProperty> getOrCreateNodeProperties(int nodeID) {
        if (this.changedNodeProperties == null) {
            return new HashSet<ExecutableInstancePropertyTracker.ExecutableInstanceNodeProperty>();
        }
        Set<ExecutableInstancePropertyTracker.ExecutableInstanceNodeProperty> res = this.changedNodeProperties.get(nodeID);
        if (res == null) {
            res = new HashSet<ExecutableInstancePropertyTracker.ExecutableInstanceNodeProperty>();
            this.changedNodeProperties.put(nodeID, res);
        }
        return res;
    }

    @Override
    public void clearChangedProperties() {
        this.changedProperties.clear();
        this.changedNodeProperties.clear();
    }

    @Override
    public void addSupportedPlugin(String extensionPointID, String pluginID, PluginData data) {
        super.addSupportedPlugin(extensionPointID, pluginID, data);
        this.changedProperties.add(ExecutableInstancePropertyTracker.ExecutableInstanceProperty.PLUGIN_DATA);
    }

    @Override
    public void removeSupportedPlugin(String pluginID) {
        super.removeSupportedPlugin(pluginID);
        this.changedProperties.add(ExecutableInstancePropertyTracker.ExecutableInstanceProperty.PLUGIN_DATA);
    }

    @Override
    public void setUserAttributeValue(String attributeName, String attributeValue) {
        super.setUserAttributeValue(attributeName, attributeValue);
        this.changedProperties.add(ExecutableInstancePropertyTracker.ExecutableInstanceProperty.USER_ATTRIBUTES);
    }

    @Override
    public void removeUserAttributeValue(String attributeName) {
        super.removeUserAttributeValue(attributeName);
        this.changedProperties.add(ExecutableInstancePropertyTracker.ExecutableInstanceProperty.USER_ATTRIBUTES);
    }

    @Override
    public void setUserAttributes(Map<String, String> userAttributes) {
        super.setUserAttributes(userAttributes);
        this.changedProperties.add(ExecutableInstancePropertyTracker.ExecutableInstanceProperty.USER_ATTRIBUTES);
    }
}

