/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.execution.defaultimplementation;

import de.aristaflow.adept2.model.datamanagement.InvalidDataTypeException;
import de.aristaflow.adept2.model.datamanagement.NoSuchParameterException;
import de.aristaflow.adept2.model.datamanagement.UDTValue;
import de.aristaflow.adept2.model.execution.ParameterDataContext;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import java.io.Serializable;
import java.net.URI;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class DefaultParameterDataContext
implements ParameterDataContext {
    private static final long serialVersionUID = 3227745136930250845L;
    private HashMap<String, ProcessConstants.AdeptDataType> parameterTypes;
    private HashMap<String, Serializable> parameterValues;

    public DefaultParameterDataContext(Map<String, ProcessConstants.AdeptDataType> types, Map<String, Serializable> parameters) {
        this.parameterTypes = types == null ? new HashMap() : new HashMap<String, ProcessConstants.AdeptDataType>(types);
        this.parameterValues = parameters == null ? new HashMap() : new HashMap<String, Serializable>(parameters);
    }

    @Override
    public Map<String, ProcessConstants.AdeptDataType> getParameters() {
        return Collections.unmodifiableMap(this.parameterTypes);
    }

    @Override
    public boolean isNull(String parameterName) throws NoSuchParameterException {
        if (!this.parameterTypes.containsKey(parameterName)) {
            String msg = String.format("Input parameter '%s' does not exist.", parameterName);
            throw new NoSuchParameterException(msg, parameterName);
        }
        return this.parameterValues.get(parameterName) == null;
    }

    @Override
    public boolean retrieveBooleanParameterValue(String parameterName) throws InvalidDataTypeException, NoSuchParameterException {
        if (!this.parameterValues.containsKey(parameterName)) {
            String msg = String.format("Input parameter '%s' does not exist.", parameterName);
            throw new NoSuchParameterException(msg, parameterName);
        }
        ProcessConstants.AdeptDataType type = this.parameterTypes.get(parameterName);
        if (!type.equals((Object)ProcessConstants.AdeptDataType.BOOLEAN)) {
            throw new InvalidDataTypeException(parameterName, ProcessConstants.AdeptDataType.BOOLEAN, type);
        }
        return (Boolean)this.parameterValues.get(parameterName);
    }

    @Override
    public Date retrieveDateParameterValue(String parameterName) throws InvalidDataTypeException, NoSuchParameterException {
        if (!this.parameterValues.containsKey(parameterName)) {
            String msg = String.format("Input parameter '%s' does not exist.", parameterName);
            throw new NoSuchParameterException(msg, parameterName);
        }
        ProcessConstants.AdeptDataType type = this.parameterTypes.get(parameterName);
        if (!type.equals((Object)ProcessConstants.AdeptDataType.DATE)) {
            throw new InvalidDataTypeException(parameterName, ProcessConstants.AdeptDataType.DATE, type);
        }
        return (Date)this.parameterValues.get(parameterName);
    }

    @Override
    public double retrieveFloatParameterValue(String parameterName) throws InvalidDataTypeException, NoSuchParameterException {
        if (!this.parameterValues.containsKey(parameterName)) {
            String msg = String.format("Input parameter '%s' does not exist.", parameterName);
            throw new NoSuchParameterException(msg, parameterName);
        }
        ProcessConstants.AdeptDataType type = this.parameterTypes.get(parameterName);
        if (!type.equals((Object)ProcessConstants.AdeptDataType.FLOAT)) {
            throw new InvalidDataTypeException(parameterName, ProcessConstants.AdeptDataType.FLOAT, type);
        }
        return (Double)this.parameterValues.get(parameterName);
    }

    @Override
    public long retrieveIntegerParameterValue(String parameterName) throws InvalidDataTypeException, NoSuchParameterException {
        if (!this.parameterValues.containsKey(parameterName)) {
            String msg = String.format("Input parameter '%s' does not exist.", parameterName);
            throw new NoSuchParameterException(msg, parameterName);
        }
        ProcessConstants.AdeptDataType type = this.parameterTypes.get(parameterName);
        if (!type.equals((Object)ProcessConstants.AdeptDataType.INTEGER)) {
            throw new InvalidDataTypeException(parameterName, ProcessConstants.AdeptDataType.INTEGER, type);
        }
        return (Long)this.parameterValues.get(parameterName);
    }

    @Override
    public String retrieveStringParameterValue(String parameterName) throws InvalidDataTypeException, NoSuchParameterException {
        if (!this.parameterValues.containsKey(parameterName)) {
            String msg = String.format("Input parameter '%s' does not exist.", parameterName);
            throw new NoSuchParameterException(msg, parameterName);
        }
        ProcessConstants.AdeptDataType type = this.parameterTypes.get(parameterName);
        if (!type.equals((Object)ProcessConstants.AdeptDataType.STRING)) {
            throw new InvalidDataTypeException(parameterName, ProcessConstants.AdeptDataType.STRING, type);
        }
        return (String)((Object)this.parameterValues.get(parameterName));
    }

    @Override
    public UDTValue retrieveUDTParameterValue(String parameterName) throws InvalidDataTypeException, NoSuchParameterException {
        if (!this.parameterValues.containsKey(parameterName)) {
            String msg = String.format("Input parameter '%s' does not exist.", parameterName);
            throw new NoSuchParameterException(msg, parameterName);
        }
        ProcessConstants.AdeptDataType type = this.parameterTypes.get(parameterName);
        if (!type.equals((Object)ProcessConstants.AdeptDataType.USERDEFINED)) {
            throw new InvalidDataTypeException(parameterName, ProcessConstants.AdeptDataType.USERDEFINED, type);
        }
        return (UDTValue)this.parameterValues.get(parameterName);
    }

    @Override
    public URI retrieveURIParameterValue(String parameterName) throws InvalidDataTypeException, NoSuchParameterException {
        if (!this.parameterValues.containsKey(parameterName)) {
            String msg = String.format("Input parameter '%s' does not exist.", parameterName);
            throw new NoSuchParameterException(msg, parameterName);
        }
        ProcessConstants.AdeptDataType type = this.parameterTypes.get(parameterName);
        if (!type.equals((Object)ProcessConstants.AdeptDataType.URI)) {
            throw new InvalidDataTypeException(parameterName, ProcessConstants.AdeptDataType.URI, type);
        }
        return (URI)this.parameterValues.get(parameterName);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DefaultParameterDataContext)) {
            return false;
        }
        DefaultParameterDataContext o = (DefaultParameterDataContext)obj;
        if (!this.parameterValues.equals(o.parameterValues)) {
            return false;
        }
        return this.parameterTypes.equals(o.parameterTypes);
    }

    public int hashCode() {
        return this.parameterValues.hashCode() ^ this.parameterTypes.hashCode();
    }
}

