/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.filter.defaultimplementation;

import de.aristaflow.adept2.model.filter.Attribute;
import de.aristaflow.adept2.model.filter.AttributeFactory;
import de.aristaflow.adept2.model.filter.defaultimplementation.DefaultAttributeFactory;
import de.aristaflow.adept2.model.filter.defaultimplementation.NestedCollectionAttributeFactory;
import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public abstract class AbstractAttributeFactory
implements AttributeFactory {
    protected static final Set<Class<?>> primitiveTypes = new HashSet<Class>(Arrays.asList(Integer.TYPE, Byte.TYPE, Short.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, Boolean.TYPE, Integer.class, Byte.class, Short.class, Long.class, Float.class, Double.class, Boolean.class, String.class, UUID.class));
    protected static final Class<?>[] extendedPrimitiveTypes = new Class[]{Collection.class, Enum.class};
    protected Map<TypeVariable<?>, Type> actualTypeParameterMap = new HashMap();

    protected abstract Type getGenericReturnTypeForPrimitiveMethod(String var1);

    protected void addActualTypeParameters(Type t) {
        if (t instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)t;
            TypeVariable<Class<T>>[] genericDecls = ((Class)pt.getRawType()).getTypeParameters();
            Type[] actualParams = pt.getActualTypeArguments();
            int i = 0;
            while (i < genericDecls.length) {
                this.actualTypeParameterMap.put(genericDecls[i], actualParams[i]);
                ++i;
            }
        }
    }

    @Override
    public AttributeFactory getFactoryForCollectionAttribute(String primitiveMethod) {
        Class rawType;
        Type genericReturnType = this.getGenericReturnTypeForPrimitiveMethod(primitiveMethod);
        if (genericReturnType instanceof TypeVariable) {
            genericReturnType = this.resolveTypeVariable((TypeVariable)genericReturnType);
        }
        if (!(genericReturnType instanceof ParameterizedType)) {
            throw new IllegalArgumentException("Method must return a parameterized type.");
        }
        ParameterizedType parameterizedReturnType = (ParameterizedType)genericReturnType;
        Class returnType = (Class)parameterizedReturnType.getRawType();
        if (!Collection.class.isAssignableFrom(returnType)) {
            throw new IllegalArgumentException("Method must return a collection.");
        }
        Type intf = null;
        if (Collection.class.equals((Object)returnType)) {
            intf = parameterizedReturnType;
        } else {
            Type[] typeArray = returnType.getGenericInterfaces();
            int n = typeArray.length;
            int n2 = 0;
            while (n2 < n) {
                Type t = typeArray[n2];
                ParameterizedType pt = (ParameterizedType)t;
                if (Collection.class.equals((Object)pt.getRawType())) {
                    intf = t;
                    break;
                }
                ++n2;
            }
        }
        if (intf == null) {
            throw new IllegalArgumentException("Could not find Collection interface.");
        }
        Type innerType = parameterizedReturnType.getActualTypeArguments()[0];
        if (innerType instanceof TypeVariable) {
            innerType = this.resolveTypeVariable((TypeVariable)innerType);
        }
        if (innerType instanceof Class) {
            rawType = (Class)innerType;
        } else if (innerType instanceof ParameterizedType) {
            rawType = (Class)((ParameterizedType)innerType).getRawType();
        } else {
            throw new RuntimeException("Unknown inner type: " + innerType.getClass());
        }
        if (AbstractAttributeFactory.isTypePrimitive(rawType)) {
            return new NestedCollectionAttributeFactory(innerType, this.actualTypeParameterMap);
        }
        return new DefaultAttributeFactory(innerType, this.actualTypeParameterMap);
    }

    protected Type resolveTypeVariable(TypeVariable<?> typeVar) {
        Type result = typeVar;
        while ((result = this.actualTypeParameterMap.get(result)) instanceof TypeVariable) {
        }
        return result;
    }

    protected static boolean isTypePrimitive(Class<?> type) {
        if (primitiveTypes.contains(type)) {
            return true;
        }
        Class<?>[] classArray = extendedPrimitiveTypes;
        int n = extendedPrimitiveTypes.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> extType = classArray[n2];
            if (extType.isAssignableFrom(type)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public void goDown(String complexMethod) {
        this.goDownAndCast(complexMethod, null);
    }

    @Override
    public void goDown(String complexMethod, Object ... parameters) {
        this.goDownAndCast(complexMethod, null, parameters);
    }

    @Override
    public Attribute selectAttribute(String primitiveMethod) {
        return this.selectAttributeAndCast(primitiveMethod, null);
    }

    @Override
    public Attribute selectAttribute(String primitiveMethod, Serializable ... parameters) {
        return this.selectAttributeAndCast(primitiveMethod, null, parameters);
    }
}

