/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.filter.defaultimplementation;

import de.aristaflow.adept2.model.filter.Attribute;
import de.aristaflow.adept2.model.filter.defaultimplementation.DefaultAttributeFactory;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class DefaultAttribute
implements Attribute {
    private static final long serialVersionUID = 377581615293999L;
    protected String[] methods;
    private Class<?>[] classes;
    protected Class<?>[] desiredTypes;
    private Serializable[][] parameters;

    public DefaultAttribute(Method[] methods, Class<?>[] desiredTypes, Serializable[][] parameters) {
        if (methods != null) {
            this.methods = new String[methods.length];
            this.classes = new Class[methods.length];
            int i = 0;
            while (i < methods.length) {
                this.methods[i] = methods[i].getName();
                this.classes[i] = methods[i].getDeclaringClass();
                ++i;
            }
        } else {
            this.methods = new String[0];
            this.classes = new Class[0];
        }
        if (desiredTypes != null) {
            this.desiredTypes = (Class[])desiredTypes.clone();
        }
        if (parameters != null) {
            this.parameters = (Serializable[][])parameters.clone();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object getValue(Object owner) {
        Object previous = owner;
        try {
            int i = 0;
            while (true) {
                if (i >= this.methods.length) {
                    return previous;
                }
                Object[] nextParameters = this.parameters[i];
                if (nextParameters == null) {
                    Method m = this.classes[i].getMethod(this.methods[i], new Class[0]);
                    previous = m.invoke(previous, new Object[0]);
                } else {
                    Class<?>[] parameterTypes = DefaultAttributeFactory.getParameterTypes((Serializable[])nextParameters);
                    Method m = this.classes[i].getMethod(this.methods[i], parameterTypes);
                    previous = m.invoke(previous, nextParameters);
                }
                if (previous == null) {
                    return null;
                }
                if (this.desiredTypes[i] != null && !this.desiredTypes[i].isPrimitive() && !this.desiredTypes[i].isInstance(previous)) {
                    return INVALID_VALUE;
                }
                ++i;
            }
        }
        catch (InvocationTargetException e) {
            String msg = "An InvocationTargetException occurred while trying to get the attribute value for filtering.";
            throw new RuntimeException(msg, e);
        }
        catch (SecurityException e) {
            String msg = "A SecurityException occurred while trying to get the attribute value for filtering.";
            throw new RuntimeException(msg, e);
        }
        catch (NoSuchMethodException e) {
            String msg = "A NoSuchMethodException occurred while trying to get the attribute value for filtering.";
            throw new RuntimeException(msg, e);
        }
        catch (IllegalArgumentException e) {
            String msg = "An IllegalArgumentException occurred while trying to get the attribute value for filtering.";
            throw new RuntimeException(msg, e);
        }
        catch (IllegalAccessException e) {
            String msg = "An IllegalAccessException occurred while trying to get the attribute value for filtering.";
            throw new RuntimeException(msg, e);
        }
    }

    @Override
    public Class<?> getValueType() {
        return this.desiredTypes[this.desiredTypes.length - 1];
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        String[] stringArray = this.methods;
        int n = this.methods.length;
        int n2 = 0;
        while (n2 < n) {
            String m = stringArray[n2];
            s.append(m).append('.');
            ++n2;
        }
        return s.substring(0, s.length() - 1);
    }

    @Override
    public String[] getAttributePath() {
        return (String[])this.methods.clone();
    }
}

