/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.filter.defaultimplementation;

import de.aristaflow.adept2.model.common.filter.UseInFilter;
import de.aristaflow.adept2.model.filter.Attribute;
import de.aristaflow.adept2.model.filter.defaultimplementation.AbstractAttributeFactory;
import de.aristaflow.adept2.model.filter.defaultimplementation.DefaultAttribute;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DefaultAttributeFactory
extends AbstractAttributeFactory {
    protected static final Map<Class<?>, String[]> additionalAttributeClasses = new HashMap();
    protected Type rootType;
    protected Type currentType;
    protected Map<String, Method> complexAttributes;
    protected Map<String, Method> primitiveAttributes;
    protected List<Method> attributePath;
    protected List<Object[]> attributePathParameters;
    protected List<Class<?>> desiredTypePath;

    static {
        additionalAttributeClasses.put(Map.class, new String[]{"keySet", "values", "entrySet"});
        additionalAttributeClasses.put(Map.Entry.class, new String[]{"getKey", "getValue"});
    }

    public DefaultAttributeFactory(Type rootType) {
        this.rootType = rootType;
        this.currentType = rootType;
        this.complexAttributes = null;
        this.primitiveAttributes = null;
        this.attributePath = new ArrayList<Method>();
        this.attributePathParameters = new ArrayList<Object[]>();
        this.desiredTypePath = new ArrayList();
        this.addActualTypeParameters(rootType);
    }

    public DefaultAttributeFactory(Type rootType, Map<TypeVariable<?>, Type> typeParams) {
        this(rootType);
        this.actualTypeParameterMap.putAll(typeParams);
    }

    protected void readAttributes() {
        Class currentClass;
        this.primitiveAttributes = new HashMap<String, Method>();
        this.complexAttributes = new HashMap<String, Method>();
        if (this.currentType instanceof Class) {
            currentClass = (Class)this.currentType;
        } else if (this.currentType instanceof ParameterizedType) {
            currentClass = (Class)((ParameterizedType)this.currentType).getRawType();
        } else {
            throw new RuntimeException("Unsupported class data type " + this.currentType.getClass() + ". This should actually never happen (i.e. the annotation for the current attribute is wrong).");
        }
        Method[] methodArray = currentClass.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            if (m.isAnnotationPresent(UseInFilter.class)) {
                this.addAttribute(m);
            }
            ++n2;
        }
        for (Map.Entry<Class<?>, String[]> entry : additionalAttributeClasses.entrySet()) {
            if (!entry.getKey().isAssignableFrom(currentClass)) continue;
            String[] stringArray = entry.getValue();
            int n3 = stringArray.length;
            int n4 = 0;
            while (n4 < n3) {
                String attribute = stringArray[n4];
                try {
                    this.addAttribute(currentClass.getMethod(attribute, new Class[0]));
                }
                catch (SecurityException e) {
                    throw new RuntimeException("Not enough privileges to use reflection. Should never happen.", e);
                }
                catch (NoSuchMethodException e) {
                    throw new RuntimeException("The class does not contain a method it should according to the additionalAttributeClasses. Probably the entry in additionalAttributeClasses is wrong.", e);
                }
                ++n4;
            }
        }
    }

    protected void addAttribute(Method attribute) {
        Class<?> actualReturnType = this.resolveActualReturnType(attribute);
        if (DefaultAttributeFactory.isTypePrimitive(actualReturnType)) {
            this.primitiveAttributes.put(attribute.getName(), attribute);
        } else {
            this.complexAttributes.put(attribute.getName(), attribute);
        }
    }

    protected Class<?> resolveActualReturnType(Method attribute) {
        Type genericReturnType = attribute.getGenericReturnType();
        if (genericReturnType instanceof Class || genericReturnType instanceof ParameterizedType) {
            return attribute.getReturnType();
        }
        if (genericReturnType instanceof TypeVariable) {
            Type resolvedType = this.resolveTypeVariable((TypeVariable)genericReturnType);
            if (resolvedType instanceof Class) {
                return (Class)resolvedType;
            }
            if (resolvedType instanceof ParameterizedType) {
                return (Class)((ParameterizedType)resolvedType).getRawType();
            }
            return attribute.getReturnType();
        }
        throw new RuntimeException("Unsupported return type: " + genericReturnType.getClass());
    }

    protected Map<String, Method> getAvailableComplexAttributesMap() {
        if (this.complexAttributes == null) {
            this.readAttributes();
        }
        return this.complexAttributes;
    }

    protected Map<String, Method> getAvailablePrimitiveAttributesMap() {
        if (this.primitiveAttributes == null) {
            this.readAttributes();
        }
        return this.primitiveAttributes;
    }

    @Override
    public void goDownAndCast(String complexMethod, Class<?> desiredType) {
        this.goDownAndCast(complexMethod, desiredType, null);
    }

    @Override
    public void goDownAndCast(String complexMethod, Class<?> desiredType, Object ... parameters) {
        Method m = this.getAvailableComplexAttributesMap().get(complexMethod);
        if (m == null) {
            throw new IllegalArgumentException("Invalid method: " + complexMethod);
        }
        if (desiredType == null) {
            this.currentType = m.getGenericReturnType();
        } else {
            Class<?> returnType = this.resolveActualReturnType(m);
            if (!returnType.isAssignableFrom(desiredType)) {
                throw new IllegalArgumentException("The desired type is not a sub type of the attribute's return type (" + returnType.getName() + ").");
            }
            this.currentType = desiredType;
        }
        this.addActualTypeParameters(this.currentType);
        this.attributePath.add(m);
        this.attributePathParameters.add(parameters);
        this.desiredTypePath.add(desiredType);
        this.complexAttributes = null;
        this.primitiveAttributes = null;
    }

    @Override
    public void goUp() {
        Class<?> desiredType;
        this.currentType = this.attributePath.size() > 1 ? ((desiredType = this.desiredTypePath.get(this.desiredTypePath.size() - 2)) != null ? desiredType : this.attributePath.get(this.attributePath.size() - 2).getGenericReturnType()) : this.rootType;
        this.attributePath.remove(this.attributePath.size() - 1);
        this.attributePathParameters.remove(this.attributePathParameters.size() - 1);
        this.desiredTypePath.remove(this.desiredTypePath.size() - 1);
        this.complexAttributes = null;
        this.primitiveAttributes = null;
    }

    @Override
    public Attribute selectAttributeAndCast(String primitiveMethod, Class<?> desiredType) {
        return this.selectAttributeAndCast(primitiveMethod, desiredType, null);
    }

    @Override
    public Attribute selectAttributeAndCast(String primitiveMethod, Class<?> desiredType, Serializable ... parameters) {
        Class currentClass;
        if (this.currentType instanceof Class) {
            currentClass = (Class)this.currentType;
        } else if (this.currentType instanceof ParameterizedType) {
            currentClass = (Class)((ParameterizedType)this.currentType).getRawType();
        } else {
            throw new RuntimeException("Unsupported class data type " + this.currentType.getClass() + ". This should actually never happen (i.e. the annotation for the current attribute is wrong).");
        }
        Method m = null;
        try {
            if (parameters != null) {
                Class<?>[] parameterTypes = DefaultAttributeFactory.getParameterTypes(parameters);
                m = currentClass.getMethod(primitiveMethod, parameterTypes);
            } else {
                m = currentClass.getMethod(primitiveMethod, new Class[0]);
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        if (m == null) {
            throw new IllegalArgumentException("Invalid method!");
        }
        Method[] methods = new Method[this.attributePath.size() + 1];
        this.attributePath.toArray(methods);
        methods[methods.length - 1] = m;
        Serializable[][] methodParameters = new Serializable[this.attributePathParameters.size() + 1][];
        this.attributePathParameters.toArray((T[])methodParameters);
        methodParameters[methodParameters.length - 1] = parameters;
        Class[] desiredTypes = new Class[this.desiredTypePath.size() + 1];
        this.desiredTypePath.toArray(desiredTypes);
        Class<?> returnType = this.resolveActualReturnType(m);
        if (desiredType == null) {
            desiredTypes[desiredTypes.length - 1] = returnType;
        } else {
            if (!returnType.isAssignableFrom(desiredType)) {
                throw new IllegalArgumentException("The desired type is not a sub type of the attribute's return type (" + returnType.getName() + ").");
            }
            desiredTypes[desiredTypes.length - 1] = desiredType;
        }
        return new DefaultAttribute(methods, desiredTypes, methodParameters);
    }

    public static Class<?>[] getParameterTypes(Serializable ... parameters) {
        Class[] parameterTypes = new Class[parameters.length];
        int i = 0;
        while (i < parameters.length) {
            Class<?> clazz = parameters[i].getClass();
            parameterTypes[i] = clazz == Integer.class ? Integer.TYPE : (clazz == Long.class ? Long.TYPE : (clazz == Short.class ? Short.TYPE : (clazz == Float.class ? Float.TYPE : (clazz == Double.class ? Double.TYPE : (clazz == Byte.class ? Byte.TYPE : (clazz == Boolean.class ? Boolean.TYPE : clazz))))));
            ++i;
        }
        return parameterTypes;
    }

    @Override
    public void startNewAttribute() {
        this.currentType = this.rootType;
        this.complexAttributes = null;
        this.primitiveAttributes = null;
        this.attributePath.clear();
        this.attributePathParameters.clear();
        this.desiredTypePath.clear();
    }

    @Override
    protected Type getGenericReturnTypeForPrimitiveMethod(String primitiveMethod) {
        Method m = this.getAvailablePrimitiveAttributesMap().get(primitiveMethod);
        if (m == null) {
            throw new IllegalArgumentException("Unknown or invalid method name.");
        }
        return m.getGenericReturnType();
    }

    @Override
    public Set<String> getAvailableComplexAttributes() {
        return this.getAvailableComplexAttributesMap().keySet();
    }

    @Override
    public Set<String> getAvailablePrimitiveAttributes() {
        return this.getAvailablePrimitiveAttributesMap().keySet();
    }

    @Override
    public String getCurrentPathAsString() {
        if (this.attributePath.size() == 0) {
            return "<empty>";
        }
        StringBuilder s = new StringBuilder();
        int i = 0;
        while (i < this.attributePath.size()) {
            Method m = this.attributePath.get(i);
            Object[] parameters = this.attributePathParameters.get(i);
            s.append(m.getName()).append('(');
            if (parameters != null) {
                Object[] objectArray = parameters;
                int n = parameters.length;
                int n2 = 0;
                while (n2 < n) {
                    Object parameter = objectArray[n2];
                    s.append(parameter.toString()).append(", ");
                    ++n2;
                }
                s.delete(s.length() - 2, s.length());
            }
            s.append(')').append('.');
            ++i;
        }
        return s.substring(0, s.length() - 1);
    }
}

