/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.filter.defaultimplementation;

import de.aristaflow.adept2.model.filter.Attribute;
import de.aristaflow.adept2.model.filter.ComparisonFilter;
import de.aristaflow.adept2.model.filter.ComparisonOperator;
import java.io.Serializable;
import java.util.regex.Pattern;

public class DefaultComparisonFilter
implements ComparisonFilter,
Serializable {
    private static final long serialVersionUID = -1360623115265988747L;
    protected ComparisonOperator operator;
    protected Attribute leftHandSide;
    protected Comparable<?> rightHandSide;
    protected Pattern compiledRegEx;

    public DefaultComparisonFilter(ComparisonOperator operator, Attribute leftHandSide, Comparable<?> rightHandSide) {
        this.operator = operator;
        if (!Comparable.class.isAssignableFrom(leftHandSide.getValueType()) && !leftHandSide.getValueType().isPrimitive()) {
            throw new IllegalArgumentException("Attribute must implement Comparable interface!");
        }
        this.leftHandSide = leftHandSide;
        this.rightHandSide = rightHandSide;
    }

    @Override
    public ComparisonOperator getOperator() {
        return this.operator;
    }

    @Override
    public Attribute getLeftHandSide() {
        return this.leftHandSide;
    }

    @Override
    public Comparable<?> getRightHandSide() {
        return this.rightHandSide;
    }

    @Override
    public boolean matches(Object obj) {
        boolean rv;
        Object value = this.leftHandSide.getValue(obj);
        if (value == Attribute.INVALID_VALUE || value == null) {
            rv = false;
        } else {
            block0 : switch (this.operator) {
                case LIKE: {
                    if (this.compiledRegEx == null) {
                        this.compiledRegEx = Pattern.compile(DefaultComparisonFilter.replaceWildcards(this.rightHandSide.toString()), 66);
                    }
                    rv = this.compiledRegEx.matcher(value.toString()).matches();
                    break;
                }
                case MATCHES: {
                    if (this.compiledRegEx == null) {
                        this.compiledRegEx = Pattern.compile(this.rightHandSide.toString());
                    }
                    rv = this.compiledRegEx.matcher(value.toString()).matches();
                    break;
                }
                default: {
                    int comp = ((Comparable)value).compareTo(this.rightHandSide);
                    switch (this.operator) {
                        case EQUALS: {
                            rv = comp == 0;
                            break block0;
                        }
                        case NOTEQUALS: {
                            rv = comp != 0;
                            break block0;
                        }
                        case GREATER: {
                            rv = comp > 0;
                            break block0;
                        }
                        case GREATEREQUAL: {
                            rv = comp >= 0;
                            break block0;
                        }
                        case LESS: {
                            rv = comp < 0;
                            break block0;
                        }
                        case LESSEQUAL: {
                            rv = comp <= 0;
                            break block0;
                        }
                    }
                    throw new RuntimeException("Unknown operator!");
                }
            }
        }
        return rv;
    }

    public String toString() {
        return String.valueOf(this.leftHandSide.toString()) + " " + (Object)((Object)this.operator) + " " + this.rightHandSide;
    }

    protected static String replaceWildcards(String wildcard) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < wildcard.length()) {
            char c = wildcard.charAt(i);
            switch (c) {
                case '*': {
                    buffer.append(".*");
                    break;
                }
                case '?': {
                    buffer.append('.');
                    break;
                }
                case '$': 
                case '(': 
                case ')': 
                case '+': 
                case '.': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '{': 
                case '|': 
                case '}': {
                    buffer.append('\\').append(c);
                    break;
                }
                default: {
                    buffer.append(c);
                }
            }
            ++i;
        }
        return buffer.toString();
    }
}

