/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.filter.defaultimplementation;

import de.aristaflow.adept2.model.filter.Attribute;
import de.aristaflow.adept2.model.filter.ComparisonOperator;
import de.aristaflow.adept2.model.filter.ConstPositionFilter;
import de.aristaflow.adept2.model.filter.Filter;
import java.io.Serializable;
import java.util.List;

public class DefaultConstPositionFilter
implements ConstPositionFilter,
Serializable {
    private static final long serialVersionUID = -2696326066598304649L;
    protected Attribute attribute;
    protected Filter filterOnAttribute;
    protected ComparisonOperator operator;
    protected int position;

    public DefaultConstPositionFilter(Attribute attribute, Filter filterOnAttribute, ComparisonOperator operator, int position) {
        if (!List.class.isAssignableFrom(attribute.getValueType())) {
            throw new IllegalArgumentException("Attribute must implement Collection!");
        }
        this.attribute = attribute;
        this.filterOnAttribute = filterOnAttribute;
        this.operator = operator;
        this.position = position;
    }

    @Override
    public ComparisonOperator getOperator() {
        return this.operator;
    }

    @Override
    public int getPosition() {
        return this.position;
    }

    @Override
    public Attribute getAttribute() {
        return this.attribute;
    }

    @Override
    public Filter getFilterOnAttribute() {
        return this.filterOnAttribute;
    }

    @Override
    public boolean matches(Object obj) {
        Object value = this.attribute.getValue(obj);
        if (value == Attribute.INVALID_VALUE || value == null) {
            return false;
        }
        List attrList = (List)value;
        boolean found = false;
        int pos = 0;
        while (pos < attrList.size()) {
            if (this.filterOnAttribute.matches(attrList.get(pos))) {
                found = true;
                break;
            }
            ++pos;
        }
        if (!found) {
            return false;
        }
        switch (this.operator) {
            case EQUALS: {
                return pos == this.position;
            }
            case NOTEQUALS: {
                return pos != this.position;
            }
            case GREATER: {
                return pos > this.position;
            }
            case GREATEREQUAL: {
                return pos >= this.position;
            }
            case LESS: {
                return pos < this.position;
            }
            case LESSEQUAL: {
                return pos <= this.position;
            }
        }
        throw new RuntimeException("Unknown operator.");
    }

    public String toString() {
        return String.valueOf(this.attribute.toString()) + " POSITION (" + this.filterOnAttribute + ") " + (Object)((Object)this.operator) + " " + this.position;
    }
}

