/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.filter.defaultimplementation;

import de.aristaflow.adept2.model.filter.Attribute;
import de.aristaflow.adept2.model.filter.ContainsAllFilter;
import de.aristaflow.adept2.model.filter.Filter;
import de.aristaflow.adept2.model.filter.defaultimplementation.DefaultContainsFilter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;

public class DefaultContainsAllFilter
extends DefaultContainsFilter
implements ContainsAllFilter {
    private static final long serialVersionUID = -6652765984389988570L;
    protected Collection<Serializable> allObjects;
    protected ArrayList<Serializable> containedObjects;

    public DefaultContainsAllFilter(Attribute attribute, Filter filterOnAttribute, Collection<Serializable> allObjs) {
        super(attribute, filterOnAttribute);
        this.allObjects = allObjs;
    }

    protected Collection<?> getContainedObjects() {
        if (this.containedObjects == null) {
            this.containedObjects = new ArrayList();
            for (Serializable o : this.allObjects) {
                if (!this.filterOnAttribute.matches(o)) continue;
                this.containedObjects.add(o);
            }
        }
        return this.containedObjects;
    }

    @Override
    public Collection<?> getAllObjects() {
        return this.allObjects;
    }

    @Override
    public boolean matches(Object obj) {
        Object value = this.attribute.getValue(obj);
        if (value == Attribute.INVALID_VALUE || value == null) {
            return false;
        }
        Collection attrColl = (Collection)value;
        return attrColl.containsAll(this.getContainedObjects());
    }

    public String toString() {
        return String.valueOf(this.attribute.toString()) + " CONTAINS ALL (" + this.filterOnAttribute + ")";
    }
}

