/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.filter.defaultimplementation;

import de.aristaflow.adept2.model.filter.Attribute;
import de.aristaflow.adept2.model.filter.ComparisonOperator;
import de.aristaflow.adept2.model.filter.Filter;
import de.aristaflow.adept2.model.filter.TwoFiltersPositionFilter;
import java.io.Serializable;
import java.util.List;

public class DefaultTwoFiltersPositionFilter
implements TwoFiltersPositionFilter,
Serializable {
    private static final long serialVersionUID = 2139145698576988570L;
    protected Attribute attribute;
    protected Filter filterOnAttribute;
    protected ComparisonOperator operator;
    protected Filter secondFilterOnAttribute;

    public DefaultTwoFiltersPositionFilter(Attribute attribute, Filter filterOnAttribute, ComparisonOperator operator, Filter secondFilterOnAttribute) {
        if (!List.class.isAssignableFrom(attribute.getValueType())) {
            throw new IllegalArgumentException("Attribute must implement Collection!");
        }
        this.attribute = attribute;
        this.filterOnAttribute = filterOnAttribute;
        this.operator = operator;
        this.secondFilterOnAttribute = secondFilterOnAttribute;
    }

    @Override
    public ComparisonOperator getOperator() {
        return this.operator;
    }

    @Override
    public Attribute getAttribute() {
        return this.attribute;
    }

    @Override
    public Filter getFilterOnAttribute() {
        return this.filterOnAttribute;
    }

    @Override
    public boolean matches(Object obj) {
        Object value = this.attribute.getValue(obj);
        if (value == Attribute.INVALID_VALUE || value == null) {
            return false;
        }
        List attrList = (List)value;
        int pos1 = 0;
        int pos2 = 0;
        boolean found1 = false;
        boolean found2 = false;
        int i = 0;
        while (!(i >= attrList.size() || found1 && found2)) {
            Object item = attrList.get(i);
            if (!found1 && this.filterOnAttribute.matches(item)) {
                pos1 = i;
                found1 = true;
            }
            if (!found2 && this.secondFilterOnAttribute.matches(item)) {
                pos2 = i;
                found2 = true;
            }
            ++i;
        }
        if (!found1 || !found2) {
            return false;
        }
        switch (this.operator) {
            case EQUALS: {
                return pos1 == pos2;
            }
            case NOTEQUALS: {
                return pos1 != pos2;
            }
            case GREATER: {
                return pos1 > pos2;
            }
            case GREATEREQUAL: {
                return pos1 >= pos2;
            }
            case LESS: {
                return pos1 < pos2;
            }
            case LESSEQUAL: {
                return pos1 <= pos2;
            }
        }
        throw new RuntimeException("Unknown operator.");
    }

    public String toString() {
        return String.valueOf(this.attribute.toString()) + " POSITION (" + this.filterOnAttribute + ") " + (Object)((Object)this.operator) + " (" + this.secondFilterOnAttribute + ")";
    }

    @Override
    public Filter getSecondFilterOnAttribute() {
        return this.secondFilterOnAttribute;
    }
}

