/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.globals;

import java.util.HashMap;
import java.util.Map;

public class ActivityConstants {
    public static final char NAME_SEPARATOR = '$';
    public static final char KEY_SEPARATOR = '#';
    public static final char[] DISALLOWED_NAME_CHARACTERS = new char[]{'$', '#', '=', ':', '!'};
    public static final String USER_ATTRIBUTE_FROM_DEV_BRANCH = "fromDevelopmentBranch";
    public static final String USER_ATTRIBUTE_FROM_PARAMETER = "fromParameter";
    public static final String USER_ATTRIBUTE_FROM_PARAMETER_TEMPLATE = "fromParameterTemplate";
    public static final String USER_ATTRIBUTES_DECISION = "decision";
    public static final String ACTIVITY_TYPE_CONFIGURATION_POSITION = "position";
    public static final String URI_SCHEMA_ADEPT_ACTIVITY_REPOSITORY = "adeptAR";
    public static final String ACCESS_TYPE_ASSERTION_MESSAGE = "An unknown access type was found!";

    public static enum AccessType {
        READ(1),
        WRITE(2),
        SYSTEM_READ(3),
        SYSTEM_WRITE(4);

        private final int code;

        private AccessType(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }

        public static AccessType[] activityRelatedValues() {
            return new AccessType[]{READ, WRITE};
        }

        public static AccessType[] systemRelatedValues() {
            return new AccessType[]{SYSTEM_READ, SYSTEM_WRITE};
        }

        public static AccessType[] dataFlowReadAccess() {
            return new AccessType[]{READ, SYSTEM_READ};
        }

        public static AccessType[] dataFlowWriteAccess() {
            return new AccessType[]{WRITE, SYSTEM_WRITE};
        }

        public static boolean isActivityRelatedValue(AccessType accessType) {
            AccessType[] accessTypeArray = AccessType.activityRelatedValues();
            int n = accessTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                AccessType activityRelatedType = accessTypeArray[n2];
                if (accessType == activityRelatedType) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        public static boolean isSystemRelatedValue(AccessType accessType) {
            AccessType[] accessTypeArray = AccessType.systemRelatedValues();
            int n = accessTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                AccessType activityRelatedType = accessTypeArray[n2];
                if (accessType == activityRelatedType) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        public static AccessType valueOf(String string) {
            return Enum.valueOf(AccessType.class, string);
        }
    }

    public static enum ActivityModelEntityType {
        ECD(1),
        OPERATION(2),
        ATD(3);

        private final byte code;

        private ActivityModelEntityType(byte code) {
            this.code = code;
        }

        public byte getCode() {
            return this.code;
        }

        public static ActivityModelEntityType valueOf(String string) {
            return Enum.valueOf(ActivityModelEntityType.class, string);
        }
    }

    public static class ActivityType {
        public static final String EXE = "de.aristaflow.exe.EXE";
        public static final String WS = "de.aristaflow.webservice.AxisWS";
        public static final String JAVA = "de.aristaflow.java.StaticJavaCall";
        public static final String JAVA_UDT_BYTE_RETURN = "JAVA_UDT_BYTE_RETURN";
        public static final String FORM = "de.aristaflow.form.GeneratedForm";
        public static final String NULL = "NULL";
        public static final String LWP = "LWP";
        public static final String TLPI = "TLPI";
        public static final String XOR_PREDICATE = "de.aristaflow.rules.XOR";
        public static final String ASYNC_EXE_FORM = "de.aristaflow.exe.AsyncExeForm";
        public static final String SQL = "de.aristaflow.db.SQL";
        public static final String BSH = "de.aristaflow.tools.BSH";
        public static final String XPATH = "de.aristaflow.xml.XPath";
        public static final String DOCUWARE = "de.aristaflow.extensions.Docuware";
    }

    public static enum LocallyOverrideableActivityAttribute {
        IMPLEMENTATION_CLASS(1),
        IS_SINGLETON(3),
        SYSTEM_COMPONENT(4),
        GUI_CONTEXT_ID(5),
        EXECUTION_CONTROL_PROPERTIES(6),
        ICON_ID(7),
        DESCRIPTION(8),
        SUPPORTS_VIEW_ONLY(9),
        SUPPORTS_TEST_EXECUTION(10);

        private final byte code;

        private LocallyOverrideableActivityAttribute(byte code) {
            this.code = code;
        }

        public byte getCode() {
            return this.code;
        }

        public static Map<LocallyOverrideableActivityAttribute, ActivityModelEntityType> getDefaultOrigins() {
            HashMap<LocallyOverrideableActivityAttribute, ActivityModelEntityType> ret = new HashMap<LocallyOverrideableActivityAttribute, ActivityModelEntityType>();
            LocallyOverrideableActivityAttribute[] locallyOverrideableActivityAttributeArray = LocallyOverrideableActivityAttribute.values();
            int n = locallyOverrideableActivityAttributeArray.length;
            int n2 = 0;
            while (n2 < n) {
                LocallyOverrideableActivityAttribute loaa = locallyOverrideableActivityAttributeArray[n2];
                ret.put(loaa, ActivityModelEntityType.ECD);
                ++n2;
            }
            ret.put(DESCRIPTION, ActivityModelEntityType.OPERATION);
            ret.put(SUPPORTS_VIEW_ONLY, ActivityModelEntityType.OPERATION);
            ret.put(SUPPORTS_TEST_EXECUTION, ActivityModelEntityType.OPERATION);
            return ret;
        }

        public static LocallyOverrideableActivityAttribute valueOf(String string) {
            return Enum.valueOf(LocallyOverrideableActivityAttribute.class, string);
        }
    }

    public static class OpenOfficeMetaData {
        @Deprecated
        public static final String PREFIX = "OpenOffice.";
        public static final String NEW_DOCUMENT_TYPE = "NewDocumentType";
        public static final String NEW_DOCUMENT_TEMPLATE_URI = "NewDocumentTemplateURI";
    }

    public static enum TestMode {
        NO_TEST(1),
        TEST_FLAG(2),
        TEST_CONFIGURATION(3);

        private final int code;

        private TestMode(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }

        public static TestMode valueOf(String string) {
            return Enum.valueOf(TestMode.class, string);
        }
    }

    public static class WebServiceActivityTypeConfiguration {
        public static final String ACTIVITY_TYPE_CONFIGURATION_SERVICE_NAME = "ServiceName";
        public static final String ACTIVITY_TYPE_CONFIGURATION_STUB_PACKAGE_NAME = "StubPackageName";
        public static final String ACTIVITY_TYPE_CONFIGURATION_PORT_NAME = "PortName";
        public static final String ACTIVITY_TYPE_CONFIGURATION_PORT_TYPE_NAME = "PortTypeName";
        public static final String ACTIVITY_TYPE_CONFIGURATION_WEB_SERVICE_URI = "WebServiceURI";
    }
}

