/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.globals;

import de.aristaflow.adept2.model.globals.SystemIdentifier;
import java.util.UUID;

public class ProcessConstants {
    public static final UUID UNIVERSAL_IDENTIFIER_ID = new UUID(-1L, Long.MIN_VALUE);
    public static final UUID IDENTIFIER_NOT_SET = new UUID(-2L, Long.MIN_VALUE);
    public static final String DEFAULT_PROCESS_STARTER_RULE = "Agent(username='supervisor')";
    public static final UUID IDENTIFIER_ID_DECISION = UUID.fromString("f31b8592-f943-4911-847a-bdc65a8bdacd");

    static {
        SystemIdentifier.register(UNIVERSAL_IDENTIFIER_ID, "de.aristaflow.processmodel.Universal", "");
        SystemIdentifier.register(IDENTIFIER_ID_DECISION, "de.aristaflow.processmodel.Decision", "");
    }

    public static enum AdeptDataType {
        INTEGER(1),
        FLOAT(2),
        STRING(3),
        BOOLEAN(4),
        DATE(5),
        URI(6),
        USERDEFINED(7);

        private final int code;

        private AdeptDataType(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }

        public static AdeptDataType valueOf(String string) {
            return Enum.valueOf(AdeptDataType.class, string);
        }
    }

    public static enum BlockType {
        AND_BLOCK(1),
        OR_BLOCK(2),
        LOOP_BLOCK(3);

        private final int code;

        private BlockType(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }

        public static BlockType valueOf(String string) {
            return Enum.valueOf(BlockType.class, string);
        }
    }

    public static enum ConstraintEdgeProperty {
        USER_ATTRIBUTE(1);

        private final int code;

        private ConstraintEdgeProperty(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }

        public static ConstraintEdgeProperty valueOf(String string) {
            return Enum.valueOf(ConstraintEdgeProperty.class, string);
        }
    }

    public static enum DataEdgeProperty {
        TYPE(1),
        OPTIONAL(2),
        USER_ATTRIBUTE(3);

        private final int code;

        private DataEdgeProperty(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }

        public static DataEdgeProperty valueOf(String string) {
            return Enum.valueOf(DataEdgeProperty.class, string);
        }
    }

    public static enum DataElementProperty {
        ID(1),
        NAME(2),
        DESCRIPTION(3),
        TYPE(4),
        USER_DEFINED_TYPE(5),
        IDENTIFIER(6),
        PUBLIC(7),
        VIRTUAL(8),
        USER_ATTRIBUTE(9);

        private final int code;

        private DataElementProperty(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }

        public static DataElementProperty valueOf(String string) {
            return Enum.valueOf(DataElementProperty.class, string);
        }
    }

    public static enum DataMappingType {
        DATAELEMENT(1),
        NEW_DATAELEMENT(2),
        DISABLE(3),
        CONNECT_LATER(4);

        private final int code;

        private DataMappingType(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }

        public static DataMappingType valueOf(String string) {
            return Enum.valueOf(DataMappingType.class, string);
        }
    }

    public static enum DeltaScope {
        NEW(1),
        DELETED(2),
        CHANGED(3),
        MOVED(4);

        private final int code;

        private DeltaScope(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }

        public static DeltaScope valueOf(String string) {
            return Enum.valueOf(DeltaScope.class, string);
        }
    }

    public static enum EdgeProperty {
        TYPE(1),
        EDGE_CODE(2),
        USER_ATTRIBUTE(3);

        private final int code;

        private EdgeProperty(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }

        public static EdgeProperty valueOf(String string) {
            return Enum.valueOf(EdgeProperty.class, string);
        }
    }

    public static enum EdgeState {
        ES_TRUE(1),
        ES_FALSE(2),
        ES_NS(3);

        private final int code;

        private EdgeState(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }

        public static EdgeState valueOf(String string) {
            return Enum.valueOf(EdgeState.class, string);
        }
    }

    public static enum EdgeType {
        ET_CONTROL(1),
        ET_LOOP(2),
        ET_SYNC(3),
        ET_CONSTRAINT(4);

        private final int code;

        private EdgeType(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }

        public static EdgeType valueOf(String string) {
            return Enum.valueOf(EdgeType.class, string);
        }
    }

    public static enum ExecutableBusinessProcessProperty {
        INPUT_PARAMETER(1),
        OUTPUT_PARAMETER(2),
        EXECUTION_CONTROL_PROPERTIES(4),
        USER_ATTRIBUTE(5),
        ACTIVITY_TEMPLATE_ID(6),
        EXECUTABLE_COMPONENT_NAME(3),
        OPERATION_NAME(7),
        CONFIGURATION_NAME(8),
        RESETABLE(9),
        SUSPENSIBLE(10),
        CLOSABLE(11),
        CONFIGURATION(12),
        TEST_CONFIGURATION(14),
        GUI_CONTEXT_ID(17),
        TEMPLATE_ID(18),
        TEMPLATE(19);

        private final int code;

        private ExecutableBusinessProcessProperty(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }

        public static ExecutableBusinessProcessProperty valueOf(String string) {
            return Enum.valueOf(ExecutableBusinessProcessProperty.class, string);
        }
    }

    public static enum ExecutionMode {
        SUBSTITUTED_TEST(1),
        COMPONENT_TEST(2),
        PRODUCTION(3),
        VIEW_ONLY(4);

        private final int code;

        private ExecutionMode(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }

        public static ExecutionMode valueOf(String string) {
            return Enum.valueOf(ExecutionMode.class, string);
        }
    }

    public static enum InstanceExecutionStatus {
        IE_RUNNING("Running", 1),
        IE_SUSPENDED("Suspended (hard)", 2),
        IE_SOFTLY_SUSPENDED("Suspended (soft)", 3),
        IE_ABORTED("Aborted (hard)", 4),
        IE_SOFTLY_ABORTED("Aborted (soft)", 5),
        IE_FINISHED("Finished", 6);

        public final String readableName;
        private final int code;

        private InstanceExecutionStatus(String readableName, int code) {
            this.readableName = readableName;
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }

        public static InstanceExecutionStatus valueOf(String string) {
            return Enum.valueOf(InstanceExecutionStatus.class, string);
        }
    }

    public static enum InstanceMigrationStatus {
        IM_MIGRATABLE(1),
        IM_MIGRATING(2),
        IM_NOT_MIGRATABLE(3);

        private final int code;

        private InstanceMigrationStatus(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }

        public static InstanceMigrationStatus valueOf(String string) {
            return Enum.valueOf(InstanceMigrationStatus.class, string);
        }
    }

    public static enum InstanceProperty {
        NAME(1),
        SUPERVISOR_AGENT(2),
        INPUT_PARAMETER(3),
        OUTPUT_PARAMETER(4);

        private final int code;

        private InstanceProperty(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }

        public static InstanceProperty valueOf(String string) {
            return Enum.valueOf(InstanceProperty.class, string);
        }
    }

    public static enum NodeProperty {
        ID(1),
        NAME(2),
        EXECUTABLE_BUSINESS_PROCESS(2),
        AUTO_START(3),
        CONNECTOR_PARAMETER_MAPPING(4),
        SYSTEM_READ_PARAMS(5),
        SYSTEM_WRITE_PARAMS(6),
        USER_ATTRIBUTE(7),
        DESCRIPTION(8),
        STAFF_ASSIGNMENT_RULE(9);

        private final int code;

        private NodeProperty(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }

        public static NodeProperty valueOf(String string) {
            return Enum.valueOf(NodeProperty.class, string);
        }
    }

    public static enum NodeState {
        NS_NOT_ACTIVATED(1),
        NS_ACTIVATED(2),
        NS_SELECTED(3),
        NS_RUNNING(4),
        NS_SUSPENDED(5),
        NS_ENQUIRED(6),
        NS_COMPLETED(7),
        NS_FAILED(8),
        NS_SKIPPED(9);

        private final int code;

        private NodeState(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }

        public static NodeState valueOf(String string) {
            return Enum.valueOf(NodeState.class, string);
        }
    }

    public static enum NodeType {
        NT_NORMAL(1),
        NT_STARTFLOW(2),
        NT_ENDFLOW(3),
        NT_AND_SPLIT(4),
        NT_AND_JOIN(5),
        NT_XOR_SPLIT(6),
        NT_XOR_JOIN(7),
        NT_STARTLOOP(8),
        NT_ENDLOOP(9);

        private final int code;

        private NodeType(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }

        public static NodeType valueOf(String string) {
            return Enum.valueOf(NodeType.class, string);
        }
    }

    public static class ProcessElementIdentifier {
        public static final String PROCESS_ELEMENT_TEMPLATE = "template";
        public static final String PROCESS_ELEMENT_INSTANCE = "instance";
        public static final String PROCESS_ELEMENT_NODE = "node";
        public static final String PROCESS_ELEMENT_DATAELEMENT = "dataelement";
        public static final String PROCESS_ELEMENT_EBP = "ebp";
        public static final String PROCESS_ELEMENT_DATAEDGE = "dataedge";
        public static final String PROCESS_ELEMENT_SYNCEDGE = "syncedge";
        public static final String PROCESS_ELEMENT_CONTROLEDGE = "controledge";
        public static final String PROCESS_ELEMENT_CONSTRAINTEDGE = "constraintedge";
        public static final String PROCESS_ELEMENT_BRANCH = "branch";
        public static final String PROCESS_ELEMENT_BLOCK = "block";
        public static final String PROCESS_ELEMENT_PARAMETER = "parameter";
    }

    public static class ProcessElementIdentifierPath {
        private static final String[] IDENTIFIER_PATH_REL_TO_BASE_TEMPLATE = new String[0];
        private static final String[] IDENTIFIER_PATH_REL_TO_BASE_INSTANCE = new String[0];
        private static final String[] IDENTIFIER_PATH_REL_TO_BASE_NODE = new String[]{"node"};
        private static final String[] IDENTIFIER_PATH_REL_TO_BASE_EBP = new String[]{"node", "ebp"};
        private static final String[] IDENTIFIER_PATH_REL_TO_BASE_DATAELEMENT = new String[]{"dataelement"};
        private static final String[] IDENTIFIER_PATH_REL_TO_BASE_DATAEDGE = new String[]{"dataedge"};
        private static final String[] IDENTIFIER_PATH_REL_TO_BASE_SYNCEDGE = new String[]{"syncedge"};
        private static final String[] IDENTIFIER_PATH_REL_TO_BASE_CONTROLEDGE = new String[]{"controledge"};
        private static final String[] IDENTIFIER_PATH_REL_TO_BASE_BRANCH = new String[]{"branch"};
        private static final String[] IDENTIFIER_PATH_REL_TO_BASE_BLOCK = new String[]{"block"};
        private static final String[] IDENTIFIER_PATH_REL_TO_BASE_PARAMETER = new String[]{"node", "ebp", "parameter"};

        public static final String[] getIdentifierPathRelToBase(String processElementType) {
            if (processElementType.equalsIgnoreCase("template")) {
                return IDENTIFIER_PATH_REL_TO_BASE_TEMPLATE;
            }
            if (processElementType.equalsIgnoreCase("instance")) {
                return IDENTIFIER_PATH_REL_TO_BASE_INSTANCE;
            }
            if (processElementType.equalsIgnoreCase("node")) {
                return (String[])IDENTIFIER_PATH_REL_TO_BASE_NODE.clone();
            }
            if (processElementType.equalsIgnoreCase("dataelement")) {
                return (String[])IDENTIFIER_PATH_REL_TO_BASE_DATAELEMENT.clone();
            }
            if (processElementType.equalsIgnoreCase("dataedge")) {
                return (String[])IDENTIFIER_PATH_REL_TO_BASE_DATAEDGE.clone();
            }
            if (processElementType.equalsIgnoreCase("ebp")) {
                return (String[])IDENTIFIER_PATH_REL_TO_BASE_EBP.clone();
            }
            if (processElementType.equalsIgnoreCase("syncedge")) {
                return (String[])IDENTIFIER_PATH_REL_TO_BASE_SYNCEDGE.clone();
            }
            if (processElementType.equalsIgnoreCase("controledge")) {
                return (String[])IDENTIFIER_PATH_REL_TO_BASE_CONTROLEDGE.clone();
            }
            if (processElementType.equalsIgnoreCase("branch")) {
                return (String[])IDENTIFIER_PATH_REL_TO_BASE_BRANCH.clone();
            }
            if (processElementType.equalsIgnoreCase("block")) {
                return (String[])IDENTIFIER_PATH_REL_TO_BASE_BLOCK.clone();
            }
            if (processElementType.equalsIgnoreCase("parameter")) {
                return (String[])IDENTIFIER_PATH_REL_TO_BASE_PARAMETER.clone();
            }
            return null;
        }
    }

    public static enum TemplateBuildtimeState {
        IN_CONSTRUCTION(1),
        VALID(2),
        RELEASED(3);

        private final int code;

        private TemplateBuildtimeState(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }

        public static TemplateBuildtimeState valueOf(String string) {
            return Enum.valueOf(TemplateBuildtimeState.class, string);
        }
    }

    public static enum TemplateProperty {
        NAME(1),
        INSTANCE_NAME_TEMPLATE(2),
        SUPERVISOR_AGENT(3),
        INPUT_PARAMETER(4),
        OUTPUT_PARAMETER(5);

        private final int code;

        private TemplateProperty(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }

        public static TemplateProperty valueOf(String string) {
            return Enum.valueOf(TemplateProperty.class, string);
        }
    }

    public static enum TemplateUsage {
        NO_SUBPROCESS(1),
        AS_COPY(2),
        AS_REFERENCE(3),
        COPY_OR_REFERENCE(4);

        private final int code;

        private TemplateUsage(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }

        public static TemplateUsage valueOf(String string) {
            return Enum.valueOf(TemplateUsage.class, string);
        }
    }
}

