/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.globals;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public final class SystemIdentifier {
    private UUID id;
    private String name;
    private String description;
    private static final List<SystemIdentifier> identifiers = new ArrayList<SystemIdentifier>();

    static {
        SystemIdentifier.loadClass("de.aristaflow.adept2.model.globals.CommonConstants");
        SystemIdentifier.loadClass("de.aristaflow.adept2.model.globals.OrgModelConstants");
        SystemIdentifier.loadClass("de.aristaflow.adept2.model.globals.SystemDataConstants");
        SystemIdentifier.loadClass("de.aristaflow.adept2.model.globals.ProcessConstants");
    }

    private SystemIdentifier(UUID id, String name, String description) {
        this.id = id;
        this.name = name;
        this.description = description;
    }

    public UUID id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    static void register(UUID id, String name, String description) {
        identifiers.add(new SystemIdentifier(id, name, description));
    }

    public static SystemIdentifier[] getSystemIdentifiers() {
        return identifiers.toArray(new SystemIdentifier[identifiers.size()]);
    }

    public static boolean isSystemIdentifier(UUID identifierID) {
        SystemIdentifier[] systemIdentifierArray = SystemIdentifier.getSystemIdentifiers();
        int n = systemIdentifierArray.length;
        int n2 = 0;
        while (n2 < n) {
            SystemIdentifier sysIdentifier = systemIdentifierArray[n2];
            if (sysIdentifier.id().equals(identifierID)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static void loadClass(String className) {
        try {
            Class.forName(className);
        }
        catch (ClassNotFoundException classNotFoundException) {}
    }
}

