/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.globals;

import java.util.ResourceBundle;

public class WorklistConstants {
    @Deprecated
    public static final String SYSTEM_AGENT_NAME = "system";
    @Deprecated
    public static final String SYSTEM_PASSWORD = "password";
    @Deprecated
    public static final int SYSTEM_AGENT = -2;
    @Deprecated
    public static final int SYSTEM_ORGPOSITION = -2;
    @Deprecated
    public static final String SYSTEM_ORGPOSITION_NAME = "system";
    @Deprecated
    public static final String SUPERVISOR_AGENT_NAME = "supervisor";
    @Deprecated
    public static final String SUPERVISOR_PASSWORD = "password";
    @Deprecated
    public static final int SUPERVISOR_AGENT = -1;
    @Deprecated
    public static final int SUPERVISOR_ORGPOSITION = -1;
    @Deprecated
    public static final int SUPERVISOR_GLOBAL_WORKLIST_ORGPOSITION = -3;
    @Deprecated
    public static final int SUPERVISOR_FALLBACK_WORKLIST_ORGPOSITION = -4;
    @Deprecated
    public static final String SUPERVISOR_ORGPOSITION_NAME = "supervisor";

    public static final class ActivityReferenceTypes {
        public static final String ADEPT2Activity = "de.aristaflow.ADEPT2ActivityReference";
        public static final String LWPActivity = "de.aristaflow.LWPActivityReference";
        public static final String TLPInstance = "de.aristaflow.TLPInstanceReference";

        private ActivityReferenceTypes() {
        }
    }

    public static enum DistributionMethod {
        ALL,
        ROUND_ROBIN,
        LOAD_BALANCING;

    }

    public static enum Priority {
        NOT_SET(0),
        ON_HOLD(1000),
        VERY_LOW(2000),
        LOW(3000),
        NORMAL(4000),
        HIGH(5000),
        URGENT(6000),
        ACTION_REQUIRED(7000);

        private int priority;

        private Priority(int priority) {
            this.priority = priority;
        }

        public int getPriority() {
            return this.priority;
        }

        public static String toString(ResourceBundle bundle, int priority) {
            String[] priorityNames = new String[]{"not set", "on hold", "very low", "low", "normal", "high", "urgent", "action required"};
            if (bundle != null) {
                priorityNames = new String[]{bundle.getString(NOT_SET.name()), bundle.getString(ON_HOLD.name()), bundle.getString(VERY_LOW.name()), bundle.getString(LOW.name()), bundle.getString(NORMAL.name()), bundle.getString(HIGH.name()), bundle.getString(URGENT.name()), bundle.getString(ACTION_REQUIRED.name())};
            }
            if (priority > ACTION_REQUIRED.getPriority()) {
                return "> " + priorityNames[7];
            }
            int remaining = priority;
            String res = "";
            int cur = 0;
            while (remaining >= 0 && cur < 8) {
                remaining -= 1000;
                res = priorityNames[cur];
                ++cur;
            }
            if (remaining > 0) {
                res = cur > 0 ? String.valueOf(res) + " < " + priorityNames[cur] : "< " + priorityNames[0];
            } else if (cur == 0) {
                res = "< " + priorityNames[0];
            }
            return res;
        }

        public static String[] valueLabels(ResourceBundle bundle) {
            String[] res = new String[Priority.values().length];
            int i = 0;
            while (i < Priority.values().length) {
                res[i] = Priority.toString(bundle, Priority.values()[i].getPriority());
                ++i;
            }
            return res;
        }
    }

    public static abstract class UpdateMode {
        public static final String PUSH = "PUSH";
        public static final String POLL = "POLL";
    }

    public static enum WorklistItemState {
        AVAILABLE,
        ASSIGNED,
        STARTED,
        SUSPENDED,
        ENQUIRED;

    }

    public static enum WorklistItemUpdateType {
        CHANGED,
        ADDED,
        REMOVED;

    }
}

