/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.logmanagement;

import de.aristaflow.adept2.model.logmanagement.DataType;
import de.aristaflow.adept2.util.ArgChecks;

public enum CmpOperator {
    EQUAL("="),
    NOT_EQUAL("!="),
    GREATER_THAN(">"),
    GREATER_THAN_OR_EQUAL(">="),
    LESS_THAN("<"),
    LESS_THAN_OR_EQUAL("<="),
    LIKE("~"),
    NOT_LIKE("!~"),
    LIKE_IGNORECASE("~i"),
    NOT_LIKE_IGNORECASE("!~i");

    private final String symbol;

    private CmpOperator(String symbol) {
        this.symbol = symbol;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public static CmpOperator getCmpOperatorForSymbol(String symbol) {
        ArgChecks.checkForNull(symbol, "symbol");
        CmpOperator[] cmpOperatorArray = CmpOperator.values();
        int n = cmpOperatorArray.length;
        int n2 = 0;
        while (n2 < n) {
            CmpOperator cmpOp = cmpOperatorArray[n2];
            if (symbol.equalsIgnoreCase(cmpOp.getSymbol())) {
                return cmpOp;
            }
            ++n2;
        }
        return null;
    }

    public boolean canCompare(DataType dataType) {
        if (dataType == DataType.COMPLEX) {
            return false;
        }
        if (dataType == null || dataType == DataType.BOOLEAN || dataType == DataType.UUID) {
            return this == EQUAL || this == NOT_EQUAL;
        }
        if (this == LIKE || this == NOT_LIKE || this == LIKE_IGNORECASE || this == NOT_LIKE_IGNORECASE) {
            return dataType == DataType.STRING;
        }
        return true;
    }

    public boolean canCompare(DataType columnDataType, DataType valueDataType) {
        ArgChecks.checkForNull((Object)columnDataType, "columnDataType");
        if (columnDataType == DataType.COMPLEX || valueDataType == DataType.COMPLEX) {
            return false;
        }
        if (valueDataType == null) {
            return this == EQUAL || this == NOT_EQUAL;
        }
        if (columnDataType == DataType.BOOLEAN || columnDataType == DataType.UUID) {
            return valueDataType == columnDataType && (this == EQUAL || this == NOT_EQUAL);
        }
        if (this == LIKE || this == NOT_LIKE || this == LIKE_IGNORECASE || this == NOT_LIKE_IGNORECASE) {
            return columnDataType == DataType.STRING && valueDataType == DataType.STRING;
        }
        if (columnDataType == valueDataType) {
            return true;
        }
        return this.primitiveCastPossible(valueDataType, columnDataType);
    }

    private boolean primitiveCastPossible(DataType from, DataType to) {
        switch (from) {
            case BYTE: {
                if (to == DataType.BYTE) {
                    return true;
                }
            }
            case SHORT: {
                if (to == DataType.SHORT) {
                    return true;
                }
            }
            case INTEGER: {
                if (to == DataType.INTEGER) {
                    return true;
                }
            }
            case LONG: {
                if (to == DataType.LONG) {
                    return true;
                }
            }
            case FLOAT: {
                if (to == DataType.FLOAT) {
                    return true;
                }
            }
            case DOUBLE: {
                if (to != DataType.DOUBLE) break;
                return true;
            }
        }
        return false;
    }
}

