/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.logmanagement;

import de.aristaflow.adept2.model.logmanagement.DataType;
import de.aristaflow.adept2.model.logmanagement.Schema;
import de.aristaflow.adept2.util.ArgChecks;
import de.aristaflow.adept2.util.HashCalc;
import java.io.Serializable;

public class Column
implements Serializable {
    private static final long serialVersionUID = -489504586431219707L;
    private final String name;
    private final DataType dataType;
    private final Schema subSchema;
    private final int sizeHint;

    public Column(String name, DataType dataType) {
        ArgChecks.checkForBlank(name, "name");
        if (name.contains("_")) {
            throw new IllegalArgumentException("A column name must not contain the underscore character!");
        }
        if (name.equalsIgnoreCase("id")) {
            throw new IllegalArgumentException("The column name 'id' is reserved and must not be used!");
        }
        if (name.equalsIgnoreCase("refId")) {
            throw new IllegalArgumentException("The column name 'refId' is reserved and must not be used!");
        }
        ArgChecks.checkForNull((Object)dataType, "dataType");
        if (dataType == DataType.COMPLEX || dataType == DataType.STRING) {
            throw new IllegalArgumentException("use special constructor instead for this data type");
        }
        this.name = name;
        this.dataType = dataType;
        this.subSchema = null;
        this.sizeHint = -1;
    }

    public Column(String name, int sizeHint) {
        ArgChecks.checkForBlank(name, "name");
        if (name.contains("_")) {
            throw new IllegalArgumentException("A column name must not contain the underscore character!");
        }
        ArgChecks.checkForNonpositive(sizeHint, "sizeHint");
        this.name = name;
        this.dataType = DataType.STRING;
        this.subSchema = null;
        this.sizeHint = sizeHint;
    }

    public Column(String name, Schema subSchema) {
        ArgChecks.checkForBlank(name, "name");
        if (name.contains("_")) {
            throw new IllegalArgumentException("A column name must not contain the underscore character!");
        }
        ArgChecks.checkForNull(subSchema, "subSchema");
        this.name = name;
        this.dataType = DataType.COMPLEX;
        this.subSchema = subSchema;
        this.sizeHint = -1;
    }

    public String getName() {
        return this.name;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public Schema getSubSchema() {
        return this.subSchema;
    }

    public int getSizeHint() {
        return this.sizeHint;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        Column otherColumn = (Column)obj;
        if (!this.name.equals(otherColumn.name) || this.dataType != otherColumn.dataType || this.sizeHint != otherColumn.sizeHint) {
            return false;
        }
        return this.subSchema == otherColumn.subSchema || !(this.subSchema != null ? !this.subSchema.equals(otherColumn.subSchema) : !otherColumn.subSchema.equals(this.subSchema));
    }

    public int hashCode() {
        return new HashCalc(this.getClass()).feed(this.name).feed((Object)this.dataType).feed(this.subSchema).feed(this.sizeHint).hashCode();
    }
}

