/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.logmanagement;

import de.aristaflow.adept2.model.logmanagement.LogEntrySet;
import java.sql.Timestamp;
import java.util.UUID;

public enum DataType {
    BOOLEAN(Boolean.class),
    BYTE(Byte.class),
    SHORT(Short.class),
    INTEGER(Integer.class),
    LONG(Long.class),
    FLOAT(Float.class),
    DOUBLE(Double.class),
    STRING(String.class),
    UUID(UUID.class),
    TIMESTAMP(Timestamp.class),
    COMPLEX(LogEntrySet.class);

    private Class<?> cls;

    private DataType(Class<?> cls) {
        this.cls = cls;
    }

    public Class<?> getTypeClass() {
        return this.cls;
    }

    public static DataType getDataTypeForObject(Object value) {
        if (value == null) {
            return null;
        }
        DataType[] dataTypeArray = DataType.values();
        int n = dataTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            DataType dataType = dataTypeArray[n2];
            if (dataType.getTypeClass().isInstance(value)) {
                return dataType;
            }
            ++n2;
        }
        String msg = "The class type '%s' is no supported data type in the log manager!";
        msg = String.format(msg, value.getClass().getName());
        throw new IllegalArgumentException(msg);
    }
}

