/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.logmanagement;

import de.aristaflow.adept2.model.logmanagement.Column;
import de.aristaflow.adept2.util.ArgChecks;
import java.io.Serializable;

public class Schema
implements Serializable {
    private static final long serialVersionUID = 3992412373980063373L;
    private final Column[] columns;

    public Schema(Column ... columns) {
        ArgChecks.checkForNulls(columns, "columns");
        ArgChecks.checkForEmpty(columns, "columns");
        this.columns = (Column[])columns.clone();
    }

    public int getColumnCount() {
        return this.columns.length;
    }

    public Column getColumn(int index) {
        return this.columns[index];
    }

    public int indexOfColumn(String columnName) {
        ArgChecks.checkForEmpty(columnName, "columnName");
        int i = 0;
        while (i < this.columns.length) {
            Column col = this.columns[i];
            if (col.getName().equalsIgnoreCase(columnName)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public Column getColumn(String columnName) {
        ArgChecks.checkForEmpty(columnName, "columnName");
        Column[] columnArray = this.columns;
        int n = this.columns.length;
        int n2 = 0;
        while (n2 < n) {
            Column col = columnArray[n2];
            if (col.getName().equalsIgnoreCase(columnName)) {
                return col;
            }
            ++n2;
        }
        return null;
    }

    public Column[] getColumns() {
        return (Column[])this.columns.clone();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        Schema otherSchema = (Schema)obj;
        if (this.columns.length != otherSchema.columns.length) {
            return false;
        }
        int i = 0;
        while (i < this.columns.length) {
            if (!this.columns[i].equals(otherSchema.columns[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 7;
        Column[] columnArray = this.columns;
        int n = this.columns.length;
        int n2 = 0;
        while (n2 < n) {
            Column column = columnArray[n2];
            hashCode = hashCode * 31 + column.hashCode();
            ++n2;
        }
        return hashCode;
    }
}

