/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.mail;

import de.aristaflow.adept2.util.ArgChecks;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;

public abstract class SerialisableAttachment
implements Serializable {
    private static final long serialVersionUID = -4783003991032280131L;
    protected final String name;
    protected final String description;
    protected final String contentType;

    protected SerialisableAttachment(String name, String description) {
        this(name, description, "application/octet-stream");
    }

    protected SerialisableAttachment(String name, String description, String contentType) {
        ArgChecks.checkForBlank(name, "name");
        ArgChecks.checkForBlank(description, "description");
        ArgChecks.checkForBlank(contentType, "contentType");
        this.name = name;
        this.description = description;
        this.contentType = contentType;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getContentType() {
        return this.contentType;
    }

    public abstract InputStream getContent() throws IOException;
}

