/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.orgmodel;

import de.aristaflow.adept2.model.orgmodel.DataType;
import de.aristaflow.adept2.util.NullArgumentException;

public enum CmpOperator {
    EQUAL("="),
    NOT_EQUAL("!=", "<>"),
    GREATER_THAN(">"),
    GREATER_THAN_OR_EQUAL(">="),
    LESS_THAN("<"),
    LESS_THAN_OR_EQUAL("<="),
    LIKE("~"),
    NOT_LIKE("!~"),
    LIKE_IGNORECASE("~i"),
    NOT_LIKE_IGNORECASE("!~i");

    private final String[] symbols;

    private CmpOperator(String ... symbols) {
        this.symbols = symbols;
    }

    public String symbol() {
        return this.symbols[0];
    }

    public String[] symbols() {
        return (String[])this.symbols.clone();
    }

    public CmpOperator negate() {
        if (this == EQUAL) {
            return NOT_EQUAL;
        }
        if (this == NOT_EQUAL) {
            return EQUAL;
        }
        if (this == GREATER_THAN) {
            return LESS_THAN_OR_EQUAL;
        }
        if (this == GREATER_THAN_OR_EQUAL) {
            return LESS_THAN;
        }
        if (this == LESS_THAN) {
            return GREATER_THAN_OR_EQUAL;
        }
        if (this == LESS_THAN_OR_EQUAL) {
            return GREATER_THAN;
        }
        if (this == LIKE) {
            return NOT_LIKE;
        }
        if (this == NOT_LIKE) {
            return LIKE;
        }
        if (this == LIKE_IGNORECASE) {
            return NOT_LIKE_IGNORECASE;
        }
        if (this == NOT_LIKE_IGNORECASE) {
            return LIKE_IGNORECASE;
        }
        throw new AssertionError((Object)("Comparison operator encountered for which no negated operator is defined: " + (Object)((Object)this)));
    }

    public boolean canCompare(DataType attributeDataType, DataType valueObjectDataType) {
        if (attributeDataType == null) {
            throw new NullArgumentException("The parameter 'attributeDataType' must not be null!");
        }
        if (attributeDataType == DataType.NULL) {
            throw new IllegalArgumentException("The parameter 'attributeDataType' must not be DataType.NULL!");
        }
        if (valueObjectDataType == null) {
            throw new NullArgumentException("The parameter 'valueObjectDataType' must not be null!");
        }
        if (valueObjectDataType == DataType.NULL) {
            return this == EQUAL || this == NOT_EQUAL;
        }
        if (this == LIKE || this == NOT_LIKE || this == LIKE_IGNORECASE || this == NOT_LIKE_IGNORECASE) {
            return attributeDataType == DataType.STRING && valueObjectDataType == DataType.STRING;
        }
        if (attributeDataType == valueObjectDataType) {
            return true;
        }
        if (attributeDataType.isNumber() && valueObjectDataType.isNumber()) {
            return true;
        }
        return attributeDataType == DataType.DATE && valueObjectDataType == DataType.TIME || attributeDataType == DataType.TIME && valueObjectDataType == DataType.DATE;
    }

    public boolean canCompare(DataType dataType) {
        if (dataType == null) {
            throw new NullArgumentException("The parameter 'dataType' must not be null!");
        }
        if (dataType == DataType.NULL) {
            return this == EQUAL || this == NOT_EQUAL;
        }
        if (this == LIKE || this == NOT_LIKE || this == LIKE_IGNORECASE || this == NOT_LIKE_IGNORECASE) {
            return dataType == DataType.STRING;
        }
        return true;
    }

    public static CmpOperator getCmpOperatorFor(String symbol) {
        CmpOperator[] cmpOperatorArray = CmpOperator.values();
        int n = cmpOperatorArray.length;
        int n2 = 0;
        while (n2 < n) {
            CmpOperator op = cmpOperatorArray[n2];
            String[] stringArray = op.symbols;
            int n3 = op.symbols.length;
            int n4 = 0;
            while (n4 < n3) {
                String symb = stringArray[n4];
                if (symb.equalsIgnoreCase(symbol)) {
                    return op;
                }
                ++n4;
            }
            ++n2;
        }
        return null;
    }
}

