/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.orgmodel;

import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.util.ArgChecks;
import de.aristaflow.adept2.util.NullArgumentException;
import de.aristaflow.adept2.util.time.CalendarTools;
import java.util.Calendar;
import java.util.Date;

public enum DataType {
    NULL(false),
    INTEGER(true),
    FLOAT(true),
    STRING(false),
    DATE(false, false),
    TIME(false, false),
    TIMESTAMP(false);

    private final boolean isEnabled;
    private final boolean isNumber;

    private DataType(boolean isNumber) {
        this.isNumber = isNumber;
        this.isEnabled = true;
    }

    private DataType(boolean isNumber, boolean isEnabled) {
        this.isNumber = isNumber;
        this.isEnabled = isEnabled;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public boolean isNumber() {
        return this.isNumber;
    }

    public boolean isAssignableFrom(DataType dataType) {
        if (dataType == null) {
            throw new NullArgumentException("The parameter 'dataType' must not be null!");
        }
        if (dataType == NULL) {
            return true;
        }
        if (this == dataType) {
            return true;
        }
        if (this == FLOAT && dataType == INTEGER) {
            return true;
        }
        return this == TIMESTAMP && dataType == DATE;
    }

    public String displayName() {
        return this.name();
    }

    public static DataType getDataTypeForObject(Object object) {
        if (object == null) {
            return NULL;
        }
        if (object instanceof Long || object instanceof Integer || object instanceof Short || object instanceof Byte) {
            return INTEGER;
        }
        if (object instanceof Double || object instanceof Float) {
            return FLOAT;
        }
        if (object instanceof String) {
            return STRING;
        }
        if (object instanceof Date) {
            Date date = (Date)object;
            Calendar cal = CalendarTools.createUTCCalendar();
            cal.setTime(date);
            if (cal.get(11) == 0 && cal.get(12) == 0 && cal.get(13) == 0 && cal.get(14) == 0) {
                return DATE;
            }
            if (cal.get(1) == 1970 && cal.get(2) == 0 && cal.get(5) == 1) {
                return TIME;
            }
            return TIMESTAMP;
        }
        return null;
    }

    public static DataType fromAdeptDataType(ProcessConstants.AdeptDataType adeptDataType) {
        ArgChecks.checkForNull((Object)adeptDataType, "adeptDataType");
        switch (adeptDataType) {
            case INTEGER: {
                return INTEGER;
            }
            case FLOAT: {
                return FLOAT;
            }
            case STRING: {
                return STRING;
            }
            case DATE: {
                return TIMESTAMP;
            }
        }
        return null;
    }

    public static ProcessConstants.AdeptDataType toAdeptDataType(DataType dataType) {
        ArgChecks.checkForNull((Object)dataType, "dataType");
        switch (dataType) {
            case INTEGER: {
                return ProcessConstants.AdeptDataType.INTEGER;
            }
            case FLOAT: {
                return ProcessConstants.AdeptDataType.FLOAT;
            }
            case STRING: {
                return ProcessConstants.AdeptDataType.STRING;
            }
            case DATE: 
            case TIME: 
            case TIMESTAMP: {
                return ProcessConstants.AdeptDataType.DATE;
            }
        }
        return null;
    }
}

