/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.orgmodel;

import de.aristaflow.adept2.model.common.filter.UseInFilter;
import de.aristaflow.adept2.model.orgmodel.EntityType;
import de.aristaflow.adept2.model.orgmodel.OrgModelTools;
import de.aristaflow.adept2.util.NullArgumentException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class Entity
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -5696575098444475249L;
    private EntityType type;
    private List<NameValuePair> attributes;

    public Entity(EntityType entityType) {
        if (entityType == null) {
            throw new NullArgumentException("The parameter 'entityType' must not be null!");
        }
        this.type = entityType;
        this.attributes = new ArrayList<NameValuePair>();
    }

    public Entity(EntityType entityType, long id) {
        this(entityType);
        this.setInteger("id", id);
    }

    public Entity(EntityType entityType, int attributeCount) {
        if (entityType == null) {
            throw new NullArgumentException("The parameter 'entityType' must not be null!");
        }
        if (attributeCount < 0) {
            throw new IllegalArgumentException("The parameter 'attributeCount' must not be negative!");
        }
        this.type = entityType;
        this.attributes = new ArrayList<NameValuePair>(attributeCount);
    }

    public EntityType getType() {
        return this.type;
    }

    public int getAttributeCount() {
        return this.attributes.size();
    }

    public String[] getAttributeNames() {
        String[] names = new String[this.attributes.size()];
        int i = 0;
        int size = this.attributes.size();
        while (i < size) {
            names[i] = this.attributes.get((int)i).name;
            ++i;
        }
        return names;
    }

    public boolean containsAttribute(String attrName) {
        for (NameValuePair pair : this.attributes) {
            if (!pair.name.equalsIgnoreCase(attrName)) continue;
            return true;
        }
        return false;
    }

    public boolean isNull(String attrName) throws IllegalArgumentException {
        Object value = this.get(attrName);
        return value == null;
    }

    public void removeAttribute(String attrName) {
        Iterator<NameValuePair> it = this.attributes.iterator();
        while (it.hasNext()) {
            NameValuePair pair = it.next();
            if (!pair.name.equalsIgnoreCase(attrName)) continue;
            it.remove();
            break;
        }
    }

    @UseInFilter
    public Object get(String attrName) throws IllegalArgumentException {
        for (NameValuePair pair : this.attributes) {
            if (!pair.name.equalsIgnoreCase(attrName)) continue;
            return pair.value;
        }
        throw new IllegalArgumentException("Attribute '" + attrName + "' is not contained in this Entity-object!");
    }

    @UseInFilter
    public long getInteger(String attrName) throws IllegalArgumentException {
        Object value = this.get(attrName);
        if (value == null) {
            return 0L;
        }
        return (Long)value;
    }

    public double getFloat(String attrName) throws IllegalArgumentException {
        Object value = this.get(attrName);
        if (value == null) {
            return 0.0;
        }
        return (Double)value;
    }

    @UseInFilter
    public String getString(String attrName) throws IllegalArgumentException {
        Object value = this.get(attrName);
        if (value == null) {
            return null;
        }
        return (String)value;
    }

    public Date getDate(String attrName) throws IllegalArgumentException {
        return (Date)this.get(attrName);
    }

    public void set(String attrName, Object value) {
        if (attrName == null) {
            throw new NullArgumentException("The parameter 'attrName' must not be null!");
        }
        if (!OrgModelTools.isValidAttributeName(attrName)) {
            throw new IllegalArgumentException("The parameter 'attrName' is no legal attribute name: " + attrName);
        }
        boolean found = false;
        for (NameValuePair pair : this.attributes) {
            if (!pair.name.equalsIgnoreCase(attrName)) continue;
            pair.value = value;
            found = true;
        }
        if (!found) {
            NameValuePair pair;
            pair = new NameValuePair(attrName, value);
            this.attributes.add(pair);
        }
    }

    public void setNull(String attrName) {
        this.set(attrName, null);
    }

    public void setInteger(String attrName, long value) {
        this.set(attrName, value);
    }

    public void setFloat(String attrName, double value) {
        this.set(attrName, value);
    }

    public void setString(String attrName, String value) {
        this.set(attrName, value);
    }

    public void setDate(String attrName, Date value) {
        this.set(attrName, value);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Entity)) {
            return false;
        }
        Entity other = (Entity)obj;
        if (!this.containsAttribute("id") || !other.containsAttribute("id")) {
            return false;
        }
        return this.getInteger("id") == other.getInteger("id");
    }

    public int hashCode() {
        if (this.containsAttribute("id")) {
            return this.get("id").hashCode();
        }
        return super.hashCode();
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append((Object)this.type).append("(");
        boolean first = true;
        for (NameValuePair pair : this.attributes) {
            if (first) {
                first = false;
            } else {
                s.append(", ");
            }
            s.append(pair.name);
            s.append("=");
            Object value = pair.value;
            s.append(OrgModelTools.toPolicyToken(value));
        }
        s.append(")");
        return s.toString();
    }

    public Entity clone() {
        Entity entity = new Entity(this.getType(), this.getAttributeCount());
        int i = 0;
        int count = this.getAttributeCount();
        while (i < count) {
            entity.attributes.add(this.attributes.get(i).clone());
            ++i;
        }
        return entity;
    }

    private static class NameValuePair
    implements Serializable {
        private static final long serialVersionUID = -3243102971309391720L;
        final String name;
        Object value;

        NameValuePair(String name) {
            this.name = name;
        }

        NameValuePair(String name, Object value) {
            this.name = name;
            this.value = value;
        }

        protected NameValuePair clone() {
            return new NameValuePair(this.name, this.value);
        }
    }
}

