/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.orgmodel;

import de.aristaflow.adept2.model.globals.OrgModelConstants;
import de.aristaflow.adept2.model.orgmodel.NavFunction;
import java.util.UUID;

public enum EntityType {
    AGENT("Agent", new String[]{"id", "userName", "password", "locale", "email"}, OrgModelConstants.IDENTIFIER_ID_AGENT),
    ORG_POSITION("OrgPosition", new String[]{"id", "name", "orgUnitId"}, OrgModelConstants.IDENTIFIER_ID_ORG_POSITION),
    ORG_UNIT("OrgUnit", new String[]{"id", "supId", "managerId"}, OrgModelConstants.IDENTIFIER_ID_ORG_UNIT),
    ORG_GROUP("OrgGroup", new String[]{"id", "managerId"}, OrgModelConstants.IDENTIFIER_ID_ORG_GROUP),
    PROJECT_GROUP("ProjectGroup", new String[]{"id", "supId", "managerId"}, OrgModelConstants.IDENTIFIER_ID_PROJECT_GROUP),
    ABILITY("Ability", new String[]{"id"}, OrgModelConstants.IDENTIFIER_ID_ABILITY),
    ROLE("Role", new String[]{"id", "supId"}, OrgModelConstants.IDENTIFIER_ID_ROLE),
    SUBSTITUTION_RULE("SubstitutionRule", new String[]{"id", "orgPositionId", "substituteId", "roleId"}, OrgModelConstants.IDENTIFIER_ID_SUBSTITUTION_RULE);

    private final String policyToken;
    private final String[] mandatoryAttributes;
    private final UUID identifierID;

    private EntityType(String policyToken, String[] mandatoryAttributes, UUID identifierID) {
        this.policyToken = policyToken;
        this.mandatoryAttributes = mandatoryAttributes;
        this.identifierID = identifierID;
    }

    public String policyToken() {
        return this.policyToken;
    }

    public UUID identifierID() {
        return this.identifierID;
    }

    public String[] getMandatoryAttributes() {
        return (String[])this.mandatoryAttributes.clone();
    }

    public boolean hasMandatoryAttribute(String attrName) {
        String[] stringArray = this.mandatoryAttributes;
        int n = this.mandatoryAttributes.length;
        int n2 = 0;
        while (n2 < n) {
            String mandAttr = stringArray[n2];
            if (mandAttr.equalsIgnoreCase(attrName)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean hasReadOnlyAttribute(String attrName) {
        if (this == AGENT && (attrName.equalsIgnoreCase("userName") || attrName.equalsIgnoreCase("password") || attrName.equalsIgnoreCase("locale") || attrName.equalsIgnoreCase("email"))) {
            return false;
        }
        if (this == ORG_POSITION && attrName.equalsIgnoreCase("name")) {
            return false;
        }
        return this.hasMandatoryAttribute(attrName);
    }

    public boolean hasNavFunction(String funcName) {
        NavFunction[] navFunctionArray = NavFunction.functions.get((Object)this);
        int n = navFunctionArray.length;
        int n2 = 0;
        while (n2 < n) {
            NavFunction func = navFunctionArray[n2];
            if (func.policyToken().equalsIgnoreCase(funcName)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public NavFunction getNavFunction(String funcName) {
        NavFunction[] navFunctionArray = NavFunction.functions.get((Object)this);
        int n = navFunctionArray.length;
        int n2 = 0;
        while (n2 < n) {
            NavFunction func = navFunctionArray[n2];
            if (func.policyToken().equalsIgnoreCase(funcName)) {
                return func;
            }
            ++n2;
        }
        return null;
    }

    public NavFunction[] getNavFunctions() {
        return NavFunction.getFunctionsFor(this);
    }

    public String toString() {
        return this.policyToken();
    }

    public static EntityType fromPolicyToken(String policyToken) {
        EntityType[] entityTypeArray = EntityType.values();
        int n = entityTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            EntityType type = entityTypeArray[n2];
            if (type.policyToken().equalsIgnoreCase(policyToken)) {
                return type;
            }
            ++n2;
        }
        return null;
    }

    public static EntityType fromIdentifierID(UUID identifierID) {
        EntityType[] entityTypeArray = EntityType.values();
        int n = entityTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            EntityType type = entityTypeArray[n2];
            if (type.identifierID().equals(identifierID)) {
                return type;
            }
            ++n2;
        }
        return null;
    }
}

