/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.orgmodel;

import de.aristaflow.adept2.model.orgmodel.EntityType;
import de.aristaflow.adept2.model.orgmodel.RelationType;
import de.aristaflow.adept2.util.ArgChecks;
import de.aristaflow.adept2.util.NullArgumentException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class NavFunction
implements Serializable {
    private static final long serialVersionUID = 7904873374233272806L;
    private final String name;
    private final boolean trans;
    private final RelationType relType;
    private final boolean leftToRight;
    static Map<EntityType, NavFunction[]> functions = new HashMap<EntityType, NavFunction[]>();

    static {
        functions.put(EntityType.AGENT, new NavFunction[]{new NavFunction("getOrgPositions", EntityType.AGENT, EntityType.ORG_POSITION, false, RelationType.ORG_POSITION_OCCUPATION, false), new NavFunction("getAbilities", EntityType.AGENT, EntityType.ABILITY, false, RelationType.AGENT_ABILITY, true)});
        functions.put(EntityType.ORG_POSITION, new NavFunction[]{new NavFunction("getAgents", EntityType.ORG_POSITION, EntityType.AGENT, false, RelationType.ORG_POSITION_OCCUPATION, true), new NavFunction("getRoles", EntityType.ORG_POSITION, EntityType.ROLE, false, RelationType.ORG_POSITION_DESCRIPTION, true), new NavFunction("getOrgUnit", EntityType.ORG_POSITION, EntityType.ORG_UNIT, false, RelationType.ORG_POSITION_AFFILIATION, false), new NavFunction("getManagedOrgUnits", EntityType.ORG_POSITION, EntityType.ORG_UNIT, false, RelationType.ORG_UNIT_MANAGEMENT, true), new NavFunction("getManagedOrgGroups", EntityType.ORG_POSITION, EntityType.ORG_GROUP, false, RelationType.ORG_GROUP_MANAGEMENT, true), new NavFunction("getProjectGroups", EntityType.ORG_POSITION, EntityType.PROJECT_GROUP, false, RelationType.PROJECT_INVOLVEMENT_ORG_POSITION, false), new NavFunction("getManagedProjectGroups", EntityType.ORG_POSITION, EntityType.PROJECT_GROUP, false, RelationType.PROJECT_GROUP_MANAGEMENT, true), new NavFunction("getSubstitutionRules", EntityType.ORG_POSITION, EntityType.SUBSTITUTION_RULE, false, RelationType.ORG_POSITION_SUBSTITUTION, true), new NavFunction("getSubstituteRules", EntityType.ORG_POSITION, EntityType.SUBSTITUTION_RULE, false, RelationType.ORG_POSITION_SUBSTITUTE, true)});
        functions.put(EntityType.ORG_UNIT, new NavFunction[]{new NavFunction("getOrgPositions", EntityType.ORG_UNIT, EntityType.ORG_POSITION, false, RelationType.ORG_POSITION_AFFILIATION, true), new NavFunction("getSubOrgUnits", EntityType.ORG_UNIT, EntityType.ORG_UNIT, true, RelationType.ORG_UNIT_SUBORDINATION, true), new NavFunction("getSuperOrgUnit", EntityType.ORG_UNIT, EntityType.ORG_UNIT, true, RelationType.ORG_UNIT_SUBORDINATION, false), new NavFunction("getManagerPosition", EntityType.ORG_UNIT, EntityType.ORG_POSITION, false, RelationType.ORG_UNIT_MANAGEMENT, false), new NavFunction("getOrgGroups", EntityType.ORG_UNIT, EntityType.ORG_GROUP, false, RelationType.ORG_GROUP_INVOLVEMENT, false), new NavFunction("getProjectGroups", EntityType.ORG_UNIT, EntityType.PROJECT_GROUP, false, RelationType.PROJECT_INVOLVEMENT_ORG_UNIT, false)});
        functions.put(EntityType.ORG_GROUP, new NavFunction[]{new NavFunction("getOrgUnits", EntityType.ORG_GROUP, EntityType.ORG_UNIT, false, RelationType.ORG_GROUP_INVOLVEMENT, true), new NavFunction("getManagerPosition", EntityType.ORG_GROUP, EntityType.ORG_POSITION, false, RelationType.ORG_GROUP_MANAGEMENT, false)});
        functions.put(EntityType.PROJECT_GROUP, new NavFunction[]{new NavFunction("getOrgPositions", EntityType.PROJECT_GROUP, EntityType.ORG_POSITION, false, RelationType.PROJECT_INVOLVEMENT_ORG_POSITION, true), new NavFunction("getOrgUnits", EntityType.PROJECT_GROUP, EntityType.ORG_UNIT, false, RelationType.PROJECT_INVOLVEMENT_ORG_UNIT, true), new NavFunction("getSubProjectGroups", EntityType.PROJECT_GROUP, EntityType.PROJECT_GROUP, true, RelationType.PROJECT_GROUP_SUBORDINATION, true), new NavFunction("getSuperProjectGroup", EntityType.PROJECT_GROUP, EntityType.PROJECT_GROUP, true, RelationType.PROJECT_GROUP_SUBORDINATION, false), new NavFunction("getManagerPosition", EntityType.PROJECT_GROUP, EntityType.ORG_POSITION, false, RelationType.PROJECT_GROUP_MANAGEMENT, false)});
        functions.put(EntityType.ABILITY, new NavFunction[]{new NavFunction("getAgents", EntityType.ABILITY, EntityType.AGENT, false, RelationType.AGENT_ABILITY, false), new NavFunction("getRoles", EntityType.ABILITY, EntityType.ROLE, false, RelationType.ROLE_DESCRIPTION, false)});
        functions.put(EntityType.ROLE, new NavFunction[]{new NavFunction("getOrgPositions", EntityType.ROLE, EntityType.ORG_POSITION, false, RelationType.ORG_POSITION_DESCRIPTION, false), new NavFunction("getAbilities", EntityType.ROLE, EntityType.ABILITY, false, RelationType.ROLE_DESCRIPTION, true), new NavFunction("getSubRoles", EntityType.ROLE, EntityType.ROLE, true, RelationType.ROLE_SPECIALISATION, true), new NavFunction("getSuperRole", EntityType.ROLE, EntityType.ROLE, false, RelationType.ROLE_SPECIALISATION, false), new NavFunction("getSubstitutionRules", EntityType.ROLE, EntityType.SUBSTITUTION_RULE, false, RelationType.ROLE_SUBSTITUTION, true)});
        functions.put(EntityType.SUBSTITUTION_RULE, new NavFunction[]{new NavFunction("getSubstitute", EntityType.SUBSTITUTION_RULE, EntityType.ORG_POSITION, false, RelationType.ORG_POSITION_SUBSTITUTE, false), new NavFunction("getSubstituted", EntityType.SUBSTITUTION_RULE, EntityType.ORG_POSITION, false, RelationType.ORG_POSITION_SUBSTITUTION, false), new NavFunction("getRole", EntityType.SUBSTITUTION_RULE, EntityType.ROLE, false, RelationType.ROLE_SUBSTITUTION, false)});
    }

    private NavFunction(String name, EntityType source, EntityType target, boolean hasTransitiveOption, RelationType relType, boolean leftToRight) {
        if (leftToRight ? relType.leftHandEntityType() != source || relType.rightHandEntityType() != target : relType.leftHandEntityType() != target || relType.rightHandEntityType() != source) {
            throw new IllegalArgumentException();
        }
        this.name = name;
        this.trans = hasTransitiveOption;
        this.relType = relType;
        this.leftToRight = leftToRight;
    }

    public String policyToken() {
        return this.name;
    }

    public EntityType source() {
        if (this.leftToRight) {
            return this.relType.leftHandEntityType();
        }
        return this.relType.rightHandEntityType();
    }

    public EntityType target() {
        if (this.leftToRight) {
            return this.relType.rightHandEntityType();
        }
        return this.relType.leftHandEntityType();
    }

    public boolean hasTransitiveOption() {
        return this.trans;
    }

    public RelationType relationType() {
        return this.relType;
    }

    public boolean isLeftToRight() {
        return this.leftToRight;
    }

    public String toString() {
        return String.valueOf(this.source().policyToken()) + "." + this.policyToken();
    }

    public static NavFunction[] getFunctionsFor(EntityType entType) {
        if (entType == null) {
            throw new NullArgumentException("The parameter entType must not be null!");
        }
        return (NavFunction[])functions.get((Object)entType).clone();
    }

    public static NavFunction getFunction(EntityType entType, String functionName) {
        if (functionName == null) {
            throw new NullArgumentException("The parameter 'functionName' must not be null!");
        }
        if (functionName.equals("")) {
            throw new IllegalArgumentException("The parameter 'functionName' must not be the empty string!");
        }
        NavFunction[] navFunctionArray = NavFunction.getFunctionsFor(entType);
        int n = navFunctionArray.length;
        int n2 = 0;
        while (n2 < n) {
            NavFunction func = navFunctionArray[n2];
            if (func.policyToken().equalsIgnoreCase(functionName)) {
                return func;
            }
            ++n2;
        }
        String msg = "The function '%s' is not defined for the entity type %s!";
        msg = String.format(msg, new Object[]{functionName, entType});
        throw new IllegalArgumentException(msg);
    }

    public static NavFunction[] getFunctionsFor(RelationType relType) {
        NavFunction navFunction;
        ArgChecks.checkForNull((Object)relType, "relType");
        NavFunction[] navFunctions = new NavFunction[2];
        NavFunction[] navFunctionArray = NavFunction.getFunctionsFor(relType.leftHandEntityType());
        int n = navFunctionArray.length;
        int n2 = 0;
        while (n2 < n) {
            navFunction = navFunctionArray[n2];
            if (navFunction.relationType() == relType) {
                navFunctions[0] = navFunction;
            }
            ++n2;
        }
        navFunctionArray = NavFunction.getFunctionsFor(relType.rightHandEntityType());
        n = navFunctionArray.length;
        n2 = 0;
        while (n2 < n) {
            navFunction = navFunctionArray[n2];
            if (navFunction.relationType() == relType) {
                navFunctions[1] = navFunction;
            }
            ++n2;
        }
        return navFunctions;
    }
}

