/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.orgmodel;

import de.aristaflow.adept2.model.common.paramref.ParameterRefReplacer;
import de.aristaflow.adept2.model.orgmodel.CmpOperator;
import de.aristaflow.adept2.model.orgmodel.DataType;
import de.aristaflow.adept2.util.ArgChecks;
import de.aristaflow.adept2.util.NullArgumentException;
import de.aristaflow.adept2.util.time.CalendarTools;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class OrgModelTools {
    private static final Pattern attrNamePattern = Pattern.compile("^[a-zA-Z_]\\w*$", 2);
    private static final String OP_SYMBOLS_LIST;
    private static final Pattern CONTEXT_PATTERN;

    static {
        StringBuilder symbolsList = new StringBuilder();
        symbolsList.append("(");
        boolean first = true;
        CmpOperator[] cmpOperatorArray = CmpOperator.values();
        int n = cmpOperatorArray.length;
        int n2 = 0;
        while (n2 < n) {
            CmpOperator op = cmpOperatorArray[n2];
            if (first) {
                first = false;
            } else {
                symbolsList.append("|");
            }
            String[] stringArray = op.symbols();
            int n3 = stringArray.length;
            int n4 = 0;
            while (n4 < n3) {
                String symbol = stringArray[n4];
                symbolsList.append(Pattern.quote(symbol));
                ++n4;
            }
            ++n2;
        }
        symbolsList.append(")");
        OP_SYMBOLS_LIST = symbolsList.toString();
        CONTEXT_PATTERN = Pattern.compile(".*" + OP_SYMBOLS_LIST + "\\s*$");
    }

    private OrgModelTools() {
    }

    public static boolean isValidAttributeName(String attrName) {
        if (attrName == null) {
            throw new NullArgumentException("The parameter 'attrName' must not be null!");
        }
        return attrNamePattern.matcher(attrName).matches();
    }

    public static Date createDate(long timeInMillis) {
        Calendar cal = CalendarTools.createUTCCalendar();
        cal.setTimeInMillis(timeInMillis);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date createTime(long timeInMillis) {
        Calendar cal = CalendarTools.createUTCCalendar();
        cal.setTimeInMillis(timeInMillis);
        cal.set(1, 1970);
        cal.set(2, 0);
        cal.set(5, 1);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date createTimestamp(long timeInMillis) {
        Calendar cal = CalendarTools.createUTCCalendar();
        cal.setTimeInMillis(timeInMillis);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static DateFormat createDateFormat() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        dateFormat.setLenient(false);
        return dateFormat;
    }

    public static DateFormat createTimeFormat() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss");
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        dateFormat.setLenient(false);
        return dateFormat;
    }

    public static DateFormat createTimestampFormat() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        dateFormat.setLenient(false);
        return dateFormat;
    }

    public static DateFormat createDisplayDateFormat(TimeZone tz) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        dateFormat.setTimeZone(tz);
        dateFormat.setLenient(false);
        return dateFormat;
    }

    public static DateFormat createDisplayTimeFormat(TimeZone tz) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss");
        dateFormat.setTimeZone(tz);
        dateFormat.setLenient(false);
        return dateFormat;
    }

    public static DateFormat createDisplayTimestampFormat(TimeZone tz) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        dateFormat.setTimeZone(tz);
        dateFormat.setLenient(false);
        return dateFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toPolicyToken(Object value) {
        DataType odt = DataType.getDataTypeForObject(value);
        if (odt == null) {
            String msg = "The type of the value object (%s) could not be mapped to a DataType!";
            msg = String.format(msg, value.getClass());
            throw new IllegalArgumentException(msg);
        }
        switch (odt) {
            case NULL: {
                return "null";
            }
            case FLOAT: {
                return value.toString();
            }
            case STRING: {
                return "'" + ((String)value).replace("'", "''") + "'";
            }
            case DATE: {
                DateFormat df;
                DateFormat dateFormat = df = OrgModelTools.createDateFormat();
                synchronized (dateFormat) {
                    return df.format(value);
                }
            }
            case TIME: {
                DateFormat df;
                DateFormat dateFormat = df = OrgModelTools.createTimeFormat();
                synchronized (dateFormat) {
                    return df.format(value);
                }
            }
            case TIMESTAMP: {
                DateFormat df;
                DateFormat dateFormat = df = OrgModelTools.createTimestampFormat();
                synchronized (dateFormat) {
                    return df.format(value);
                }
            }
        }
        return value.toString();
    }

    public static boolean parameterUsedAsValue(ParameterRefReplacer replacer) {
        ArgChecks.checkForNull(replacer, "replacer");
        Matcher matcher = CONTEXT_PATTERN.matcher(replacer.getParameterisedString());
        matcher.region(0, replacer.getStart());
        return matcher.matches();
    }
}

