/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.orgmodel;

import de.aristaflow.adept2.util.NullArgumentException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class OrgPolicyReport
implements Serializable {
    private static final long serialVersionUID = 8868756541241676037L;
    private ResultType overallResult = ResultType.OK;
    private List<Entry> entries = new ArrayList<Entry>();

    public ResultType getOverallResult() {
        return this.overallResult;
    }

    public int getEntryCount() {
        return this.entries.size();
    }

    public Entry getEntryAt(int index) {
        return this.entries.get(index);
    }

    public Entry[] getEntries() {
        return this.entries.toArray(new Entry[this.entries.size()]);
    }

    public void addEntry(Entry entry) {
        if (entry == null) {
            throw new NullArgumentException("The parameter 'entry' must not be null!");
        }
        this.entries.add(entry);
        if (entry.getResultType().ordinal() > this.getOverallResult().ordinal()) {
            this.overallResult = entry.getResultType();
        }
    }

    public void addEntry(ResultType resultType, String description, int beginColumn, int endColumn) {
        Entry entry = new Entry(resultType, description, beginColumn, endColumn);
        this.addEntry(entry);
    }

    public void addEntry(ResultType resultType, String description, Range ... ranges) {
        Entry entry = new Entry(resultType, description, ranges);
        this.addEntry(entry);
    }

    public static class Entry
    implements Serializable {
        private static final long serialVersionUID = 8411137190286604882L;
        private ResultType resultType;
        private String description;
        private Range[] ranges;

        public Entry(ResultType resultType, String description, int beginColumn, int endColumn) {
            this(resultType, description, new Range(beginColumn, endColumn));
        }

        public Entry(ResultType resultType, String description, Range ... ranges) {
            if (resultType == null) {
                throw new NullArgumentException("The parameter 'resultType' must not be null!");
            }
            if (description == null) {
                throw new NullArgumentException("The parameter 'description' must not be null!");
            }
            if (ranges == null) {
                throw new NullArgumentException("The parameter 'ranges' must not be null!");
            }
            Range[] rangeArray = ranges;
            int n = ranges.length;
            int n2 = 0;
            while (n2 < n) {
                Range range = rangeArray[n2];
                if (range == null) {
                    throw new NullArgumentException("The array parameter 'ranges' must not contain null-values!");
                }
                ++n2;
            }
            this.resultType = resultType;
            this.description = description;
            this.ranges = (Range[])ranges.clone();
        }

        public ResultType getResultType() {
            return this.resultType;
        }

        public String getDescription() {
            return this.description;
        }

        public Range[] getRanges() {
            return (Range[])this.ranges.clone();
        }

        public String toString() {
            StringBuilder s = new StringBuilder();
            s.append(this.description);
            if (this.ranges.length > 0) {
                s.append(" (in column range(s) ");
                boolean first = true;
                Range[] rangeArray = this.ranges;
                int n = this.ranges.length;
                int n2 = 0;
                while (n2 < n) {
                    Range range = rangeArray[n2];
                    if (first) {
                        first = false;
                    } else {
                        s.append(", ");
                    }
                    s.append("[").append(range.getBeginColumn()).append("-").append(range.getEndColumn()).append(")");
                    ++n2;
                }
                s.append(")");
            }
            return s.toString();
        }
    }

    public static class Range
    implements Serializable {
        private static final long serialVersionUID = 3855628674125746963L;
        private final int beginColumn;
        private final int endColumn;

        public Range(int beginColumn, int endColumn) {
            if (beginColumn < 0) {
                throw new IllegalArgumentException("The parameter 'beginColumn' must not be negative!");
            }
            if (endColumn < 0) {
                throw new IllegalArgumentException("The parameter 'endColumn' must not be negative!");
            }
            if (beginColumn > endColumn) {
                throw new IllegalArgumentException("The parameter 'beginColumn' must not be greater than the parameter 'endColumn'!");
            }
            this.beginColumn = beginColumn;
            this.endColumn = endColumn;
        }

        public int getBeginColumn() {
            return this.beginColumn;
        }

        public int getEndColumn() {
            return this.endColumn;
        }

        public String toString() {
            return "[" + this.beginColumn + ", " + this.endColumn + ")";
        }
    }

    public static enum ResultType {
        OK,
        INFO,
        WARNING,
        ERROR;

    }
}

