/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.orgmodel;

import de.aristaflow.adept2.model.common.paramref.ParameterRefReplacer;
import de.aristaflow.adept2.model.common.systemdata.AbstractSystemDataFormatter;
import de.aristaflow.adept2.model.common.systemdata.SystemDataTools;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.orgmodel.OrgModelTools;
import de.aristaflow.adept2.util.ArgChecks;
import java.util.Map;

public class OrgPolicySystemDataFormatter
extends AbstractSystemDataFormatter {
    @Override
    public String format(String parameterisedString, Map<String, Object> parameterValues) {
        ArgChecks.checkForNull(parameterisedString, "parameterisedString");
        ArgChecks.checkForNull(parameterValues, "parameterValues");
        ParameterRefReplacer replacer = SystemDataTools.getReplacer(parameterisedString);
        while (replacer.findNext()) {
            this.ensureValuePresent(replacer.getName(), parameterValues);
            Object value = parameterValues.get(replacer.getName());
            if (value == null) continue;
            this.ensureCorrectType(replacer.getDataType(), value);
            if (replacer.getDataType() == ProcessConstants.AdeptDataType.STRING && !OrgModelTools.parameterUsedAsValue(replacer)) {
                replacer.replaceWith((String)value);
                continue;
            }
            replacer.replaceWith(OrgModelTools.toPolicyToken(value));
        }
        return replacer.getProcessedString();
    }
}

