/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.orgmodel;

import de.aristaflow.adept2.model.orgmodel.EntityType;
import de.aristaflow.adept2.model.orgmodel.NavFunction;
import de.aristaflow.adept2.util.NullArgumentException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class PathCompletion
implements Cloneable {
    private Map<EntityType, NavFunction[]> completions = new HashMap<EntityType, NavFunction[]>();

    public PathCompletion() {
        this.clearCompletionsFor(EntityType.ORG_POSITION, true);
        this.clearCompletionsFor(EntityType.ORG_UNIT, true);
        this.clearCompletionsFor(EntityType.ORG_GROUP, true);
        this.clearCompletionsFor(EntityType.PROJECT_GROUP, true);
        this.clearCompletionsFor(EntityType.ABILITY, true);
        this.clearCompletionsFor(EntityType.ROLE, true);
        this.clearCompletionsFor(EntityType.SUBSTITUTION_RULE, true);
    }

    public NavFunction[] getCompletionsFor(EntityType entType) {
        if (entType == null) {
            throw new NullArgumentException("The parameter 'entType' must not be null!");
        }
        if (entType == EntityType.AGENT) {
            throw new IllegalArgumentException("Agent can't have and doesn't need a path completion!");
        }
        NavFunction[] functions = this.completions.get((Object)entType);
        return functions == null ? null : (NavFunction[])functions.clone();
    }

    public void setCompletionsFor(EntityType entType, NavFunction ... functions) {
        if (entType == null) {
            throw new NullArgumentException("The parameter 'entType' must not be null!");
        }
        if (entType == EntityType.AGENT) {
            throw new IllegalArgumentException("Agent can't have and doesn't need a path completion!");
        }
        if (functions == null || functions.length == 0) {
            this.completions.put(entType, null);
        } else {
            NavFunction[] navFunctionArray = functions;
            int n = functions.length;
            int n2 = 0;
            while (n2 < n) {
                NavFunction func = navFunctionArray[n2];
                if (func == null) {
                    throw new NullArgumentException("The array parameter 'functions' must not contain null-values!");
                }
                if (func.source() != entType) {
                    throw new IllegalArgumentException("The function " + func + "() is no function of " + (Object)((Object)entType) + "!");
                }
                ++n2;
            }
            ArrayList<EntityType> traversalStack = new ArrayList<EntityType>();
            NavFunction[] navFunctionArray2 = functions;
            int n3 = functions.length;
            n = 0;
            while (n < n3) {
                NavFunction func = navFunctionArray2[n];
                traversalStack.clear();
                traversalStack.add(func.target());
                while (traversalStack.size() > 0) {
                    NavFunction[] fs;
                    EntityType e = (EntityType)((Object)traversalStack.remove(traversalStack.size() - 1));
                    if (e == entType) {
                        throw new IllegalArgumentException("Completing " + (Object)((Object)entType) + " with the function " + func + "() would create a loop!");
                    }
                    if (e == EntityType.AGENT || (fs = this.getCompletionsFor(e)) == null) continue;
                    NavFunction[] navFunctionArray3 = fs;
                    int n4 = fs.length;
                    int n5 = 0;
                    while (n5 < n4) {
                        NavFunction f = navFunctionArray3[n5];
                        traversalStack.add(f.target());
                        ++n5;
                    }
                }
                ++n;
            }
            this.completions.put(entType, (NavFunction[])functions.clone());
        }
    }

    public void clearCompletionsFor(EntityType entType, boolean resetToDefaults) {
        if (entType == null) {
            throw new NullArgumentException("The parameter 'entType' must not be null!");
        }
        if (entType == EntityType.AGENT) {
            throw new IllegalArgumentException("Agent can't have and doesn't need a path completion!");
        }
        this.completions.put(entType, null);
        if (resetToDefaults) {
            switch (entType) {
                case ORG_POSITION: {
                    this.setCompletionsFor(EntityType.ORG_POSITION, EntityType.ORG_POSITION.getNavFunction("getAgents"));
                    break;
                }
                case ORG_UNIT: {
                    this.setCompletionsFor(EntityType.ORG_UNIT, EntityType.ORG_UNIT.getNavFunction("getOrgPositions"));
                    break;
                }
                case ORG_GROUP: {
                    this.setCompletionsFor(EntityType.ORG_GROUP, EntityType.ORG_GROUP.getNavFunction("getOrgUnits"));
                    break;
                }
                case PROJECT_GROUP: {
                    this.setCompletionsFor(EntityType.PROJECT_GROUP, EntityType.PROJECT_GROUP.getNavFunction("getOrgUnits"), EntityType.PROJECT_GROUP.getNavFunction("getOrgPositions"));
                    break;
                }
                case ABILITY: {
                    this.setCompletionsFor(EntityType.ABILITY, EntityType.ABILITY.getNavFunction("getRoles"), EntityType.ABILITY.getNavFunction("getAgents"));
                    break;
                }
                case ROLE: {
                    this.setCompletionsFor(EntityType.ROLE, EntityType.ROLE.getNavFunction("getOrgPositions"));
                    break;
                }
                case SUBSTITUTION_RULE: {
                    this.setCompletionsFor(EntityType.SUBSTITUTION_RULE, EntityType.SUBSTITUTION_RULE.getNavFunction("getSubstitute"));
                    break;
                }
                default: {
                    System.err.println("There's no default path completion defined for " + (Object)((Object)entType) + "!");
                }
            }
        }
    }

    public PathCompletion clone() {
        try {
            PathCompletion clone = (PathCompletion)super.clone();
            clone.completions = new HashMap<EntityType, NavFunction[]>(this.completions);
            return clone;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error();
        }
    }
}

