/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.orgmodel;

import de.aristaflow.adept2.model.orgmodel.EntityType;
import de.aristaflow.adept2.util.NullArgumentException;

public enum RelationType {
    ORG_POSITION_OCCUPATION(EntityType.ORG_POSITION, EntityType.AGENT),
    ORG_POSITION_DESCRIPTION(EntityType.ORG_POSITION, EntityType.ROLE),
    ORG_POSITION_AFFILIATION(EntityType.ORG_UNIT, EntityType.ORG_POSITION, "orgUnitId"),
    ORG_UNIT_SUBORDINATION(EntityType.ORG_UNIT, EntityType.ORG_UNIT, "supId"),
    ORG_UNIT_MANAGEMENT(EntityType.ORG_POSITION, EntityType.ORG_UNIT, "managerId"),
    ORG_GROUP_MANAGEMENT(EntityType.ORG_POSITION, EntityType.ORG_GROUP, "managerId"),
    ORG_GROUP_INVOLVEMENT(EntityType.ORG_GROUP, EntityType.ORG_UNIT),
    PROJECT_GROUP_SUBORDINATION(EntityType.PROJECT_GROUP, EntityType.PROJECT_GROUP, "supId"),
    PROJECT_GROUP_MANAGEMENT(EntityType.ORG_POSITION, EntityType.PROJECT_GROUP, "managerId"),
    PROJECT_INVOLVEMENT_ORG_POSITION(EntityType.PROJECT_GROUP, EntityType.ORG_POSITION),
    PROJECT_INVOLVEMENT_ORG_UNIT(EntityType.PROJECT_GROUP, EntityType.ORG_UNIT),
    AGENT_ABILITY(EntityType.AGENT, EntityType.ABILITY),
    ROLE_DESCRIPTION(EntityType.ROLE, EntityType.ABILITY),
    ROLE_SPECIALISATION(EntityType.ROLE, EntityType.ROLE, "supId"),
    ORG_POSITION_SUBSTITUTION(EntityType.ORG_POSITION, EntityType.SUBSTITUTION_RULE, "orgPositionId"),
    ORG_POSITION_SUBSTITUTE(EntityType.ORG_POSITION, EntityType.SUBSTITUTION_RULE, "substituteId"),
    ROLE_SUBSTITUTION(EntityType.ROLE, EntityType.SUBSTITUTION_RULE, "roleId");

    private final EntityType leftHandEntityType;
    private final EntityType rightHandEntityType;
    private final String refAttribute;

    private RelationType(EntityType leftHandEntityType, EntityType rightHandEntityType) {
        this.leftHandEntityType = leftHandEntityType;
        this.rightHandEntityType = rightHandEntityType;
        this.refAttribute = null;
    }

    private RelationType(EntityType leftHandEntityType, EntityType rightHandEntityType, String oneToMReferenceAttribute) {
        if (oneToMReferenceAttribute == null) {
            throw new NullArgumentException();
        }
        this.leftHandEntityType = leftHandEntityType;
        this.rightHandEntityType = rightHandEntityType;
        this.refAttribute = oneToMReferenceAttribute;
    }

    public EntityType leftHandEntityType() {
        return this.leftHandEntityType;
    }

    public EntityType rightHandEntityType() {
        return this.rightHandEntityType;
    }

    public boolean isNMRelation() {
        return this.refAttribute == null;
    }

    public String oneToMReferenceAttribute() {
        if (this.isNMRelation()) {
            throw new IllegalStateException("You must not call this method on an n:m relation type!");
        }
        return this.refAttribute;
    }

    public boolean isRecursive() {
        return this.leftHandEntityType == this.rightHandEntityType;
    }
}

