/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.processmodel;

import de.aristaflow.adept2.model.globals.ProcessConstants;
import java.util.UUID;

public class InvalidInstanceStateException
extends Exception {
    private static final long serialVersionUID = -1981342677936190982L;
    protected final UUID instanceID;
    protected final ProcessConstants.InstanceExecutionStatus executionState;
    protected final ProcessConstants.InstanceMigrationStatus migrationState;
    protected final boolean migrationPrevents;

    public InvalidInstanceStateException(UUID instanceID, ProcessConstants.InstanceExecutionStatus currentExecutionState, String message) {
        this(instanceID, currentExecutionState, null, false, message);
    }

    public InvalidInstanceStateException(UUID instanceID, ProcessConstants.InstanceMigrationStatus currentMigrationState, String message) {
        this(instanceID, null, currentMigrationState, true, message);
    }

    protected InvalidInstanceStateException(UUID instanceID, ProcessConstants.InstanceExecutionStatus currentExecutionState, ProcessConstants.InstanceMigrationStatus currentMigrationState, boolean migrationPrevents, String message) {
        super(message);
        this.instanceID = instanceID;
        this.executionState = currentExecutionState;
        this.migrationState = currentMigrationState;
        this.migrationPrevents = migrationPrevents;
    }

    public UUID getInstanceID() {
        return this.instanceID;
    }

    public ProcessConstants.InstanceExecutionStatus getInstanceExecutionStatus() {
        return this.executionState;
    }

    public ProcessConstants.InstanceMigrationStatus getInstanceMigrationStatus() {
        return this.migrationState;
    }

    public String getPreventingState() {
        return this.migrationPrevents ? this.migrationState.name() : this.executionState.name();
    }
}

