/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.processmodel.defaultimplementation;

import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.model.common.PluginData;
import de.aristaflow.adept2.model.common.PluginDataContainer;
import de.aristaflow.adept2.model.common.UserAttributeContainer;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.ChangeableInstance;
import de.aristaflow.adept2.model.processmodel.ChangeableTemplate;
import de.aristaflow.adept2.model.processmodel.ConstraintEdge;
import de.aristaflow.adept2.model.processmodel.DataEdge;
import de.aristaflow.adept2.model.processmodel.DataElement;
import de.aristaflow.adept2.model.processmodel.Edge;
import de.aristaflow.adept2.model.processmodel.ExecutableBusinessProcess;
import de.aristaflow.adept2.model.processmodel.InstanceDeltaLayer;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.ProcessModelParameter;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.defaultimplementation.DefaultInstance;
import de.aristaflow.adept2.model.processmodel.defaultimplementation.DefaultProcessModelFactory;
import de.aristaflow.adept2.model.processmodel.tools.ProcessModelTools;
import de.aristaflow.adept2.util.UUIDTools;
import java.util.Set;
import java.util.UUID;

public class DefaultChangeableInstance
extends DefaultInstance
implements ChangeableInstance {
    private static final long serialVersionUID = 4696422203691862549L;

    DefaultChangeableInstance(Template template, UUID logID, UUID baseTemplateID, long creationTime) {
        super(template, logID, baseTemplateID, creationTime);
    }

    private Template getOrCreateInstanceDeltaLayer() {
        if (this.modified) {
            if (!(this.template instanceof ChangeableTemplate)) {
                ChangeableTemplate changeableTemplate = this.createChangeableTemplate(this.template);
                this.setModified(true);
                this.template = changeableTemplate;
            }
            return this.template;
        }
        ChangeableTemplate changeableTemplate = this.createChangeableTemplate(this.template);
        this.setModified(true);
        this.template = changeableTemplate;
        return this.template;
    }

    private ChangeableTemplate createChangeableTemplate(Template normalTemplate) {
        DefaultProcessModelFactory factory = new DefaultProcessModelFactory(null);
        factory.setCreateChangeable(true);
        ChangeableTemplate newTemplate = (ChangeableTemplate)ProcessModelTools.cloneTemplate(normalTemplate, factory);
        if (!this.isModified()) {
            newTemplate.updateID(UUIDTools.createNegativeRandomUUID());
        }
        return newTemplate;
    }

    @Override
    public void setSupervisorAgent(QualifiedAgent supervisorAgentID) {
        super.setSupervisorAgent(supervisorAgentID);
    }

    @Override
    public void setName(String name) {
        super.setName(name);
    }

    @Override
    public void setInputParameters(Set<ProcessModelParameter> inputParameters) {
        ChangeableTemplate deltaLayer = (ChangeableTemplate)this.getOrCreateInstanceDeltaLayer();
        deltaLayer.setInputParameters(inputParameters);
    }

    @Override
    public void setOutputParameters(Set<ProcessModelParameter> outputParameters) {
        ChangeableTemplate deltaLayer = (ChangeableTemplate)this.getOrCreateInstanceDeltaLayer();
        deltaLayer.setOutputParameters(outputParameters);
    }

    public void changeInitiatorAgent(QualifiedAgent newInitiatorAgent) {
        super.setInitiatorAgent(newInitiatorAgent);
    }

    @Override
    public void setNodeIteration(int nodeID, int iteration) {
        super.setNodeIteration(nodeID, iteration);
    }

    @Override
    public void setNodeState(int nodeID, ProcessConstants.NodeState state) {
        super.setNodeState(nodeID, state);
    }

    @Override
    public InstanceDeltaLayer getDeltaLayer() {
        throw new RuntimeException("Delta Layer concept not yet implemented, so do not use this method");
    }

    @Override
    public DataEdge addDataEdge(int node, int connector, int dataElement, DataEdge dataEdge) {
        ChangeableTemplate deltaLayer = (ChangeableTemplate)this.getOrCreateInstanceDeltaLayer();
        return deltaLayer.addDataEdge(node, connector, dataElement, dataEdge);
    }

    @Override
    public DataEdge addDataEdge(int node, int dataElement, DataEdge dataEdge) {
        ChangeableTemplate deltaLayer = (ChangeableTemplate)this.getOrCreateInstanceDeltaLayer();
        return deltaLayer.addDataEdge(node, dataElement, dataEdge);
    }

    @Override
    public DataElement addDataElement(DataElement dataElement) {
        ChangeableTemplate deltaLayer = (ChangeableTemplate)this.getOrCreateInstanceDeltaLayer();
        return deltaLayer.addDataElement(dataElement);
    }

    @Override
    public void addDisabledConnector(int nodeID, int connectorID) {
        ChangeableTemplate deltaLayer = (ChangeableTemplate)this.getOrCreateInstanceDeltaLayer();
        deltaLayer.addDisabledConnector(nodeID, connectorID);
    }

    @Override
    public Edge addEdge(int srcNodeID, int destNodeID, Edge edge) {
        ChangeableTemplate deltaLayer = (ChangeableTemplate)this.getOrCreateInstanceDeltaLayer();
        return deltaLayer.addEdge(srcNodeID, destNodeID, edge);
    }

    @Override
    public ConstraintEdge addConstraintEdge(int srcNodeID, int destNodeID, ConstraintEdge edge) {
        ChangeableTemplate deltaLayer = (ChangeableTemplate)this.getOrCreateInstanceDeltaLayer();
        return deltaLayer.addConstraintEdge(srcNodeID, destNodeID, edge);
    }

    @Override
    public void addMovedNode(int node) {
        ChangeableTemplate deltaLayer = (ChangeableTemplate)this.getOrCreateInstanceDeltaLayer();
        deltaLayer.addMovedNode(node);
    }

    @Override
    public Node addNode(Node node) {
        ChangeableTemplate deltaLayer = (ChangeableTemplate)this.getOrCreateInstanceDeltaLayer();
        Node newNode = deltaLayer.addNode(node);
        this.setNodeState(newNode.getID(), ProcessConstants.NodeState.NS_NOT_ACTIVATED);
        this.setNodeIteration(newNode.getID(), 0);
        return newNode;
    }

    @Override
    public void endTransaction() {
        ChangeableTemplate deltaLayer = (ChangeableTemplate)this.getOrCreateInstanceDeltaLayer();
        deltaLayer.endTransaction();
    }

    @Override
    public void reMapDataElement(int dataElementID, int nodeID, ActivityConstants.AccessType type, String parameterName) {
        ChangeableTemplate deltaLayer = (ChangeableTemplate)this.getOrCreateInstanceDeltaLayer();
        deltaLayer.reMapDataElement(dataElementID, nodeID, type, parameterName);
    }

    @Override
    public void removeDataEdge(int node, int dataElement, ActivityConstants.AccessType dataEdgeType) {
        ChangeableTemplate deltaLayer = (ChangeableTemplate)this.getOrCreateInstanceDeltaLayer();
        deltaLayer.removeDataEdge(node, dataElement, dataEdgeType);
    }

    @Override
    public void removeDataElement(int dataElementID) {
        ChangeableTemplate deltaLayer = (ChangeableTemplate)this.getOrCreateInstanceDeltaLayer();
        deltaLayer.removeDataElement(dataElementID);
    }

    @Override
    public void removeDisabledConnector(int nodeID, int connectorID) {
        ChangeableTemplate deltaLayer = (ChangeableTemplate)this.getOrCreateInstanceDeltaLayer();
        deltaLayer.removeDisabledConnector(nodeID, connectorID);
    }

    @Override
    public void removeEdge(int srcNodeID, int destNodeID, ProcessConstants.EdgeType edgeType) {
        ChangeableTemplate deltaLayer = (ChangeableTemplate)this.getOrCreateInstanceDeltaLayer();
        deltaLayer.removeEdge(srcNodeID, destNodeID, edgeType);
    }

    @Override
    public void removeConstraintEdge(int srcNodeID, int destNodeID) {
        ChangeableTemplate deltaLayer = (ChangeableTemplate)this.getOrCreateInstanceDeltaLayer();
        deltaLayer.removeConstraintEdge(srcNodeID, destNodeID);
    }

    @Override
    public void removeNode(int nodeID) {
        ChangeableTemplate deltaLayer = (ChangeableTemplate)this.getOrCreateInstanceDeltaLayer();
        deltaLayer.removeNode(nodeID);
        this.nodeState.remove(nodeID);
    }

    @Override
    public void removeUserAttribute(UserAttributeContainer container, String name) {
        ChangeableTemplate deltaLayer = (ChangeableTemplate)this.getOrCreateInstanceDeltaLayer();
        deltaLayer.removeUserAttribute(container, name);
    }

    @Override
    public void setBranchID(int startNodeID, int endNodeID, boolean newIDNecessary, int existingID) {
        ChangeableTemplate deltaLayer = (ChangeableTemplate)this.getOrCreateInstanceDeltaLayer();
        deltaLayer.setBranchID(startNodeID, endNodeID, newIDNecessary, existingID);
    }

    @Override
    public void setCorrespondingBlockNode(int split, int join) {
        ChangeableTemplate deltaLayer = (ChangeableTemplate)this.getOrCreateInstanceDeltaLayer();
        deltaLayer.setCorrespondingBlockNode(split, join);
    }

    @Override
    public void setSplitNodeID(int startNodeID, int endNodeID, int splitNodeID) {
        ChangeableTemplate deltaLayer = (ChangeableTemplate)this.getOrCreateInstanceDeltaLayer();
        deltaLayer.setSplitNodeID(startNodeID, endNodeID, splitNodeID);
    }

    @Override
    public void startTransaction() {
        ChangeableTemplate deltaLayer = (ChangeableTemplate)this.getOrCreateInstanceDeltaLayer();
        deltaLayer.startTransaction();
    }

    @Override
    public DataEdge updateDataEdge(int nodeID, int dataElementID, ActivityConstants.AccessType accessType, DataEdge dataEdge, ProcessConstants.DataEdgeProperty ... dataEdgeProperties) {
        ChangeableTemplate deltaLayer = (ChangeableTemplate)this.getOrCreateInstanceDeltaLayer();
        return deltaLayer.updateDataEdge(nodeID, dataElementID, accessType, dataEdge, dataEdgeProperties);
    }

    @Override
    public DataElement updateDataElement(DataElement dataElement, ProcessConstants.DataElementProperty ... dataElementProperties) {
        ChangeableTemplate deltaLayer = (ChangeableTemplate)this.getOrCreateInstanceDeltaLayer();
        return deltaLayer.updateDataElement(dataElement, dataElementProperties);
    }

    @Override
    public Edge updateEdge(int srcNodeID, int destNodeID, Edge edge, ProcessConstants.EdgeProperty ... edgeProperty) {
        ChangeableTemplate deltaLayer = (ChangeableTemplate)this.getOrCreateInstanceDeltaLayer();
        return deltaLayer.updateEdge(srcNodeID, destNodeID, edge, edgeProperty);
    }

    @Override
    public void updateExecutableBusinessProcess(int nodeID, ExecutableBusinessProcess ebp, ProcessConstants.ExecutableBusinessProcessProperty ... ebpProperties) {
        ChangeableTemplate deltaLayer = (ChangeableTemplate)this.getOrCreateInstanceDeltaLayer();
        deltaLayer.updateExecutableBusinessProcess(nodeID, ebp, ebpProperties);
    }

    @Override
    public Node updateNode(Node node, ProcessConstants.NodeProperty ... nodeProperties) {
        ChangeableTemplate deltaLayer = (ChangeableTemplate)this.getOrCreateInstanceDeltaLayer();
        return deltaLayer.updateNode(node, nodeProperties);
    }

    @Override
    public void updateUserAttribute(UserAttributeContainer container, String name, String value) {
        ChangeableTemplate deltaLayer = (ChangeableTemplate)this.getOrCreateInstanceDeltaLayer();
        deltaLayer.updateUserAttribute(container, name, value);
    }

    @Override
    public void setNodeType(int nodeID, ProcessConstants.NodeType type) {
        ChangeableTemplate deltaLayer = (ChangeableTemplate)this.getOrCreateInstanceDeltaLayer();
        deltaLayer.setNodeType(nodeID, type);
    }

    @Override
    public void updatePluginDataContainer(PluginDataContainer pluginContainer, String extensionPointID, String pluginDataID, PluginData pluginData) {
        ChangeableTemplate deltaLayer = (ChangeableTemplate)this.getOrCreateInstanceDeltaLayer();
        deltaLayer.updatePluginDataContainer(pluginContainer, extensionPointID, pluginDataID, pluginData);
    }
}

