/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.processmodel.defaultimplementation;

import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.model.common.ActivityConfiguration;
import de.aristaflow.adept2.model.common.Configuration;
import de.aristaflow.adept2.model.common.ConfigurationDescription;
import de.aristaflow.adept2.model.common.PluginData;
import de.aristaflow.adept2.model.common.PluginDataContainer;
import de.aristaflow.adept2.model.common.UserAttributeContainer;
import de.aristaflow.adept2.model.common.defaultimplementation.DefaultPluginDataContainer;
import de.aristaflow.adept2.model.common.defaultimplementation.DefaultUserAttributeContainer;
import de.aristaflow.adept2.model.common.defaultimplementation.SerialisablePluginDataContainer;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.Activity;
import de.aristaflow.adept2.model.processmodel.ChangeableTemplate;
import de.aristaflow.adept2.model.processmodel.ConstraintEdge;
import de.aristaflow.adept2.model.processmodel.DataEdge;
import de.aristaflow.adept2.model.processmodel.DataElement;
import de.aristaflow.adept2.model.processmodel.DecisionActivity;
import de.aristaflow.adept2.model.processmodel.DecisionStatement;
import de.aristaflow.adept2.model.processmodel.Edge;
import de.aristaflow.adept2.model.processmodel.EmbeddedProcess;
import de.aristaflow.adept2.model.processmodel.ExecutableBusinessProcess;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.ProcessModelFactory;
import de.aristaflow.adept2.model.processmodel.ProcessModelParameter;
import de.aristaflow.adept2.model.processmodel.ReferencedProcess;
import de.aristaflow.adept2.model.processmodel.StructuredConstraintEdge;
import de.aristaflow.adept2.model.processmodel.StructuredDataEdge;
import de.aristaflow.adept2.model.processmodel.StructuredEdge;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.VariableParallelismEBP;
import de.aristaflow.adept2.model.processmodel.defaultimplementation.DefaultActivity;
import de.aristaflow.adept2.model.processmodel.defaultimplementation.DefaultConstraintEdge;
import de.aristaflow.adept2.model.processmodel.defaultimplementation.DefaultDataEdge;
import de.aristaflow.adept2.model.processmodel.defaultimplementation.DefaultDataElement;
import de.aristaflow.adept2.model.processmodel.defaultimplementation.DefaultDecisionActivity;
import de.aristaflow.adept2.model.processmodel.defaultimplementation.DefaultEdge;
import de.aristaflow.adept2.model.processmodel.defaultimplementation.DefaultEmbeddedProcess;
import de.aristaflow.adept2.model.processmodel.defaultimplementation.DefaultNode;
import de.aristaflow.adept2.model.processmodel.defaultimplementation.DefaultReferencedProcess;
import de.aristaflow.adept2.model.processmodel.defaultimplementation.DefaultStructuralNodeData;
import de.aristaflow.adept2.model.processmodel.defaultimplementation.DefaultStructuredConstraintEdge;
import de.aristaflow.adept2.model.processmodel.defaultimplementation.DefaultStructuredDataEdge;
import de.aristaflow.adept2.model.processmodel.defaultimplementation.DefaultStructuredEdge;
import de.aristaflow.adept2.model.processmodel.defaultimplementation.DefaultTemplate;
import de.aristaflow.adept2.model.processmodel.defaultimplementation.DefaultVariableParallelismEBP;
import de.aristaflow.adept2.model.processmodel.tools.ProcessGraphPredicates;
import de.aristaflow.adept2.model.processmodel.tools.ProcessModelTools;
import de.aristaflow.adept2.util.LoggerTools;
import de.aristaflow.adept2.util.NullArgumentException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class DefaultChangeableTemplate
extends DefaultTemplate
implements ChangeableTemplate {
    private static final long serialVersionUID = -7726691897243315064L;
    protected boolean transactionStarted = false;
    protected int maxDataElementID = 0;
    protected int maxNodeID = 0;
    protected int maxBranchID = 0;

    public DefaultChangeableTemplate(UUID id, String name, String description, ConfigurationDescription configurationDescription, Configuration configuration, Configuration testConfiguration) {
        super(id, name, description, configurationDescription, configuration, testConfiguration);
    }

    @Deprecated
    public DefaultChangeableTemplate() {
    }

    @Override
    public void updateID(UUID newID) {
        if (newID == null) {
            throw new NullArgumentException("The new ID must not be null.");
        }
        for (Node node : this.getNodes()) {
            ExecutableBusinessProcess ebp = node.getExecutableBusinessProcess();
            if (ebp instanceof VariableParallelismEBP) {
                ebp = ((VariableParallelismEBP)ebp).getLightWeightProcess();
            }
            if (!(ebp instanceof EmbeddedProcess)) continue;
            EmbeddedProcess p = (EmbeddedProcess)ebp;
            if (p.getTemplate() instanceof ChangeableTemplate) {
                ((ChangeableTemplate)p.getTemplate()).updateID(newID);
                continue;
            }
            throw new RuntimeException("Updating of template ID not possible due to unchangeable embedded templates.");
        }
        this.setID(newID);
    }

    @Override
    public void setCorrespondingBlockNode(int nodeID, int correspondingNodeID) {
        super.setCorrespondingBlockNode(nodeID, correspondingNodeID);
    }

    @Override
    public DataElement addDataElement(DataElement dataElement) {
        if (dataElement == null) {
            throw new IllegalArgumentException("DataElement is null");
        }
        if (dataElement.getName() == null || dataElement.getDataType() == null || dataElement.getDescription() == null) {
            throw new IllegalArgumentException("Invalid DataElement " + dataElement);
        }
        DefaultDataElement newElement = new DefaultDataElement(this.maxDataElementID++, dataElement.getName(), dataElement.getDataType(), dataElement.getUDTName(), dataElement.getDescription(), dataElement.getIconID(), dataElement.getIdentifierID(), dataElement.isPublic(), dataElement.isVirtual(), dataElement.getSupportedPlugins(), dataElement.getPluginDatas(), dataElement.getUserAttributes());
        assert (!this.dataElements.containsKey(dataElement.getID()));
        this.dataElements.put(newElement.getID(), newElement);
        return newElement;
    }

    @Override
    public void startTransaction() {
        if (this.transactionStarted) {
            throw new RuntimeException("Can't start transaction: Transaction already started.");
        }
        this.transactionStarted = true;
    }

    @Override
    public void endTransaction() {
        if (!this.transactionStarted) {
            throw new RuntimeException("Can't end transaction: No transaction was started.");
        }
        Map<Integer, Integer> topologicalMapping = DefaultChangeableTemplate.returnTopologicalSorting(this);
        this.topIDToNodeID = new int[topologicalMapping.size()];
        for (Map.Entry<Integer, Integer> mapping : topologicalMapping.entrySet()) {
            DefaultStructuralNodeData sNode = (DefaultStructuralNodeData)this.nodeStructure.get(mapping.getKey());
            Integer topoID = mapping.getValue();
            sNode.setTopologicalID(topoID);
            this.topIDToNodeID[topoID.intValue()] = mapping.getKey();
        }
        this.transactionStarted = false;
    }

    @Override
    public boolean isTransPredOf(int currentNodeID, int potentialPredecessorID, ProcessConstants.EdgeType ... edgeType) {
        if (edgeType.length > 2) {
            throw new IllegalArgumentException("Edge type combination not supported");
        }
        ProcessConstants.EdgeType[] edgeTypeArray = edgeType;
        int n = edgeType.length;
        int n2 = 0;
        while (n2 < n) {
            ProcessConstants.EdgeType e = edgeTypeArray[n2];
            if (!e.equals((Object)ProcessConstants.EdgeType.ET_CONTROL) && !e.equals((Object)ProcessConstants.EdgeType.ET_SYNC)) {
                throw new IllegalArgumentException("Edge type not supported");
            }
            ++n2;
        }
        if (this.transactionStarted) {
            Set<Integer> transPreds;
            if (edgeType.length == 1 && edgeType[0].equals((Object)ProcessConstants.EdgeType.ET_CONTROL)) {
                transPreds = ProcessGraphPredicates.c_pred_trans(this, currentNodeID);
                return transPreds.contains(potentialPredecessorID);
            }
            transPreds = ProcessGraphPredicates.pred_trans(this, currentNodeID);
            return transPreds.contains(potentialPredecessorID);
        }
        return super.isTransPredOf(currentNodeID, potentialPredecessorID, edgeType);
    }

    @Override
    public int[] getNodeIDsInArea(int first, int last, boolean includeBlocks) {
        return ProcessModelTools.getNodesInArea(first, last, includeBlocks, this, this.transactionStarted);
    }

    @Override
    public Node updateNode(Node node, ProcessConstants.NodeProperty ... nodeProperties) {
        ProcessConstants.NodeProperty property;
        if (node == null) {
            throw new IllegalArgumentException("Node is null");
        }
        if (!this.nodes.containsKey(node.getID())) {
            throw new IllegalArgumentException("Invalid node ID: " + node.getID());
        }
        DefaultNode realNode = (DefaultNode)this.nodes.get(node.getID());
        ProcessConstants.NodeProperty[] nodePropertyArray = nodeProperties;
        int n = nodeProperties.length;
        int n2 = 0;
        while (n2 < n) {
            property = nodePropertyArray[n2];
            switch (property) {
                case NAME: {
                    if (node.getName() != null) break;
                    throw new IllegalArgumentException("Invalid node property: Name is null!");
                }
                case EXECUTABLE_BUSINESS_PROCESS: 
                case AUTO_START: {
                    break;
                }
                case CONNECTOR_PARAMETER_MAPPING: {
                    throw new IllegalArgumentException("Node property " + (Object)((Object)property) + " can't be changed directly. " + "Is updated implicitly with " + "EXECUTABLE_BUSINESS_PROCESS");
                }
                case DESCRIPTION: {
                    if (node.getDescription() != null) break;
                    throw new IllegalArgumentException("Invalid node property: Description is null!");
                }
                case STAFF_ASSIGNMENT_RULE: {
                    if (node.getStaffAssignmentRule() != null) break;
                    throw new IllegalArgumentException("Invalid Node Property: StaffAssignmentRule is null");
                }
                case SYSTEM_READ_PARAMS: {
                    if (node.getSystemParameters(ActivityConstants.AccessType.SYSTEM_READ) != null) break;
                    throw new IllegalArgumentException("Invalid Node Property: System Read Parameters are null");
                }
                case SYSTEM_WRITE_PARAMS: {
                    if (node.getSystemParameters(ActivityConstants.AccessType.SYSTEM_WRITE) != null) break;
                    throw new IllegalArgumentException("Invalid Node Property: System Write Parameters are null");
                }
                default: {
                    throw new IllegalArgumentException("Node property " + (Object)((Object)property) + " can not be changed!");
                }
            }
            ++n2;
        }
        nodePropertyArray = nodeProperties;
        n = nodeProperties.length;
        n2 = 0;
        while (n2 < n) {
            property = nodePropertyArray[n2];
            switch (property) {
                case NAME: {
                    realNode.setName(node.getName());
                    break;
                }
                case EXECUTABLE_BUSINESS_PROCESS: {
                    realNode.setExecutableBusinessProcess(node.getExecutableBusinessProcess());
                    realNode.readingParameterConnectorMap = new HashMap<String, Integer>(node.getConnectorMapping(ActivityConstants.AccessType.READ));
                    realNode.writingParameterConnectorMap = new HashMap<String, Integer>(node.getConnectorMapping(ActivityConstants.AccessType.WRITE));
                    if (node.getExecutableBusinessProcess() != null) break;
                    this.nodeDisabledConnectors.remove(node.getID());
                    break;
                }
                case AUTO_START: {
                    realNode.setAutoStart(node.isAutoStartEnabled());
                    break;
                }
                case DESCRIPTION: {
                    realNode.setDescription(node.getDescription());
                    break;
                }
                case STAFF_ASSIGNMENT_RULE: {
                    realNode.setStaffAssignmentRule(node.getStaffAssignmentRule());
                    break;
                }
                case SYSTEM_READ_PARAMS: 
                case SYSTEM_WRITE_PARAMS: {
                    ActivityConstants.AccessType type = property == ProcessConstants.NodeProperty.SYSTEM_READ_PARAMS ? ActivityConstants.AccessType.SYSTEM_READ : ActivityConstants.AccessType.SYSTEM_WRITE;
                    LinkedList<ProcessModelParameter> deleteList = new LinkedList<ProcessModelParameter>();
                    for (ProcessModelParameter param : realNode.getSystemParameters(type)) {
                        if (node.getSystemParameters(type).contains(param)) continue;
                        deleteList.add(param);
                    }
                    for (ProcessModelParameter param : deleteList) {
                        realNode.removeSystemParameter(param.getName(), type);
                        realNode.unmapParameter(type, param.getName());
                    }
                    for (ProcessModelParameter param : node.getSystemParameters(type)) {
                        if (realNode.getSystemParameters(type).contains(param)) continue;
                        realNode.mapParameter(type, param.getName(), this.getFreeConnectorID(realNode.getID()));
                        realNode.addSystemParameter(type, param);
                    }
                    break;
                }
                default: {
                    throw new RuntimeException("Programming error: update method for " + (Object)((Object)property) + " is not implemented.");
                }
            }
            ++n2;
        }
        return realNode;
    }

    @Override
    public void removeNode(int nodeID) {
        Integer nodeInteger = nodeID;
        if (!this.nodes.containsKey(nodeInteger)) {
            throw new IllegalArgumentException("No node with this ID exists: " + nodeID);
        }
        this.nodes.remove(nodeInteger);
        this.nodeStructure.remove(nodeInteger);
        this.nodeDisabledConnectors.remove(nodeInteger);
    }

    @Override
    public void setNodeType(int nodeID, ProcessConstants.NodeType type) {
        super.setNodeType(nodeID, type);
    }

    @Override
    public void setBranchID(int startNodeID, int endNodeID, boolean newIDNecessary, int existingID) {
        int n;
        if (startNodeID == this.startNodeID || endNodeID == this.endNodeID) {
            throw new IllegalArgumentException("Setting the branchID of start and/or end flow nodes is not allowed");
        }
        if (newIDNecessary) {
            int n2 = this.maxBranchID;
            n = n2;
            this.maxBranchID = n2 + 1;
        } else {
            n = existingID;
        }
        int newBranchID = n;
        DefaultStructuralNodeData structuralNode = (DefaultStructuralNodeData)this.getStructureNode(startNodeID);
        structuralNode.setBranchID(newBranchID);
        while (structuralNode.getNodeID() != endNodeID) {
            structuralNode = (DefaultStructuralNodeData)this.nextNode(structuralNode);
            structuralNode.setBranchID(newBranchID);
        }
    }

    @Override
    public void setSplitNodeID(int startNodeID, int endNodeID, int newSplitNodeID) {
        if (startNodeID == this.startNodeID || endNodeID == this.endNodeID) {
            throw new IllegalArgumentException("Setting the branchID of start and/or end flow nodes is not allowed");
        }
        DefaultStructuralNodeData structuralNode = (DefaultStructuralNodeData)this.getStructureNode(startNodeID);
        ProcessModelFactory.StructuralNodeData endNode = this.getStructureNode(endNodeID);
        if (structuralNode.getBranchID() != endNode.getBranchID()) {
            throw new IllegalArgumentException("Start Node and end Node are not on the same Branch!");
        }
        structuralNode.setSplitNodeID(newSplitNodeID);
        while (structuralNode.getNodeID() != endNodeID) {
            structuralNode = (DefaultStructuralNodeData)this.nextNode(structuralNode);
            structuralNode.setSplitNodeID(newSplitNodeID);
        }
    }

    private ProcessModelFactory.StructuralNodeData nextNode(ProcessModelFactory.StructuralNodeData structuralNode) {
        ProcessConstants.NodeType type = this.getNodeType(structuralNode.getNodeID());
        if (type == ProcessConstants.NodeType.NT_AND_SPLIT || type == ProcessConstants.NodeType.NT_XOR_SPLIT || type == ProcessConstants.NodeType.NT_STARTLOOP) {
            return this.getStructureNode(structuralNode.getCorrespondingBlockNodeID());
        }
        Set<ProcessModelFactory.StructuralNodeData> succNode = this.getSuccStructureNodes(structuralNode.getNodeID(), ProcessConstants.EdgeType.ET_CONTROL);
        if (succNode.size() != 1) {
            throw new RuntimeException("Normal Node has more than one or no Control Edge");
        }
        return this.getStructureNode(succNode.iterator().next().getNodeID());
    }

    @Override
    public void reMapDataElement(int dataElementID, int nodeID, ActivityConstants.AccessType type, String parameterName) {
        if (this.getNode(nodeID).getExecutableBusinessProcess() == null) {
            throw new IllegalArgumentException("the node does not have an assigned EBP");
        }
        if (this.getDataEdge(nodeID, dataElementID, type) == null) {
            throw new IllegalArgumentException("Error: there is no data edge with the given type between the given data element and node, therefore the mapping between the data element and the connector of the node can't be changed");
        }
        int connID = this.getNode(nodeID).getConnector(parameterName, type);
        List disabledConnectors = (List)this.nodeDisabledConnectors.get(nodeID);
        if (disabledConnectors != null && disabledConnectors.contains(connID)) {
            throw new IllegalArgumentException("The Connector " + connID + " of the parameter is marked as disabled. To re-map the data element to this parameter is not allowed.");
        }
        DefaultStructuredDataEdge edge = (DefaultStructuredDataEdge)this.getStructuredDataEdge(nodeID, dataElementID, type);
        int connectorID = this.getNode(nodeID).getConnector(parameterName, type);
        edge.setConnectorID(connectorID);
    }

    @Override
    public void addDisabledConnector(int nodeID, int connectorID) {
        LinkedList<Integer> disabledIDs = (LinkedList<Integer>)this.nodeDisabledConnectors.get(nodeID);
        if (disabledIDs == null) {
            disabledIDs = new LinkedList<Integer>();
            this.nodeDisabledConnectors.put(nodeID, disabledIDs);
            disabledIDs.add(connectorID);
        } else if (!disabledIDs.contains(connectorID)) {
            disabledIDs.add(connectorID);
        }
    }

    @Override
    public void removeDisabledConnector(int nodeID, int connectorID) {
        List disabledIDs = (List)this.nodeDisabledConnectors.get(nodeID);
        if (disabledIDs != null && disabledIDs.contains(connectorID)) {
            disabledIDs.remove((Object)connectorID);
            if (disabledIDs.size() == 0) {
                this.nodeDisabledConnectors.remove(nodeID);
            }
        }
    }

    @Override
    public void updateExecutableBusinessProcess(int nodeID, ExecutableBusinessProcess ebp, ProcessConstants.ExecutableBusinessProcessProperty ... ebpProperties) {
        if (ebp == null) {
            throw new NullArgumentException();
        }
        DefaultNode node = (DefaultNode)this.nodes.get(nodeID);
        if (node == null) {
            throw new IllegalArgumentException("Invalid node ID: " + nodeID);
        }
        ExecutableBusinessProcess orgEBP = node.getExecutableBusinessProcess();
        if (orgEBP == null) {
            throw new IllegalArgumentException("This node does not have an ExecutableBusinessProcess!");
        }
        ProcessConstants.ExecutableBusinessProcessProperty[] executableBusinessProcessPropertyArray = ebpProperties;
        int n = ebpProperties.length;
        int n2 = 0;
        while (n2 < n) {
            ProcessConstants.ExecutableBusinessProcessProperty property = executableBusinessProcessPropertyArray[n2];
            switch (property) {
                case CONFIGURATION: {
                    if (ebp.getConfiguration() != null) break;
                    throw new IllegalArgumentException("Invalid ExecutableBusinessProcess Property: Configuration is null");
                }
                case TEST_CONFIGURATION: {
                    if (ebp.getTestConfiguration() != null) break;
                    throw new IllegalArgumentException("Invalid ExecutableBusinessProcess Property: TestConfiguration is null");
                }
                case CONFIGURATION_NAME: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Property " + (Object)((Object)property) + " of EBP can not be changed");
                }
            }
            ++n2;
        }
        String configurationName = null;
        if (orgEBP instanceof Activity) {
            Activity origAct = (Activity)orgEBP;
            configurationName = origAct.getConfigurationName();
        }
        Configuration configuration = orgEBP.getConfiguration();
        Configuration testConfiguration = orgEBP.getTestConfiguration();
        ProcessConstants.ExecutableBusinessProcessProperty[] executableBusinessProcessPropertyArray2 = ebpProperties;
        int n3 = ebpProperties.length;
        int n4 = 0;
        while (n4 < n3) {
            ProcessConstants.ExecutableBusinessProcessProperty property = executableBusinessProcessPropertyArray2[n4];
            switch (property) {
                case CONFIGURATION: {
                    configuration = ebp.getConfiguration();
                    break;
                }
                case TEST_CONFIGURATION: {
                    testConfiguration = ebp.getTestConfiguration();
                    break;
                }
                case CONFIGURATION_NAME: {
                    configurationName = ((Activity)ebp).getConfigurationName();
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            ++n4;
        }
        SerialisablePluginDataContainer newEBP = null;
        if (orgEBP instanceof Activity) {
            Activity act = (Activity)orgEBP;
            newEBP = new DefaultActivity(act.getType(), act.getID(), act.getExecutableComponentName(), act.getOperationName(), configurationName, act.getActivityName(), act.getDescription(), act.getImplementationClass(), act.getSeparatedClassPaths(), act.isSingleton(), act.getSystemComponent(), act.getGUIContextID(), act.getExecutionControlProperties(), act.supportsViewOnly(), act.supportsTestExecution(), act.getIconID(), act.getAttributeOrigins(), (ActivityConfiguration)configuration, (ActivityConfiguration)testConfiguration, act.getParameterChangePolicy(), act.getParameters(ActivityConstants.AccessType.READ), act.getParameters(ActivityConstants.AccessType.WRITE), act, act.getUserAttributes());
            if (orgEBP instanceof DecisionActivity) {
                DecisionActivity dec = (DecisionActivity)act;
                HashMap<Long, Collection<DecisionStatement>> decisionMapping = new HashMap<Long, Collection<DecisionStatement>>();
                for (DecisionStatement ds : dec.getAllDecisionStatements()) {
                    long edgeCode = dec.getEdgeCode(ds.getDecisionID());
                    HashSet<DecisionStatement> col = (HashSet<DecisionStatement>)decisionMapping.get(edgeCode);
                    if (col == null) {
                        col = new HashSet<DecisionStatement>();
                    }
                    col.add(ds);
                    decisionMapping.put(edgeCode, col);
                }
                newEBP = new DefaultDecisionActivity((Activity)((Object)newEBP), dec.getDecisionParameter(), decisionMapping);
            }
        } else if (orgEBP instanceof ReferencedProcess) {
            newEBP = new DefaultReferencedProcess(orgEBP.getExecutionControlProperties(), configuration, testConfiguration, orgEBP.getParameters(ActivityConstants.AccessType.READ), orgEBP.getParameters(ActivityConstants.AccessType.WRITE), orgEBP, orgEBP.getUserAttributes());
            newEBP.setTemplateID(((ReferencedProcess)orgEBP).getTemplateID());
            newEBP.setFork(((ReferencedProcess)orgEBP).fork());
        } else if (orgEBP instanceof EmbeddedProcess) {
            newEBP = new DefaultEmbeddedProcess(orgEBP.getExecutionControlProperties(), configuration, testConfiguration, orgEBP.getParameters(ActivityConstants.AccessType.READ), orgEBP.getParameters(ActivityConstants.AccessType.WRITE), orgEBP, orgEBP.getUserAttributes());
            ((DefaultEmbeddedProcess)newEBP).setTemplateID(((EmbeddedProcess)orgEBP).getTemplateID());
            ((DefaultEmbeddedProcess)newEBP).setTemplate(((EmbeddedProcess)orgEBP).getTemplate());
        } else if (orgEBP instanceof VariableParallelismEBP) {
            newEBP = new DefaultVariableParallelismEBP(orgEBP.getExecutionControlProperties(), configuration, testConfiguration, orgEBP.getParameters(ActivityConstants.AccessType.READ), orgEBP.getParameters(ActivityConstants.AccessType.WRITE), orgEBP, orgEBP.getUserAttributes());
            ((DefaultVariableParallelismEBP)newEBP).setLwp(((VariableParallelismEBP)orgEBP).getLightWeightProcess());
            ((DefaultVariableParallelismEBP)newEBP).setIndexedInputParameters(((VariableParallelismEBP)orgEBP).getIndexedInputParameters());
        }
        node.setExecutableBusinessProcess((ExecutableBusinessProcess)((Object)newEBP));
    }

    @Override
    public Edge addEdge(int srcNodeID, int destNodeID, Edge edge) {
        if (edge == null) {
            throw new NullArgumentException();
        }
        if (!this.nodes.containsKey(srcNodeID)) {
            throw new IllegalArgumentException("Start Node does not exist");
        }
        if (!this.nodes.containsKey(destNodeID)) {
            throw new IllegalArgumentException("End Node does not exist");
        }
        DefaultEdge newEdge = new DefaultEdge(edge.getType(), edge.getEdgeCode());
        newEdge.setUserAttributes(edge.getUserAttributes());
        DefaultStructuredEdge newStructuredEdge = new DefaultStructuredEdge(newEdge, srcNodeID, destNodeID);
        if (this.edges.contains(newStructuredEdge)) {
            throw new RuntimeException("Same Edge already exists!");
        }
        this.edges.add(newStructuredEdge);
        this.getEdgeSet(srcNodeID).add(newStructuredEdge);
        this.getEdgeSet(destNodeID).add(newStructuredEdge);
        return newEdge;
    }

    @Override
    public ConstraintEdge addConstraintEdge(int srcNodeID, int destNodeID, ConstraintEdge edge) {
        DefaultStructuredConstraintEdge newStructuredEdge;
        if (edge == null) {
            throw new NullArgumentException();
        }
        if (!this.nodes.containsKey(srcNodeID)) {
            throw new IllegalArgumentException("Start Node does not exist");
        }
        if (!this.nodes.containsKey(destNodeID)) {
            throw new IllegalArgumentException("End Node does not exist");
        }
        DefaultConstraintEdge newEdge = new DefaultConstraintEdge();
        newEdge.setUserAttributes(edge.getUserAttributes());
        if (edge.getSupportedPlugins() != null) {
            for (Map.Entry<String, Set<String>> pdcEntry : edge.getSupportedPlugins().entrySet()) {
                for (String pluginID : pdcEntry.getValue()) {
                    if (!edge.getPluginDatas().containsKey(pluginID)) continue;
                    newEdge.addSupportedPlugin(pdcEntry.getKey(), pluginID, edge.getPluginDatas().get(pluginID));
                }
            }
        }
        if (this.constraintEdges.contains(newStructuredEdge = new DefaultStructuredConstraintEdge(newEdge, srcNodeID, destNodeID))) {
            throw new RuntimeException("Same Edge already exists!");
        }
        this.constraintEdges.add(newStructuredEdge);
        this.getEdgeSet(srcNodeID).add(newStructuredEdge);
        this.getEdgeSet(destNodeID).add(newStructuredEdge);
        return newEdge;
    }

    @Override
    public Node addNode(Node node) {
        if (node == null) {
            throw new IllegalArgumentException("Node cannot be null");
        }
        if (node.getName() == null) {
            throw new IllegalArgumentException("Node Name cannot be null!");
        }
        HashMap<ActivityConstants.AccessType, HashMap<String, Integer>> parameterConnectorMapping = new HashMap<ActivityConstants.AccessType, HashMap<String, Integer>>();
        ActivityConstants.AccessType[] accessTypeArray = ActivityConstants.AccessType.values();
        int n = accessTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ActivityConstants.AccessType accessType = accessTypeArray[n2];
            parameterConnectorMapping.put(accessType, new HashMap<String, Integer>(node.getConnectorMapping(accessType)));
            ++n2;
        }
        HashMap<ActivityConstants.AccessType, Set<ProcessModelParameter>> nodeParameters = new HashMap<ActivityConstants.AccessType, Set<ProcessModelParameter>>();
        ActivityConstants.AccessType[] accessTypeArray2 = ActivityConstants.AccessType.systemRelatedValues();
        int n3 = accessTypeArray2.length;
        n = 0;
        while (n < n3) {
            ActivityConstants.AccessType accessType = accessTypeArray2[n];
            nodeParameters.put(accessType, node.getSystemParameters(accessType));
            ++n;
        }
        DefaultNode newNode = new DefaultNode(this.maxNodeID++, node.getName(), node.getDescription(), node.getStaffAssignmentRule());
        newNode.setIconID(node.getIconID());
        newNode.setExecutableBusinessProcess(node.getExecutableBusinessProcess());
        newNode.setAutoStart(node.isAutoStartEnabled());
        newNode.setUserAttributes(node.getUserAttributes());
        if (parameterConnectorMapping != null) {
            for (Map.Entry mapping : parameterConnectorMapping.entrySet()) {
                for (Map.Entry entry : ((Map)mapping.getValue()).entrySet()) {
                    newNode.mapParameter((ActivityConstants.AccessType)((Object)mapping.getKey()), (String)entry.getKey(), (Integer)entry.getValue());
                }
            }
        }
        if (nodeParameters != null) {
            for (Map.Entry entry : nodeParameters.entrySet()) {
                for (ProcessModelParameter param : (Set)entry.getValue()) {
                    newNode.addSystemParameter((ActivityConstants.AccessType)((Object)entry.getKey()), param);
                }
            }
        }
        if (node.getSupportedPlugins() != null) {
            for (Map.Entry<String, Set<String>> pdcEntry : node.getSupportedPlugins().entrySet()) {
                for (String pluginID : pdcEntry.getValue()) {
                    if (!node.getPluginDatas().containsKey(pluginID)) continue;
                    newNode.addSupportedPlugin(pdcEntry.getKey(), pluginID, node.getPluginDatas().get(pluginID));
                }
            }
        }
        assert (!this.nodes.containsKey(newNode.getID()));
        DefaultStructuralNodeData structureNode = new DefaultStructuralNodeData(newNode.getID(), ProcessConstants.NodeType.NT_NORMAL, 0, 0, 0, 0);
        this.nodeStructure.put(newNode.getID(), structureNode);
        this.nodes.put(newNode.getID(), newNode);
        return newNode;
    }

    @Override
    public Edge updateEdge(int srcNodeID, int destNodeID, Edge edge, ProcessConstants.EdgeProperty ... edgeProperty) {
        if (edge == null) {
            throw new NullArgumentException();
        }
        DefaultStructuredEdge orgEdge = null;
        for (StructuredEdge e : this.edges) {
            if (e.getSourceNodeID() != srcNodeID || e.getDestinationNodeID() != destNodeID || e.getEdgeType() != edge.getType()) continue;
            orgEdge = (DefaultStructuredEdge)e;
        }
        if (orgEdge == null) {
            throw new IllegalArgumentException("Edge does not exist");
        }
        ProcessConstants.EdgeProperty[] edgePropertyArray = edgeProperty;
        int n = edgeProperty.length;
        int n2 = 0;
        while (n2 < n) {
            ProcessConstants.EdgeProperty property = edgePropertyArray[n2];
            switch (property) {
                case EDGE_CODE: {
                    ((DefaultEdge)orgEdge.getEdge()).setEdgeCode(edge.getEdgeCode());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Edge Property " + (Object)((Object)property) + " can not be changed!");
                }
            }
            ++n2;
        }
        return orgEdge.getEdge();
    }

    @Override
    public void removeEdge(int srcNodeID, int destNodeID, ProcessConstants.EdgeType edgeType) {
        Iterator edgeIter = this.edges.iterator();
        while (edgeIter.hasNext()) {
            StructuredEdge edge = (StructuredEdge)edgeIter.next();
            if (edge.getSourceNodeID() != srcNodeID || edge.getDestinationNodeID() != destNodeID || edge.getEdgeType() != edgeType) continue;
            edgeIter.remove();
            this.getEdgeSet(srcNodeID).remove(edge);
            this.getEdgeSet(destNodeID).remove(edge);
            return;
        }
        throw new IllegalArgumentException("Edge not found!");
    }

    @Override
    public void removeConstraintEdge(int srcNodeID, int destNodeID) {
        Iterator edgeIter = this.constraintEdges.iterator();
        while (edgeIter.hasNext()) {
            StructuredConstraintEdge edge = (StructuredConstraintEdge)edgeIter.next();
            if (edge.getSourceNodeID() != srcNodeID || edge.getDestinationNodeID() != destNodeID) continue;
            edgeIter.remove();
            this.getEdgeSet(srcNodeID).remove(edge);
            this.getEdgeSet(destNodeID).remove(edge);
            return;
        }
        throw new IllegalArgumentException("Constraint Edge not found!");
    }

    @Override
    public DataElement updateDataElement(DataElement dataElement, ProcessConstants.DataElementProperty ... dataElementProperties) {
        ProcessConstants.DataElementProperty property;
        if (dataElement == null) {
            throw new NullArgumentException();
        }
        DefaultDataElement orgDataElement = (DefaultDataElement)this.getDataElement(dataElement.getID());
        if (orgDataElement == null) {
            throw new IllegalArgumentException("DataElement does not exist");
        }
        ProcessConstants.DataElementProperty[] dataElementPropertyArray = dataElementProperties;
        int n = dataElementProperties.length;
        int n2 = 0;
        while (n2 < n) {
            property = dataElementPropertyArray[n2];
            switch (property) {
                case NAME: {
                    if (dataElement.getName() != null) break;
                    throw new IllegalArgumentException("Invalid DataElement Property: Name is Null");
                }
                case DESCRIPTION: {
                    if (dataElement.getDescription() != null) break;
                    throw new IllegalArgumentException("Invalid DataElement Property: Description is Null");
                }
                case TYPE: {
                    if (dataElement.getDataType() != null) break;
                    throw new IllegalArgumentException("Invalid DataElement Property: Type is Null");
                }
                case USER_DEFINED_TYPE: 
                case IDENTIFIER: 
                case PUBLIC: 
                case VIRTUAL: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("DataElement Property can not be changed: " + (Object)((Object)property));
                }
            }
            ++n2;
        }
        dataElementPropertyArray = dataElementProperties;
        n = dataElementProperties.length;
        n2 = 0;
        while (n2 < n) {
            property = dataElementPropertyArray[n2];
            switch (property) {
                case NAME: {
                    orgDataElement.setName(dataElement.getName());
                    break;
                }
                case DESCRIPTION: {
                    orgDataElement.setDescription(dataElement.getDescription());
                    break;
                }
                case TYPE: {
                    orgDataElement.setType(dataElement.getDataType());
                    break;
                }
                case USER_DEFINED_TYPE: {
                    orgDataElement.setUserDefinedType(dataElement.getUDTName());
                    break;
                }
                case IDENTIFIER: {
                    orgDataElement.setIdentifierID(dataElement.getIdentifierID());
                    break;
                }
                case PUBLIC: {
                    orgDataElement.setPublic(dataElement.isPublic());
                    break;
                }
                case VIRTUAL: {
                    orgDataElement.setVirtual(dataElement.isVirtual());
                    break;
                }
                default: {
                    String msg = String.format("Unsupported property '%s'. Ignoring!", new Object[]{property});
                    LoggerTools.getLogger(this).finest(msg);
                }
            }
            ++n2;
        }
        return orgDataElement;
    }

    @Override
    public void removeDataElement(int dataElementID) {
        this.dataElements.remove(dataElementID);
    }

    @Override
    public DataEdge addDataEdge(int node, int connector, int dataElement, DataEdge dataEdge) {
        if (dataEdge == null) {
            throw new NullArgumentException();
        }
        if (!this.nodes.containsKey(node)) {
            throw new IllegalArgumentException("Node does not exists");
        }
        if (!this.dataElements.containsKey(dataElement)) {
            throw new IllegalArgumentException("DataElement does not exist");
        }
        List disabledConnectors = (List)this.nodeDisabledConnectors.get(node);
        if (disabledConnectors != null && disabledConnectors.contains(connector)) {
            throw new IllegalArgumentException("Connector " + connector + " is " + "marked as disabled. To connect " + "the data edge is not allowed.");
        }
        DefaultDataEdge newDataEdge = new DefaultDataEdge(dataEdge.getType(), dataEdge.isOptional());
        newDataEdge.setUserAttributes(dataEdge.getUserAttributes());
        DefaultStructuredDataEdge structuredDataEdge = new DefaultStructuredDataEdge(newDataEdge, node, connector, dataElement);
        this.dataEdges.add(structuredDataEdge);
        return newDataEdge;
    }

    @Override
    public DataEdge addDataEdge(int node, int dataElement, DataEdge dataEdge) {
        Node nodeElement = (Node)this.nodes.get(node);
        if (nodeElement == null) {
            throw new IllegalArgumentException("Node does not exists");
        }
        if (nodeElement.getExecutableBusinessProcess() instanceof Activity) {
            throw new RuntimeException("Node already has Activity assigned to it");
        }
        return this.addDataEdge(node, this.getFreeConnectorID(node), dataElement, dataEdge);
    }

    @Override
    public DataEdge updateDataEdge(int nodeID, int dataElementID, ActivityConstants.AccessType accessType, DataEdge dataEdge, ProcessConstants.DataEdgeProperty ... dataEdgeProperties) {
        if (dataEdge == null) {
            throw new NullArgumentException();
        }
        StructuredDataEdge orgDataEdge = this.getStructuredDataEdge(nodeID, dataElementID, accessType);
        if (orgDataEdge == null) {
            throw new IllegalArgumentException("Data Edge does not exist");
        }
        ProcessConstants.DataEdgeProperty[] dataEdgePropertyArray = dataEdgeProperties;
        int n = dataEdgeProperties.length;
        int n2 = 0;
        while (n2 < n) {
            ProcessConstants.DataEdgeProperty property = dataEdgePropertyArray[n2];
            switch (property) {
                case OPTIONAL: {
                    ((DefaultDataEdge)orgDataEdge.getDataEdge()).setOptional(dataEdge.isOptional());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("DataEdge Property " + (Object)((Object)property) + " cannot be changed!");
                }
            }
            ++n2;
        }
        return null;
    }

    @Override
    public void removeDataEdge(int node, int dataElement, ActivityConstants.AccessType dataEdgeType) {
        this.dataEdges.remove(this.getStructuredDataEdge(node, dataElement, dataEdgeType));
    }

    @Override
    public void updateUserAttribute(UserAttributeContainer container, String name, String value) {
        container.setUserAttributeValue(name, value);
    }

    @Override
    public void removeUserAttribute(UserAttributeContainer container, String name) {
        if (!(container instanceof DefaultUserAttributeContainer)) {
            throw new RuntimeException("Unknown UserAttributeContainer implementation encountered!");
        }
        ((DefaultUserAttributeContainer)container).removeUserAttributeValue(name);
    }

    @Override
    public void addMovedNode(int node) {
    }

    @Override
    public void setSupervisorAgent(QualifiedAgent supervisorAgent) {
        super.setSupervisorAgent(supervisorAgent);
    }

    @Override
    public void setName(String name) {
        super.setName(name);
    }

    @Override
    public void setDescription(String description) {
        super.setDescription(description);
    }

    @Override
    public void setConfigurationDescription(ConfigurationDescription desc) {
        super.setConfigurationDescription(desc);
    }

    @Override
    public void setConfiguration(Configuration conf) {
        super.setConfiguration(conf);
    }

    @Override
    public void setTestConfiguration(Configuration conf) {
        super.setTestConfiguration(conf);
    }

    @Override
    public void setInstanceNameTemplate(String instanceNameTemplate) {
        super.setInstanceNameTemplate(instanceNameTemplate);
    }

    @Override
    public void setInputParameters(Set<ProcessModelParameter> inputParameters) {
        this.addInputParameters(inputParameters);
    }

    @Override
    public void setOutputParameters(Set<ProcessModelParameter> outputParameters) {
        this.addOutputParameters(outputParameters);
    }

    @Override
    protected void addNodes(Collection<Node> nodes) {
        super.addNodes(nodes);
        for (Node node : nodes) {
            int n = node.getID();
            if (n < this.maxNodeID) continue;
            this.maxNodeID = n + 1;
        }
    }

    @Override
    protected void addDataElements(Collection<DataElement> elements) {
        super.addDataElements(elements);
        for (DataElement element : elements) {
            int n = element.getID();
            if (n < this.maxDataElementID) continue;
            this.maxDataElementID = n + 1;
        }
    }

    @Override
    protected void addNodeStructure(Map<Integer, ProcessModelFactory.StructuralNodeData> structuralNodeData) {
        super.addNodeStructure(structuralNodeData);
        for (ProcessModelFactory.StructuralNodeData nd : structuralNodeData.values()) {
            if (nd.getBranchID() < this.maxBranchID) continue;
            this.maxBranchID = nd.getBranchID() + 1;
        }
    }

    private int getFreeConnectorID(int nodeID) {
        int freeConnectorID = 0;
        HashSet<Integer> usedConnectorIDs = new HashSet<Integer>();
        ActivityConstants.AccessType[] accessTypeArray = ActivityConstants.AccessType.values();
        int n = accessTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ActivityConstants.AccessType accessType = accessTypeArray[n2];
            for (int connectorID : this.getNode(nodeID).getConnectorMapping(accessType).values()) {
                usedConnectorIDs.add(connectorID);
            }
            ++n2;
        }
        for (StructuredDataEdge dataEdge : this.dataEdges) {
            if (dataEdge.getNodeID() != nodeID) continue;
            usedConnectorIDs.add(dataEdge.getConnectorID());
        }
        while (usedConnectorIDs.contains(freeConnectorID)) {
            ++freeConnectorID;
        }
        return freeConnectorID;
    }

    public static int topologicalSorting(Template template, Node blockStartNode, Node blockEndNode, Map<Integer, Integer> topologicalSorting, int number) {
        int num = number;
        Node nodeToHandle = blockStartNode;
        while (nodeToHandle != null && !nodeToHandle.equals(blockEndNode)) {
            topologicalSorting.put(nodeToHandle.getID(), num);
            ++num;
            int[] successors = template.getSuccByEdgeType(nodeToHandle.getID(), ProcessConstants.EdgeType.ET_CONTROL);
            switch (template.getNodeType(nodeToHandle.getID())) {
                case NT_AND_SPLIT: 
                case NT_XOR_SPLIT: {
                    Node correspondingBlockNode = template.getNode(template.getNodeCorrespondingBlockNodeID(nodeToHandle.getID()));
                    int[] nArray = successors;
                    int n = successors.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int successor = nArray[n2];
                        num = DefaultChangeableTemplate.topologicalSorting(template, template.getNode(successor), correspondingBlockNode, topologicalSorting, num);
                        ++n2;
                    }
                    nodeToHandle = correspondingBlockNode;
                    break;
                }
                default: {
                    nodeToHandle = successors.length > 0 ? template.getNode(successors[0]) : null;
                }
            }
        }
        return num;
    }

    public static Map<Integer, Integer> returnTopologicalSorting(Template template) {
        HashMap<Integer, Integer> topologicalSorting = new HashMap<Integer, Integer>();
        int number = DefaultChangeableTemplate.topologicalSorting(template, template.getStartNode(), template.getEndNode(), topologicalSorting, 0);
        topologicalSorting.put(template.getEndNode().getID(), number);
        assert ((Integer)topologicalSorting.get(template.getEndNode().getID()) == template.getNodes().size() - 1) : "Assertion failed: the topological ID of the end node is not # nodes - 1!";
        return topologicalSorting;
    }

    @Override
    public void updatePluginDataContainer(PluginDataContainer pluginContainer, String extensionPointID, String pluginDataID, PluginData pluginData) {
        if (!(pluginContainer instanceof DefaultPluginDataContainer)) {
            throw new IllegalArgumentException("A DefaultPluginDataContainer was expected here!");
        }
        if (pluginData == null) {
            ((DefaultPluginDataContainer)pluginContainer).removeSupportedPlugin(pluginDataID);
        } else {
            ((DefaultPluginDataContainer)pluginContainer).addSupportedPlugin(extensionPointID, pluginDataID, pluginData);
        }
    }
}

