/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.processmodel.defaultimplementation;

import de.aristaflow.adept2.model.common.ActivityConfiguration;
import de.aristaflow.adept2.model.common.ExecutionControlProperties;
import de.aristaflow.adept2.model.common.ParameterChangePolicy;
import de.aristaflow.adept2.model.common.PluginDataContainer;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.EBPType;
import de.aristaflow.adept2.model.processmodel.Activity;
import de.aristaflow.adept2.model.processmodel.DecisionActivity;
import de.aristaflow.adept2.model.processmodel.DecisionStatement;
import de.aristaflow.adept2.model.processmodel.ProcessModelParameter;
import de.aristaflow.adept2.model.processmodel.defaultimplementation.DefaultActivity;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class DefaultDecisionActivity
extends DefaultActivity
implements DecisionActivity {
    private static final long serialVersionUID = 2726580064559897253L;
    private ProcessModelParameter decisionParameter;
    private HashMap<Long, DecisionStatement> decisionStatements;
    private HashMap<Long, Long> edgeCodes;
    private HashMap<Long, long[]> decisionIDs;

    public DefaultDecisionActivity(UUID id, String executableComponentName, String operationName, String configurationName, String name, String description, String implementationClass, Map<ActivityConstants.ActivityModelEntityType, List<String>> separatedClassPaths, boolean isSingleton, byte[] systemComponentSignature, String guiContextID, ExecutionControlProperties executionControlProperties, boolean supportsViewOnly, boolean supportsTestExecution, UUID iconID, Map<ActivityConstants.LocallyOverrideableActivityAttribute, ActivityConstants.ActivityModelEntityType> attributeOrigins, ActivityConfiguration configuration, ActivityConfiguration testConfiguration, ParameterChangePolicy parameterChangePolicy, Set<ProcessModelParameter> inputParameters, Set<ProcessModelParameter> outputParameters, PluginDataContainer pluginData, Map<String, String> userAttributes, ProcessModelParameter decisionParameter, Map<Long, Collection<DecisionStatement>> decisionMapping) {
        super(EBPType.DECISION_ACTIVITY, id, executableComponentName, operationName, configurationName, name, description, implementationClass, separatedClassPaths, isSingleton, systemComponentSignature, guiContextID, executionControlProperties, supportsViewOnly, supportsTestExecution, iconID, attributeOrigins, configuration, testConfiguration, parameterChangePolicy, inputParameters, outputParameters, pluginData, userAttributes);
        this.initialiseEdgeDecisionMappings(decisionMapping);
        this.setDecisionParameter(decisionParameter);
    }

    public DefaultDecisionActivity(Activity activity, ProcessModelParameter decisionParameter, Map<Long, Collection<DecisionStatement>> decisionMapping) {
        super(EBPType.DECISION_ACTIVITY, activity.getID(), activity.getExecutableComponentName(), activity.getOperationName(), activity.getConfigurationName(), activity.getActivityName(), activity.getDescription(), activity.getImplementationClass(), activity.getSeparatedClassPaths(), activity.isSingleton(), activity.getSystemComponent(), activity.getGUIContextID(), activity.getExecutionControlProperties(), activity.supportsViewOnly(), activity.supportsTestExecution(), activity.getIconID(), activity.getAttributeOrigins(), activity.getConfiguration(), activity.getTestConfiguration(), activity.getParameterChangePolicy(), activity.getParameters(ActivityConstants.AccessType.READ), activity.getParameters(ActivityConstants.AccessType.WRITE), activity, activity.getUserAttributes());
        this.initialiseEdgeDecisionMappings(decisionMapping);
        this.setDecisionParameter(decisionParameter);
    }

    @Override
    public long[] getDecisionIDs() {
        long[] result = new long[this.decisionStatements.values().size()];
        int i = 0;
        for (DecisionStatement d : this.decisionStatements.values()) {
            result[i++] = d.getDecisionID();
        }
        return result;
    }

    @Override
    public String getDecisionLabel(long decisionID) {
        return this.decisionStatements.get(decisionID).getDecisionLabel();
    }

    @Override
    public DecisionStatement getDecisionStatement(long decisionID) {
        return this.decisionStatements.get(decisionID);
    }

    @Override
    public ProcessModelParameter getDecisionParameter() {
        return this.decisionParameter;
    }

    private void setDecisionParameter(ProcessModelParameter decisionParameter) {
        this.decisionParameter = decisionParameter;
    }

    @Override
    public Collection<DecisionStatement> getAllDecisionStatements() {
        return Collections.unmodifiableCollection(this.decisionStatements.values());
    }

    @Override
    public long[] getDecisionID(long edgeCode) {
        return this.decisionIDs.get(edgeCode);
    }

    @Override
    public long getEdgeCode(long decisionID) {
        return this.edgeCodes.get(decisionID);
    }

    private void initialiseEdgeDecisionMappings(Map<Long, Collection<DecisionStatement>> edgeCodesForDecisionIDs) {
        this.decisionStatements = new HashMap();
        this.decisionIDs = new HashMap();
        this.edgeCodes = new HashMap(edgeCodesForDecisionIDs.size());
        for (Map.Entry<Long, Collection<DecisionStatement>> edgeCodes : edgeCodesForDecisionIDs.entrySet()) {
            long[] decisionIDs = new long[edgeCodes.getValue().size()];
            int i = 0;
            for (DecisionStatement statement : edgeCodes.getValue()) {
                this.decisionStatements.put(statement.getDecisionID(), statement);
                decisionIDs[i++] = statement.getDecisionID();
                this.edgeCodes.put(statement.getDecisionID(), edgeCodes.getKey());
            }
            this.decisionIDs.put(edgeCodes.getKey(), decisionIDs);
        }
    }
}

