/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.processmodel.defaultimplementation;

import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.ConstraintEdge;
import de.aristaflow.adept2.model.processmodel.DataEdge;
import de.aristaflow.adept2.model.processmodel.DataElement;
import de.aristaflow.adept2.model.processmodel.DeltaLayer;
import de.aristaflow.adept2.model.processmodel.Edge;
import de.aristaflow.adept2.model.processmodel.Node;
import de.aristaflow.adept2.model.processmodel.ProcessModelFactory;
import de.aristaflow.adept2.model.processmodel.StructuredConstraintEdge;
import de.aristaflow.adept2.model.processmodel.StructuredDataEdge;
import de.aristaflow.adept2.model.processmodel.StructuredEdge;
import de.aristaflow.adept2.model.processmodel.Template;
import de.aristaflow.adept2.model.processmodel.defaultimplementation.DefaultStructuralNodeData;
import de.aristaflow.adept2.model.processmodel.defaultimplementation.DefaultStructuredConstraintEdge;
import de.aristaflow.adept2.model.processmodel.defaultimplementation.DefaultStructuredDataEdge;
import de.aristaflow.adept2.model.processmodel.defaultimplementation.DefaultStructuredEdge;
import de.aristaflow.adept2.model.processmodel.tools.ProcessModelTools;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DefaultDeltaLayer
implements DeltaLayer {
    protected Template template;
    protected Map<Integer, Node> nodes = new HashMap<Integer, Node>();
    protected Map<Integer, ProcessModelFactory.StructuralNodeData> nodeStructures = new HashMap<Integer, ProcessModelFactory.StructuralNodeData>();
    protected Set<Integer> newNodes = new HashSet<Integer>();
    protected Set<Integer> deletedNodes = new HashSet<Integer>();
    protected Map<Integer, ChangedNodeProperties> changedNodeProperties = new LinkedHashMap<Integer, ChangedNodeProperties>();
    protected Set<Integer> changedNodes = new HashSet<Integer>();
    protected Set<Integer> movedNodes = new HashSet<Integer>();
    protected Map<Integer, DataElement> dataElements = new HashMap<Integer, DataElement>();
    protected Set<Integer> newDataElements = new HashSet<Integer>();
    protected Set<Integer> deletedDataElements = new HashSet<Integer>();
    protected Map<Integer, ChangedDataElementData> changedDataElements = new LinkedHashMap<Integer, ChangedDataElementData>();
    protected List<StructuredEdge> newEdges = new ArrayList<StructuredEdge>();
    protected List<StructuredEdge> deletedEdges = new ArrayList<StructuredEdge>();
    protected Map<StructuredEdge, DefaultStructuredChangedEdge> changedEdges = new HashMap<StructuredEdge, DefaultStructuredChangedEdge>();
    protected List<StructuredDataEdge> newDataEdges = new ArrayList<StructuredDataEdge>();
    protected List<StructuredDataEdge> deletedDataEdges = new ArrayList<StructuredDataEdge>();
    protected Map<StructuredDataEdge, ChangedDataEdge> changedDataEdges = new HashMap<StructuredDataEdge, ChangedDataEdge>();
    protected List<StructuredConstraintEdge> newConstraintEdges = new ArrayList<StructuredConstraintEdge>();
    protected List<StructuredConstraintEdge> deletedConstraintEdges = new ArrayList<StructuredConstraintEdge>();
    protected Map<StructuredConstraintEdge, DefaultStructuredChangedConstraintEdge> changedConstraintEdges = new HashMap<StructuredConstraintEdge, DefaultStructuredChangedConstraintEdge>();

    public DefaultDeltaLayer() {
    }

    public DefaultDeltaLayer(Template template) {
        this.setTemplate(template);
    }

    public void setTemplate(Template template) {
        if (template == null) {
            throw new RuntimeException("Template for delta layer cannot be null");
        }
        this.template = template;
    }

    public Template getTemplate() {
        return this.template;
    }

    private boolean arrayContains(Object[] array, Object o) {
        int i = 0;
        while (i < array.length) {
            if (array[i].equals(o)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public int[] getPredByEdgeType(ProcessConstants.DeltaScope scope, int node, ProcessConstants.EdgeType ... type) {
        switch (scope) {
            case NEW: {
                return ProcessModelTools.integerToIntArray(this.getPredNodeIDs(this.newEdges, node, type));
            }
            case DELETED: {
                return ProcessModelTools.integerToIntArray(this.getPredNodeIDs(this.deletedEdges, node, type));
            }
        }
        throw new RuntimeException("Edge not found!");
    }

    private List<Integer> getPredNodeIDs(List<StructuredEdge> edgeList, int node, ProcessConstants.EdgeType[] type) {
        ArrayList<Integer> pred = new ArrayList<Integer>();
        for (StructuredEdge edge : edgeList) {
            if (edge.getDestinationNodeID() != node || type.length != 0 && !this.arrayContains((Object[])type, (Object)edge.getEdgeType())) continue;
            pred.add(edge.getSourceNodeID());
        }
        return pred;
    }

    @Override
    public int[] getSuccByEdgeType(ProcessConstants.DeltaScope scope, int node, ProcessConstants.EdgeType ... type) {
        switch (scope) {
            case NEW: {
                return ProcessModelTools.integerToIntArray(this.getSuccNodeIDs(this.newEdges, node, type));
            }
            case DELETED: {
                return ProcessModelTools.integerToIntArray(this.getSuccNodeIDs(this.deletedEdges, node, type));
            }
        }
        return new int[0];
    }

    private List<Integer> getSuccNodeIDs(List<StructuredEdge> edgeList, int node, ProcessConstants.EdgeType[] type) {
        ArrayList<Integer> pred = new ArrayList<Integer>();
        for (StructuredEdge edge : edgeList) {
            if (edge.getSourceNodeID() != node || type.length != 0 && !this.arrayContains((Object[])type, (Object)edge.getEdgeType())) continue;
            pred.add(edge.getDestinationNodeID());
        }
        return pred;
    }

    @Override
    public int[] getNodes(ProcessConstants.DeltaScope scope) {
        switch (scope) {
            case NEW: {
                return ProcessModelTools.integerToIntArray(this.newNodes);
            }
            case DELETED: {
                return ProcessModelTools.integerToIntArray(this.deletedNodes);
            }
            case CHANGED: {
                return ProcessModelTools.integerToIntArray(this.changedNodes);
            }
            case MOVED: {
                return ProcessModelTools.integerToIntArray(this.movedNodes);
            }
        }
        return new int[0];
    }

    @Override
    public Set<StructuredEdge> getEdges(ProcessConstants.DeltaScope scope, ProcessConstants.EdgeType ... edgeTypes) {
        switch (scope) {
            case NEW: {
                if (edgeTypes.length == 0) {
                    return new HashSet<StructuredEdge>(this.newEdges);
                }
                return Collections.unmodifiableSet(this.getEdgesOfType(this.newEdges, edgeTypes));
            }
            case DELETED: {
                if (edgeTypes.length == 0) {
                    return new HashSet<StructuredEdge>(this.deletedEdges);
                }
                return Collections.unmodifiableSet(this.getEdgesOfType(this.deletedEdges, edgeTypes));
            }
            case CHANGED: {
                if (edgeTypes.length == 0) {
                    return new HashSet<StructuredEdge>(this.changedEdges.values());
                }
                return Collections.unmodifiableSet(this.getEdgesOfType(this.changedEdges.values(), edgeTypes));
            }
        }
        return Collections.emptySet();
    }

    private Set<StructuredEdge> getEdgesOfType(Collection<? extends StructuredEdge> edges, ProcessConstants.EdgeType ... edgeTypes) {
        HashSet<StructuredEdge> result = new HashSet<StructuredEdge>();
        block0: for (StructuredEdge structuredEdge : edges) {
            ProcessConstants.EdgeType[] edgeTypeArray = edgeTypes;
            int n = edgeTypes.length;
            int n2 = 0;
            while (n2 < n) {
                ProcessConstants.EdgeType edgeType = edgeTypeArray[n2];
                if (edgeType.equals((Object)structuredEdge.getEdgeType())) {
                    result.add(structuredEdge);
                    continue block0;
                }
                ++n2;
            }
        }
        return result;
    }

    @Override
    public Set<StructuredDataEdge> getDataEdges(ProcessConstants.DeltaScope scope) {
        switch (scope) {
            case NEW: {
                return Collections.unmodifiableSet(new HashSet<StructuredDataEdge>(this.newDataEdges));
            }
            case DELETED: {
                return Collections.unmodifiableSet(new HashSet<StructuredDataEdge>(this.deletedDataEdges));
            }
            case CHANGED: {
                return Collections.unmodifiableSet(new HashSet<ChangedDataEdge>(this.changedDataEdges.values()));
            }
        }
        return Collections.emptySet();
    }

    @Override
    public int[] getDataElements(ProcessConstants.DeltaScope scope) {
        switch (scope) {
            case NEW: {
                return ProcessModelTools.integerToIntArray(this.newDataElements);
            }
            case DELETED: {
                return ProcessModelTools.integerToIntArray(this.deletedDataElements);
            }
            case CHANGED: {
                return ProcessModelTools.integerToIntArray(this.changedDataElements.keySet());
            }
        }
        return new int[0];
    }

    @Override
    public ProcessConstants.NodeProperty[] getChangedNodeProperties(int nodeID) {
        ChangedNodeProperties changedNode = this.changedNodeProperties.get(nodeID);
        return (ProcessConstants.NodeProperty[])changedNode.changedProperties.clone();
    }

    @Override
    public ProcessConstants.ExecutableBusinessProcessProperty[] getChangedEBPProperties(int nodeID) {
        ChangedNodeProperties changedNode = this.changedNodeProperties.get(nodeID);
        return (ProcessConstants.ExecutableBusinessProcessProperty[])changedNode.changedEBPProperties.clone();
    }

    @Override
    public ProcessConstants.EdgeProperty[] getChangedEdgeProperties(int sourceNodeID, int destinationNodeID, ProcessConstants.EdgeType edgeType) {
        DefaultStructuredChangedEdge edge = this.findEdge(sourceNodeID, destinationNodeID, edgeType, this.changedEdges);
        assert (edge != null);
        return (ProcessConstants.EdgeProperty[])edge.changedProperty.clone();
    }

    protected DefaultStructuredChangedEdge findEdge(int sourceNodeID, int destinationNodeID, ProcessConstants.EdgeType edgeType, Map<StructuredEdge, DefaultStructuredChangedEdge> edgeList) {
        for (DefaultStructuredChangedEdge edge : edgeList.values()) {
            if (edge.getSourceNodeID() != sourceNodeID || edge.getDestinationNodeID() != destinationNodeID || edge.getEdgeType() != edgeType) continue;
            return edge;
        }
        return null;
    }

    protected StructuredEdge findEdge(int sourceNodeID, int destinationNodeID, ProcessConstants.EdgeType edgeType, List<StructuredEdge> edgeList) {
        for (StructuredEdge edge : edgeList) {
            if (edge.getSourceNodeID() != sourceNodeID || edge.getDestinationNodeID() != destinationNodeID || edge.getEdgeType() != edgeType) continue;
            return edge;
        }
        return null;
    }

    @Override
    public ProcessConstants.DataEdgeProperty[] getChangedEdgeProperties(int nodeID, int dataElementID, ActivityConstants.AccessType type) {
        ChangedDataEdge edge = this.findDataEdge(nodeID, dataElementID, type, this.changedDataEdges);
        if (edge == null) {
            throw new RuntimeException("Data edge has not been changed!");
        }
        return (ProcessConstants.DataEdgeProperty[])edge.changedProperty.clone();
    }

    protected ChangedDataEdge findDataEdge(int nodeID, int dataElementID, ActivityConstants.AccessType edgeType, Map<StructuredDataEdge, ChangedDataEdge> edgeList) {
        for (ChangedDataEdge edge : edgeList.values()) {
            if (edge.getNodeID() != nodeID || edge.getDataElementID() != dataElementID || edge.getDataEdgeType() != edgeType) continue;
            return edge;
        }
        return null;
    }

    protected StructuredDataEdge findDataEdge(int nodeID, int dataElementID, ActivityConstants.AccessType edgeType, List<StructuredDataEdge> edgeList) {
        for (StructuredDataEdge edge : edgeList) {
            if (edge.getNodeID() != nodeID || edge.getDataElementID() != dataElementID || edge.getDataEdgeType() != edgeType) continue;
            return edge;
        }
        return null;
    }

    @Override
    public ProcessConstants.DataElementProperty[] getChangedDataElementProperties(int dataElementID) {
        ChangedDataElementData dataElement = this.changedDataElements.get(dataElementID);
        if (dataElement == null) {
            throw new RuntimeException("Data element has not been changed!");
        }
        return (ProcessConstants.DataElementProperty[])dataElement.changedProperty.clone();
    }

    public void addNode(Node node, ProcessConstants.NodeType type, int topologicalID, int branchID, int splitNodeID, int correspondingBlockNodeID) {
        this.nodes.put(node.getID(), node);
        this.nodeStructures.put(node.getID(), new DefaultStructuralNodeData(node.getID(), type, topologicalID, branchID, splitNodeID, correspondingBlockNodeID));
        this.newNodes.add(node.getID());
    }

    public void deleteNode(int nodeID) {
        this.deletedNodes.add(nodeID);
    }

    public void moveNode(int nodeID) {
        this.movedNodes.add(nodeID);
    }

    public void changeNodeProperties(Node node, ProcessConstants.NodeProperty[] changedProperties, ProcessConstants.ExecutableBusinessProcessProperty[] changedEBPProperties) {
        boolean added = false;
        if (changedProperties != null && changedProperties.length != 0) {
            this.changedNodes.add(node.getID());
            added = true;
        }
        if (changedEBPProperties != null && changedEBPProperties.length != 0 && !added) {
            this.changedNodes.add(node.getID());
        }
        this.nodes.put(node.getID(), node);
        this.changedNodeProperties.put(node.getID(), new ChangedNodeProperties(changedProperties, changedEBPProperties));
    }

    @Deprecated
    protected void changeStructuralNodeProperties(int nodeID, ProcessConstants.NodeType type, int topologicalID, int branchID, int splitNodeID, int correspondingBlockNodeID) {
        this.changedNodes.add(nodeID);
        this.nodeStructures.put(nodeID, new DefaultStructuralNodeData(nodeID, type, topologicalID, branchID, splitNodeID, correspondingBlockNodeID));
    }

    public void addDataElement(DataElement dataElement) {
        this.dataElements.put(dataElement.getID(), dataElement);
        this.newDataElements.add(dataElement.getID());
    }

    public void deleteDataElement(int dataElementID) {
        this.deletedDataElements.add(dataElementID);
    }

    public void changeDataElement(DataElement dataElement, ProcessConstants.DataElementProperty ... changedProperties) {
        this.changedDataElements.put(dataElement.getID(), new ChangedDataElementData(changedProperties));
        this.dataElements.put(dataElement.getID(), dataElement);
    }

    public void addEdge(Edge edge, int srcID, int destID) {
        this.newEdges.add(new DefaultStructuredEdge(edge, srcID, destID));
    }

    public void deleteEdge(int srcID, int destID, ProcessConstants.EdgeType edgeType) {
        this.deletedEdges.add(new DefaultStructuredEdge(this.template.getEdge(srcID, destID, edgeType), srcID, destID, edgeType));
    }

    public void changeEdge(Edge edge, int srcID, int destID, ProcessConstants.EdgeType type, ProcessConstants.EdgeProperty ... changedProperties) {
        this.changedEdges.put(new DefaultStructuredEdge(null, srcID, destID, type), new DefaultStructuredChangedEdge(edge, srcID, destID, changedProperties));
    }

    public void addDataEdge(DataEdge edge, int nodeID, int dataElementID, int connectorID) {
        this.newDataEdges.add(new DefaultStructuredDataEdge(edge, nodeID, connectorID, dataElementID));
    }

    public void deleteDataEdge(int nodeID, int dataElementID, int connectorID, ActivityConstants.AccessType type) {
        this.deletedDataEdges.add(new DefaultStructuredDataEdge(this.template.getDataEdge(nodeID, dataElementID, type), nodeID, connectorID, dataElementID, type));
    }

    public void changeDataEdge(DataEdge edge, int nodeID, int dataElementID, int connectorID, ActivityConstants.AccessType type, ProcessConstants.DataEdgeProperty ... changedProperties) {
        this.changedDataEdges.put(new DefaultStructuredDataEdge(null, nodeID, connectorID, dataElementID, type), new ChangedDataEdge(edge, nodeID, connectorID, dataElementID, changedProperties));
    }

    @Override
    public Set<StructuredConstraintEdge> getConstraintEdges(ProcessConstants.DeltaScope scope) {
        switch (scope) {
            case NEW: {
                return Collections.unmodifiableSet(new HashSet<StructuredConstraintEdge>(this.newConstraintEdges));
            }
            case DELETED: {
                return Collections.unmodifiableSet(new HashSet<StructuredConstraintEdge>(this.deletedConstraintEdges));
            }
            case CHANGED: {
                return Collections.unmodifiableSet(new HashSet<DefaultStructuredChangedConstraintEdge>(this.changedConstraintEdges.values()));
            }
        }
        return Collections.emptySet();
    }

    public void changeConstraintEdge(ConstraintEdge edge, int startNodeID, int destNodeID, ProcessConstants.ConstraintEdgeProperty ... changedProperties) {
        this.changedConstraintEdges.put(new DefaultStructuredConstraintEdge(null, startNodeID, destNodeID), new DefaultStructuredChangedConstraintEdge(edge, startNodeID, destNodeID, changedProperties));
    }

    protected DefaultStructuredChangedConstraintEdge findConstraintEdge(int sourceNodeID, int destinationNodeID, Map<StructuredConstraintEdge, DefaultStructuredChangedConstraintEdge> edgeList) {
        for (DefaultStructuredChangedConstraintEdge edge : edgeList.values()) {
            if (edge.getSourceNodeID() != sourceNodeID || edge.getDestinationNodeID() != destinationNodeID) continue;
            return edge;
        }
        return null;
    }

    protected StructuredConstraintEdge findConstraintEdge(int sourceNodeID, int destinationNodeID, List<StructuredConstraintEdge> edgeList) {
        for (StructuredConstraintEdge edge : edgeList) {
            if (edge.getSourceNodeID() != sourceNodeID || edge.getDestinationNodeID() != destinationNodeID) continue;
            return edge;
        }
        return null;
    }

    public static final class ChangedDataEdge
    extends DefaultStructuredDataEdge {
        private static final long serialVersionUID = -7556667161976039226L;
        ProcessConstants.DataEdgeProperty[] changedProperty;

        public ChangedDataEdge(DataEdge edge, int nodeID, int connectorID, int dataElementID, ProcessConstants.DataEdgeProperty ... changedProperty) {
            super(edge, nodeID, connectorID, dataElementID);
            this.changedProperty = (ProcessConstants.DataEdgeProperty[])changedProperty.clone();
        }
    }

    public static final class ChangedDataElementData {
        ProcessConstants.DataElementProperty[] changedProperty;

        public ChangedDataElementData(ProcessConstants.DataElementProperty ... changedProperty) {
            this.changedProperty = (ProcessConstants.DataElementProperty[])changedProperty.clone();
        }
    }

    public static final class ChangedNodeProperties {
        ProcessConstants.NodeProperty[] changedProperties = new ProcessConstants.NodeProperty[0];
        ProcessConstants.ExecutableBusinessProcessProperty[] changedEBPProperties = new ProcessConstants.ExecutableBusinessProcessProperty[0];

        public ChangedNodeProperties(ProcessConstants.NodeProperty[] changedProperties, ProcessConstants.ExecutableBusinessProcessProperty[] changedEBPProperties) {
            if (changedProperties != null) {
                this.changedProperties = (ProcessConstants.NodeProperty[])changedProperties.clone();
            }
            if (changedEBPProperties != null) {
                this.changedEBPProperties = (ProcessConstants.ExecutableBusinessProcessProperty[])changedEBPProperties.clone();
            }
        }
    }

    public static final class DefaultStructuredChangedConstraintEdge
    extends DefaultStructuredConstraintEdge {
        private static final long serialVersionUID = -186488247176259495L;
        ProcessConstants.ConstraintEdgeProperty[] changedProperty;

        public DefaultStructuredChangedConstraintEdge(ConstraintEdge edge, int source, int destination, ProcessConstants.ConstraintEdgeProperty ... changedProperty) {
            super(edge, source, destination);
            this.changedProperty = (ProcessConstants.ConstraintEdgeProperty[])changedProperty.clone();
        }
    }

    public static final class DefaultStructuredChangedEdge
    extends DefaultStructuredEdge {
        private static final long serialVersionUID = -186488247176259495L;
        ProcessConstants.EdgeProperty[] changedProperty;

        public DefaultStructuredChangedEdge(Edge edge, int source, int destination, ProcessConstants.EdgeProperty ... changedProperty) {
            super(edge, source, destination);
            this.changedProperty = (ProcessConstants.EdgeProperty[])changedProperty.clone();
        }
    }
}

