/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.processmodel.defaultimplementation;

import de.aristaflow.adept2.model.globals.EBPType;
import de.aristaflow.adept2.model.processmodel.EBPInstanceReference;
import de.aristaflow.adept2.util.ArgChecks;
import java.net.URI;
import java.util.Arrays;
import java.util.UUID;

public class DefaultEBPInstanceReference
implements EBPInstanceReference {
    private static final long serialVersionUID = 3745845455437644128L;
    private final EBPType type;
    private UUID instanceID;
    private final UUID baseTemplateID;
    private final int nodeID;
    private final int nodeIteration;
    private final boolean isActivity;
    private final URI[] executionManagerURIs;
    private URI[] runtimeManagerURIs;

    public DefaultEBPInstanceReference(EBPType type, UUID instanceID, UUID baseTemplateID, int nodeID, int nodeIteration, boolean isActivity, URI[] executionManagerURIs) {
        ArgChecks.checkForNull((Object)type, "type");
        ArgChecks.checkForNull(instanceID, "instanceID");
        ArgChecks.checkForNull(baseTemplateID, "baseTemplateID");
        if (nodeIteration != Integer.MIN_VALUE) {
            ArgChecks.checkForNegative(nodeIteration, "nodeIteration");
        }
        ArgChecks.checkForNulls(executionManagerURIs, "executionManagerURIs");
        this.type = type;
        this.instanceID = instanceID;
        this.baseTemplateID = baseTemplateID;
        this.nodeID = nodeID;
        this.nodeIteration = nodeIteration;
        this.isActivity = isActivity;
        this.executionManagerURIs = (URI[])executionManagerURIs.clone();
    }

    public DefaultEBPInstanceReference(EBPType type, UUID instanceID, UUID baseTemplateID, int nodeID, int nodeIteration, boolean isActivity, URI[] executionManagerURIs, URI[] runtimeManagerURIs) {
        ArgChecks.checkForNull((Object)type, "type");
        ArgChecks.checkForNull(instanceID, "instanceID");
        ArgChecks.checkForNull(baseTemplateID, "baseTemplateID");
        ArgChecks.checkForNegative(nodeIteration, "nodeIteration");
        ArgChecks.checkForNulls(executionManagerURIs, "executionManagerURIs");
        this.type = type;
        this.instanceID = instanceID;
        this.baseTemplateID = baseTemplateID;
        this.nodeID = nodeID;
        this.nodeIteration = nodeIteration;
        this.isActivity = isActivity;
        this.executionManagerURIs = (URI[])executionManagerURIs.clone();
        this.setRuntimeManagerURIs(runtimeManagerURIs);
    }

    @Override
    public EBPType getType() {
        return this.type;
    }

    @Override
    public UUID getInstanceID() {
        return this.instanceID;
    }

    @Override
    public UUID getBaseTemplateID() {
        return this.baseTemplateID;
    }

    @Override
    public int getNodeID() {
        return this.nodeID;
    }

    @Override
    public int getNodeIteration() {
        return this.nodeIteration;
    }

    @Override
    public boolean isActivity() {
        return this.isActivity;
    }

    @Override
    public URI[] getExecutionManagerURIs() {
        return (URI[])this.executionManagerURIs.clone();
    }

    @Override
    public URI[] getRuntimeManagerURIs() {
        if (this.runtimeManagerURIs == null) {
            return null;
        }
        return (URI[])this.runtimeManagerURIs.clone();
    }

    @Override
    public void setRuntimeManagerURIs(URI[] runtimeManagerURIs) {
        if (runtimeManagerURIs == null) {
            this.runtimeManagerURIs = null;
        } else {
            ArgChecks.checkForNulls(runtimeManagerURIs, "runtimeManagerURIs");
            this.runtimeManagerURIs = (URI[])runtimeManagerURIs.clone();
        }
    }

    @Override
    public boolean equals(Object otherObject) {
        boolean ret = false;
        if (otherObject instanceof EBPInstanceReference) {
            EBPInstanceReference otherEBP = (EBPInstanceReference)otherObject;
            ret = this.instanceID.equals(otherEBP.getInstanceID()) && this.baseTemplateID.equals(otherEBP.getBaseTemplateID()) && this.nodeID == otherEBP.getNodeID() && this.nodeIteration == otherEBP.getNodeIteration() && this.isActivity == otherEBP.isActivity() && this.type == otherEBP.getType() && Arrays.equals(this.executionManagerURIs, otherEBP.getExecutionManagerURIs());
        }
        return ret;
    }

    @Override
    public int hashCode() {
        int ret = this.instanceID.hashCode() ^ this.baseTemplateID.hashCode() ^ this.nodeID ^ this.nodeIteration ^ Boolean.valueOf(this.isActivity).hashCode() ^ this.type.hashCode() ^ Arrays.hashCode(this.executionManagerURIs);
        return ret;
    }

    public String toString() {
        return String.format("Referenced executable business process: %1$s, %2$s, %3$s, %4$s, %5$s", Arrays.toString(this.getExecutionManagerURIs()), this.getInstanceID(), this.getNodeID(), this.getNodeIteration(), Arrays.toString(this.getRuntimeManagerURIs()));
    }
}

